/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceDetailAccountObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.document.CGInvoiceDocumentTestBase;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.InvoiceBillFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceDetailAccountObjectCodeFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceMilestoneFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.wklykins)
public class InvoiceCorrectionTest
extends CGInvoiceDocumentTestBase {
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected DateTimeService dateTimeService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    public void testGeneralCorrection() throws WorkflowException {
        for (InvoiceAddressDetail invoiceAddressDetail : this.document.getInvoiceAddressDetails()) {
            invoiceAddressDetail.setInitialTransmissionDate(this.dateTimeService.getCurrentSqlDate());
        }
        this.document.getInvoiceGeneralDetail().setFinalBillIndicator(true);
        this.contractsGrantsInvoiceDocumentService.correctContractsGrantsInvoiceDocument(this.document);
        for (InvoiceAddressDetail invoiceAddressDetail : this.document.getInvoiceAddressDetails()) {
            InvoiceCorrectionTest.assertNull((Object)invoiceAddressDetail.getInitialTransmissionDate());
        }
        this.contractsGrantsInvoiceDocumentService.updateUnfinalizationToAwardAccount(this.document.getAccountDetails(), this.document.getInvoiceGeneralDetail().getProposalNumber());
        for (InvoiceAccountDetail id : this.document.getAccountDetails()) {
            HashMap<String, Object> mapKey = new HashMap<String, Object>();
            mapKey.put("accountNumber", id.getAccountNumber());
            mapKey.put("chartOfAccountsCode", id.getChartOfAccountsCode());
            mapKey.put("proposalNumber", this.document.getInvoiceGeneralDetail().getProposalNumber());
            ContractsAndGrantsBillingAwardAccount awardAccount = (ContractsAndGrantsBillingAwardAccount)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAwardAccount.class, mapKey);
            InvoiceCorrectionTest.assertFalse((boolean)awardAccount.isFinalBilledIndicator());
        }
    }

    public void testCorrectedMilestones() throws WorkflowException {
        this.document.getInvoiceGeneralDetail().setBillingFrequencyCode("MILE");
        this.documentService.saveDocument((Document)this.document);
        String documentNumber = this.document.getDocumentNumber();
        Long proposalNumber = this.document.getInvoiceGeneralDetail().getProposalNumber();
        this.setupMilestones(documentNumber, proposalNumber, true);
        ArrayList<InvoiceMilestone> milestones = new ArrayList<InvoiceMilestone>();
        InvoiceMilestone invMilestone_2 = InvoiceMilestoneFixture.INV_MLSTN_1.createInvoiceMilestone();
        milestones.add(invMilestone_2);
        Iterator iterator = milestones.iterator();
        this.contractsGrantsInvoiceDocumentService.correctContractsGrantsInvoiceDocument(this.document);
        List correctedMilestones = this.document.getInvoiceMilestones();
        Iterator correctedIterator = correctedMilestones.iterator();
        while (iterator.hasNext() || correctedIterator.hasNext()) {
            InvoiceMilestone id = (InvoiceMilestone)iterator.next();
            InvoiceMilestone cid = (InvoiceMilestone)correctedIterator.next();
            InvoiceCorrectionTest.assertTrue((boolean)id.getMilestoneAmount().equals((Object)cid.getMilestoneAmount().negated()));
        }
        this.contractsGrantsInvoiceDocumentService.updateMilestonesBilledIndicator(false, this.document.getInvoiceMilestones());
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("proposalNumber", proposalNumber);
        List updatedMilestones = (List)this.boService.findMatching(Milestone.class, map);
        InvoiceCorrectionTest.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)updatedMilestones));
        if (CollectionUtils.isNotEmpty((Collection)updatedMilestones)) {
            Iterator iterator2 = updatedMilestones.iterator();
            while (iterator2.hasNext()) {
                InvoiceCorrectionTest.assertFalse((boolean)((Milestone)iterator2.next()).isBilled());
            }
        }
    }

    public void testCorrectedBills() throws WorkflowException {
        this.document.getInvoiceGeneralDetail().setBillingFrequencyCode("PDBS");
        this.documentService.saveDocument((Document)this.document);
        String documentNumber = this.document.getDocumentNumber();
        Long proposalNumber = this.document.getInvoiceGeneralDetail().getProposalNumber();
        this.setupBills(documentNumber, proposalNumber, true);
        ArrayList<InvoiceBill> bills = new ArrayList<InvoiceBill>();
        InvoiceBill invBill_2 = InvoiceBillFixture.INV_BILL_1.createInvoiceBill();
        bills.add(invBill_2);
        Iterator iterator = bills.iterator();
        this.contractsGrantsInvoiceDocumentService.correctContractsGrantsInvoiceDocument(this.document);
        List correctedBills = this.document.getInvoiceBills();
        Iterator correctedIterator = correctedBills.iterator();
        while (iterator.hasNext() || correctedIterator.hasNext()) {
            InvoiceBill id = (InvoiceBill)iterator.next();
            InvoiceBill cid = (InvoiceBill)correctedIterator.next();
            InvoiceCorrectionTest.assertTrue((boolean)id.getEstimatedAmount().equals((Object)cid.getEstimatedAmount().negated()));
        }
        this.contractsGrantsInvoiceDocumentService.updateBillsBilledIndicator(false, this.document.getInvoiceBills());
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("proposalNumber", proposalNumber);
        List updatedBills = (List)this.boService.findMatching(Bill.class, map);
        InvoiceCorrectionTest.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)updatedBills));
        if (CollectionUtils.isNotEmpty((Collection)updatedBills)) {
            Iterator iterator2 = updatedBills.iterator();
            while (iterator2.hasNext()) {
                InvoiceCorrectionTest.assertFalse((boolean)((Bill)iterator2.next()).isBilled());
            }
        }
    }

    public void testCorrectedInvoiceDetails() throws WorkflowException {
        List invoiceDetail = this.document.getDirectCostInvoiceDetails();
        this.contractsGrantsInvoiceDocumentService.correctContractsGrantsInvoiceDocument(this.document);
        List correctedInvoiceDetail = this.document.getDirectCostInvoiceDetails();
        Iterator iterator = invoiceDetail.iterator();
        Iterator correctedIterator = correctedInvoiceDetail.iterator();
        while (iterator.hasNext() || correctedIterator.hasNext()) {
            ContractsGrantsInvoiceDetail id = (ContractsGrantsInvoiceDetail)iterator.next();
            ContractsGrantsInvoiceDetail cid = (ContractsGrantsInvoiceDetail)correctedIterator.next();
            InvoiceCorrectionTest.assertTrue((boolean)id.getInvoiceAmount().equals((Object)cid.getInvoiceAmount().negated()));
        }
    }

    public void testCorrectedInvoiceDetailAccounts() throws WorkflowException {
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode_1 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD1.createInvoiceDetailAccountObjectCode();
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode_2 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD2.createInvoiceDetailAccountObjectCode();
        KualiDecimal value1 = new KualiDecimal(3.01);
        KualiDecimal value2 = new KualiDecimal(2.02);
        invoiceDetailAccountObjectCode_1.setCurrentExpenditures(value1);
        invoiceDetailAccountObjectCode_2.setCurrentExpenditures(value2);
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode_1);
        invoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode_2);
        this.document.setInvoiceDetailAccountObjectCodes(invoiceDetailAccountObjectCodes);
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode_3 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD1.createInvoiceDetailAccountObjectCode();
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode_4 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD2.createInvoiceDetailAccountObjectCode();
        invoiceDetailAccountObjectCode_3.setCurrentExpenditures(value1);
        invoiceDetailAccountObjectCode_4.setCurrentExpenditures(value2);
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodesOriginal = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodesOriginal.add(invoiceDetailAccountObjectCode_3);
        invoiceDetailAccountObjectCodesOriginal.add(invoiceDetailAccountObjectCode_4);
        this.contractsGrantsInvoiceDocumentService.correctContractsGrantsInvoiceDocument(this.document);
        List correctedInvoiceDetailAccountObjectCode = this.document.getInvoiceDetailAccountObjectCodes();
        Iterator iterator = invoiceDetailAccountObjectCodesOriginal.iterator();
        Iterator correctedIterator = correctedInvoiceDetailAccountObjectCode.iterator();
        while (iterator.hasNext() || correctedIterator.hasNext()) {
            InvoiceDetailAccountObjectCode id = (InvoiceDetailAccountObjectCode)iterator.next();
            InvoiceDetailAccountObjectCode cid = (InvoiceDetailAccountObjectCode)correctedIterator.next();
            InvoiceCorrectionTest.assertTrue((boolean)id.getCurrentExpenditures().equals((Object)cid.getCurrentExpenditures().negated()));
        }
    }

    public void testCorrectedAccountDetails() throws WorkflowException {
        List accountDetail = this.document.getAccountDetails();
        this.contractsGrantsInvoiceDocumentService.correctContractsGrantsInvoiceDocument(this.document);
        List correctedAccountDetail = this.document.getAccountDetails();
        Iterator iterator = accountDetail.iterator();
        Iterator correctedIterator = correctedAccountDetail.iterator();
        while (iterator.hasNext() || correctedIterator.hasNext()) {
            InvoiceAccountDetail id = (InvoiceAccountDetail)iterator.next();
            InvoiceAccountDetail cid = (InvoiceAccountDetail)correctedIterator.next();
            InvoiceCorrectionTest.assertTrue((boolean)id.getInvoiceAmount().equals((Object)cid.getInvoiceAmount().negated()));
        }
    }
}

