/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentTestUtil;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceWriteoffDocumentRule;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerInvoiceWriteoffDocumentRuleTest
extends KualiTestBase {
    public static Logger LOG = Logger.getLogger(CustomerInvoiceWriteoffDocumentRuleTest.class);
    private CustomerInvoiceWriteoffDocumentRule rule;
    private CustomerInvoiceWriteoffDocument document;
    private static final String VALID_CHART_OF_ACCOUNTS_CODE_FOR_PARM = "BL";
    private static final String INVALID_CHART_OF_ACCOUNTS_CODE_FOR_PARM = "XX";
    private static final String CHART_WRITEOFF_PARM_VALUE = "BL=5105";
    private static final String ORG_ACCT_DEFAULT_CHART = "UA";
    private static final String ORG_ACCT_DEFAULT_ORG = "VPIT";
    private static final String ORG_ACCT_DEFAULT_WRITEOFF_ACCT = "1031400";
    private static final String ORG_ACCT_DEFAULT_WRITEOFF_CHART = "BL";
    private static final String ORG_ACCT_DEFAULT_WRITEOFF_OBJECT_CODE = "1500";

    protected void setUp() throws Exception {
        super.setUp();
        this.rule = new CustomerInvoiceWriteoffDocumentRule();
        this.document = new CustomerInvoiceWriteoffDocument();
    }

    protected void tearDown() throws Exception {
        this.rule = null;
        this.document = null;
        super.tearDown();
    }

    public void testDoesChartCodeHaveCorrespondingWriteoffObjectCode_Valid() {
        TestUtils.setSystemParameter(CustomerInvoiceWriteoffDocument.class, (String)"GLPE_WRITEOFF_OBJECT_CODE_BY_CHART", (String)CHART_WRITEOFF_PARM_VALUE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setChartOfAccountsCode("BL");
        CustomerInvoiceWriteoffDocumentRuleTest.assertTrue((boolean)this.rule.doesChartCodeHaveCorrespondingWriteoffObjectCode(customerInvoiceDetail));
    }

    public void testDoesChartCodeHaveCorrespondingWriteoffObjectCode_Invalid() {
        TestUtils.setSystemParameter(CustomerInvoiceWriteoffDocument.class, (String)"GLPE_WRITEOFF_OBJECT_CODE_BY_CHART", (String)CHART_WRITEOFF_PARM_VALUE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setChartOfAccountsCode(INVALID_CHART_OF_ACCOUNTS_CODE_FOR_PARM);
        CustomerInvoiceWriteoffDocumentRuleTest.assertFalse((boolean)this.rule.doesChartCodeHaveCorrespondingWriteoffObjectCode(customerInvoiceDetail));
    }

    public void testDoesOrganizationAccountingDefaultHaveWriteoffInformation_Valid() throws WorkflowException {
        OrganizationAccountingDefault organizationAccountingDefault = new OrganizationAccountingDefault();
        organizationAccountingDefault.setChartOfAccountsCode(ORG_ACCT_DEFAULT_CHART);
        organizationAccountingDefault.setOrganizationCode(ORG_ACCT_DEFAULT_ORG);
        organizationAccountingDefault.setUniversityFiscalYear(((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear());
        organizationAccountingDefault.setWriteoffAccountNumber(ORG_ACCT_DEFAULT_WRITEOFF_ACCT);
        organizationAccountingDefault.setWriteoffFinancialObjectCode(ORG_ACCT_DEFAULT_WRITEOFF_OBJECT_CODE);
        organizationAccountingDefault.setWriteoffChartOfAccountsCode("BL");
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)organizationAccountingDefault);
        String customerInvoiceDocumentNumber = CustomerInvoiceDocumentTestUtil.submitNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER_WITH_BILLING_INFO, new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE}, null);
        CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument = new CustomerInvoiceWriteoffDocument();
        customerInvoiceWriteoffDocument.setFinancialDocumentReferenceInvoiceNumber(customerInvoiceDocumentNumber);
        CustomerInvoiceWriteoffDocumentRuleTest.assertTrue((boolean)this.rule.doesOrganizationAccountingDefaultHaveWriteoffInformation(customerInvoiceWriteoffDocument));
    }

    public void testDoesOrganizationAccountingDefaultHaveWriteoffInformation_Invalid() throws WorkflowException {
        String customerInvoiceDocumentNumber = CustomerInvoiceDocumentTestUtil.submitNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER_WITH_BILLING_INFO, new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE}, null);
        CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument = new CustomerInvoiceWriteoffDocument();
        customerInvoiceWriteoffDocument.setFinancialDocumentReferenceInvoiceNumber(customerInvoiceDocumentNumber);
        CustomerInvoiceWriteoffDocumentRuleTest.assertFalse((boolean)this.rule.doesOrganizationAccountingDefaultHaveWriteoffInformation(customerInvoiceWriteoffDocument));
        OrganizationAccountingDefault organizationAccountingDefault = new OrganizationAccountingDefault();
        organizationAccountingDefault.setChartOfAccountsCode(ORG_ACCT_DEFAULT_CHART);
        organizationAccountingDefault.setOrganizationCode(ORG_ACCT_DEFAULT_ORG);
        organizationAccountingDefault.setUniversityFiscalYear(((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear());
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)organizationAccountingDefault);
        CustomerInvoiceWriteoffDocumentRuleTest.assertFalse((boolean)this.rule.doesOrganizationAccountingDefaultHaveWriteoffInformation(customerInvoiceWriteoffDocument));
    }

    public void testDoesCustomerInvoiceDocumentHaveValidBalance_Valid() throws WorkflowException {
        String customerInvoiceDocumentNumber = CustomerInvoiceDocumentTestUtil.submitNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER_WITH_BILLING_INFO, new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE}, null);
        CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument = new CustomerInvoiceWriteoffDocument();
        customerInvoiceWriteoffDocument.setFinancialDocumentReferenceInvoiceNumber(customerInvoiceDocumentNumber);
        CustomerInvoiceWriteoffDocumentRuleTest.assertTrue((boolean)this.rule.doesCustomerInvoiceDocumentHaveValidBalance(customerInvoiceWriteoffDocument));
    }
}

