/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.util;

import java.util.ArrayList;
import java.util.Collection;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerInvoiceBalanceHelper {
    private CustomerInvoiceDocument invoice;
    private Collection<InvoicePaidApplied> invoicePaidApplieds;
    private Collection<CustomerInvoiceDetail> customerInvoiceDetails;

    public CustomerInvoiceBalanceHelper() {
    }

    public CustomerInvoiceBalanceHelper(CustomerInvoiceDocument invoice, Collection<InvoicePaidApplied> invoicePaidApplieds) {
        this.invoice = invoice;
        this.invoicePaidApplieds = new ArrayList<InvoicePaidApplied>(invoicePaidApplieds);
    }

    public KualiDecimal getCalculatedBalance() {
        return (KualiDecimal)this.invoice.getTotalDollarAmount().subtract((AbstractKualiDecimal)this.getTotalAppliedAmountForAppDoc());
    }

    public KualiDecimal getOpenAmount() {
        CustomerInvoiceDocumentService customerInvoiceDocumentService = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
        return customerInvoiceDocumentService.getOpenAmountForCustomerInvoiceDocument(this.invoice.getDocumentNumber());
    }

    public KualiDecimal getTotalAppliedAmountForAppDoc() {
        KualiDecimal appliedAmount = new KualiDecimal(0);
        for (InvoicePaidApplied invoicePaidApplied : this.invoicePaidApplieds) {
            appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)invoicePaidApplied.getInvoiceItemAppliedAmount());
        }
        return appliedAmount;
    }

    public CustomerInvoiceDocument getInvoice() {
        return this.invoice;
    }

    public void setInvoice(CustomerInvoiceDocument invoice) {
        this.invoice = invoice;
    }

    public Collection<InvoicePaidApplied> getInvoicePaidApplieds() {
        return this.invoicePaidApplieds;
    }

    public void setInvoicePaidApplieds(Collection<InvoicePaidApplied> invoicePaidApplieds) {
        this.invoicePaidApplieds = invoicePaidApplieds;
    }
}

