/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class VerifyBillingFrequencyServiceImpl
implements VerifyBillingFrequencyService {
    protected BusinessObjectService businessObjectService;
    protected AccountingPeriodService accountingPeriodService;
    protected UniversityDateService universityDateService;
    protected DateTimeService dateTimeService;
    protected static final Set<String> invalidPeriodCodes = new TreeSet<String>();

    @Override
    public boolean validateBillingFrequency(ContractsAndGrantsBillingAward award) {
        return this.validateBillingFrequency(award, award.getLastBilledDate());
    }

    @Override
    public boolean validateBillingFrequency(ContractsAndGrantsBillingAward award, ContractsAndGrantsBillingAwardAccount awardAccount) {
        return this.validateBillingFrequency(award, awardAccount.getCurrentLastBilledDate());
    }

    protected boolean validateBillingFrequency(ContractsAndGrantsBillingAward award, Date lastBilledDate) {
        Date today = this.getDateTimeService().getCurrentSqlDate();
        AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
        BillingPeriod billingPeriod = this.getStartDateAndEndDateOfPreviousBillingPeriod(award, currPeriod);
        if (!billingPeriod.isBillable()) {
            return false;
        }
        if (billingPeriod.getStartDate().after(billingPeriod.getEndDate())) {
            return false;
        }
        return this.calculateIfWithinGracePeriod(today, billingPeriod.getEndDate(), billingPeriod.getStartDate(), lastBilledDate, award.getBillingFrequency().getGracePeriodDays());
    }

    @Override
    public boolean calculateIfWithinGracePeriod(Date today, Date previousAccountingPeriodEndDate, Date previousAccountingPeriodStartDate, Date lastBilledDate, int gracePeriodDays) {
        if (previousAccountingPeriodEndDate == null || previousAccountingPeriodStartDate == null) {
            throw new IllegalArgumentException("invalid (null) previousAccountingPeriodEndDate or previousAccountingPeriodStartDate");
        }
        int todayAsComparableDate = this.comparableDateForm(today);
        int previousPeriodClose = this.comparableDateForm(previousAccountingPeriodEndDate);
        int previousPeriodBegin = this.comparableDateForm(previousAccountingPeriodStartDate);
        int lastBilled = -1;
        if (lastBilledDate != null) {
            lastBilled = this.comparableDateForm(lastBilledDate);
        }
        int gracePeriodClose = previousPeriodClose + gracePeriodDays;
        int gracePeriodAfterLastBilled = lastBilled + gracePeriodDays;
        return todayAsComparableDate >= previousPeriodBegin && gracePeriodClose <= todayAsComparableDate && (lastBilledDate == null || todayAsComparableDate > gracePeriodAfterLastBilled);
    }

    @Override
    public BillingPeriod getStartDateAndEndDateOfPreviousBillingPeriod(ContractsAndGrantsBillingAward award, AccountingPeriod currPeriod) {
        return BillingPeriod.determineBillingPeriodPriorTo(award.getAwardBeginningDate(), this.dateTimeService.getCurrentSqlDate(), award.getLastBilledDate(), award.getBillingFrequencyCode(), this.accountingPeriodService);
    }

    @Override
    public ArrayList<Date> getSortedListOfPeriodEndDatesOfCurrentFiscalYear(AccountingPeriod currPeriod) {
        ArrayList<Date> acctPeriodEndDateList = new ArrayList<Date>();
        HashMap<String, Comparable<Boolean>> fieldValues = new HashMap<String, Comparable<Boolean>>();
        fieldValues.put("active", Boolean.TRUE);
        fieldValues.put("universityFiscalYear", currPeriod.getUniversityFiscalYear());
        Collection acctPeriodList = this.businessObjectService.findMatching(AccountingPeriod.class, fieldValues);
        if (acctPeriodList != null) {
            for (AccountingPeriod acctPeriod : acctPeriodList) {
                if (this.isInvalidPeriodCode(acctPeriod)) continue;
                acctPeriodEndDateList.add(acctPeriod.getUniversityFiscalPeriodEndDate());
            }
            if (acctPeriodEndDateList == null || acctPeriodEndDateList.size() != 12) {
                String fiscalYear = "; fiscalYear: " + currPeriod.getUniversityFiscalYear();
                String size = "; size = " + (acctPeriodEndDateList == null ? "null" : Integer.valueOf(acctPeriodEndDateList.size()));
                throw new IllegalArgumentException("invalid (null) Accounting-Period-End-Date List" + fiscalYear + size);
            }
            Collections.sort(acctPeriodEndDateList);
            return acctPeriodEndDateList;
        }
        throw new IllegalArgumentException("invalid (null) Accounting-Period-End-Date List");
    }

    public int comparableDateForm(Date d) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        return cal.get(1) * 365 + cal.get(6);
    }

    public Date calculateNextDay(Date d) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        ((Calendar)cal).add(6, 1);
        return new Date(cal.getTimeInMillis());
    }

    protected boolean isInvalidPeriodCode(AccountingPeriod period) {
        String periodCode = period.getUniversityFiscalPeriodCode();
        if (StringUtils.isBlank((String)periodCode)) {
            throw new IllegalArgumentException("invalid (null) universityFiscalPeriodCode (" + periodCode + ")for" + period);
        }
        return invalidPeriodCodes.contains(periodCode);
    }

    public void setAccountingPeriodService(AccountingPeriodService accountingPeriodService) {
        this.accountingPeriodService = accountingPeriodService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    static {
        invalidPeriodCodes.add("13");
        invalidPeriodCodes.add("AB");
        invalidPeriodCodes.add("BB");
        invalidPeriodCodes.add("CB");
    }
}

