/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.module.ar.batch.service.CustomerInvoiceWriteoffBatchService;
import org.kuali.kfs.module.ar.batch.vo.CustomerInvoiceWriteoffBatchVO;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

@ConfigureContext
public class CustomerInvoiceWriteoffBatchServiceTest
extends KualiTestBase {
    private DateTimeService dateTimeService;
    private PersonService personService;
    private CustomerInvoiceWriteoffBatchService batchService;

    public void setUp() throws Exception {
        super.setUp();
        this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        this.batchService = (CustomerInvoiceWriteoffBatchService)SpringContext.getBean(CustomerInvoiceWriteoffBatchService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    public void testFilesDropCorrectly() {
        Person person = this.personService.getPersonByPrincipalName("kfs");
        CustomerInvoiceWriteoffBatchVO batchVO = this.createBatchVO(person);
        batchVO.setSubmittedOn(this.dateTimeService.getCurrentTimestamp().toString());
        batchVO.setNote("This is the user note added with the batch documents.");
        batchVO.addInvoiceNumber("1111111");
        batchVO.addInvoiceNumber("2222222");
        batchVO.addInvoiceNumber("3333333");
        String batchXmlFileName = this.batchService.createBatchDrop(person, batchVO);
        CustomerInvoiceWriteoffBatchServiceTest.assertTrue((String)"Returned xml file name should not be blank.", (boolean)StringUtils.isNotBlank((String)batchXmlFileName));
        File batchXML = new File(batchXmlFileName);
        CustomerInvoiceWriteoffBatchServiceTest.assertTrue((String)"Batch XML file should be present in the file system.", (boolean)batchXML.exists());
        CustomerInvoiceWriteoffBatchServiceTest.assertTrue((String)"Batch XML file should not be zero bytes.", (batchXML.length() > 0L ? 1 : 0) != 0);
    }

    private CustomerInvoiceWriteoffBatchVO createBatchVO(Person person) {
        CustomerInvoiceWriteoffBatchVO batchVO = new CustomerInvoiceWriteoffBatchVO(person.getPrincipalName());
        return batchVO;
    }
}

