/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CollectionEvent;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.TicklersReport;
import org.kuali.kfs.module.ar.businessobject.lookup.TicklersReportLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsCollectionActivityDocumentService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.module.ar.web.struts.TicklersReportLookupForm;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@ConfigureContext(session=UserNameFixture.wklykins)
public class TicklersReportLookupableHelperServiceImplTest
extends KualiTestBase {
    private static final String CHART_OF_ACCOUNTS_CODE = "BL";
    private static final String ORGANIZATION_CODE = "SRS";
    private static Logger LOG = Logger.getLogger(TicklersReportLookupableHelperServiceImplTest.class);
    private Person user;
    private RoleService roleService;
    private TicklersReportLookupableHelperServiceImpl ticklersReportLookupableHelperServiceImpl;
    private TicklersReportLookupForm ticklersReportLookupForm;
    private Map fieldValues;

    protected void setUp() throws Exception {
        super.setUp();
        this.ticklersReportLookupableHelperServiceImpl = new TicklersReportLookupableHelperServiceImpl();
        this.ticklersReportLookupableHelperServiceImpl.setBusinessObjectClass(TicklersReport.class);
        this.ticklersReportLookupableHelperServiceImpl.setContractsGrantsInvoiceDocumentService((ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class));
        this.ticklersReportLookupableHelperServiceImpl.setContractsGrantsCollectionActivityDocumentService((ContractsGrantsCollectionActivityDocumentService)SpringContext.getBean(ContractsGrantsCollectionActivityDocumentService.class));
        this.ticklersReportLookupableHelperServiceImpl.setContractsGrantsReportHelperService((ContractsGrantsReportHelperService)SpringContext.getBean(ContractsGrantsReportHelperService.class));
        this.ticklersReportLookupableHelperServiceImpl.setConfigurationService((ConfigurationService)SpringContext.getBean(ConfigurationService.class));
        this.ticklersReportLookupForm = new TicklersReportLookupForm();
        this.fieldValues = new LinkedHashMap();
        HashMap<String, String> qualification = new HashMap<String, String>(3);
        qualification.put("billingChartOfAccountsCode", CHART_OF_ACCOUNTS_CODE);
        qualification.put("billingOrganizationCode", ORGANIZATION_CODE);
        this.roleService = KimApiServiceLocator.getRoleService();
        this.user = GlobalVariables.getUserSession().getPerson();
        this.roleService.assignPrincipalToRole(this.user.getPrincipalId(), "KFS-AR", "CGB Collector", qualification);
    }

    protected void tearDown() throws Exception {
        this.ticklersReportLookupableHelperServiceImpl = null;
        this.ticklersReportLookupForm = null;
        this.fieldValues = null;
        HashMap<String, String> qualification = new HashMap<String, String>(3);
        qualification.put("billingChartOfAccountsCode", CHART_OF_ACCOUNTS_CODE);
        qualification.put("billingOrganizationCode", ORGANIZATION_CODE);
        Person user = GlobalVariables.getUserSession().getPerson();
        this.roleService.removePrincipalFromRole(user.getPrincipalId(), "KFS-AR", "CGB Collector", qualification);
        this.roleService = null;
        user = null;
    }

    public void testPerformLookup() throws WorkflowException {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ArrayList resultTable = new ArrayList();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAward();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_1.createAwardAccount();
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        award.getActiveAwardAccounts().clear();
        award.getActiveAwardAccounts().add(awardAccount_1);
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.setAgencyFromFixture((Award)award);
        OrganizationOptions organizationOptions = new OrganizationOptions();
        organizationOptions.setChartOfAccountsCode(CHART_OF_ACCOUNTS_CODE);
        organizationOptions.setOrganizationCode(ORGANIZATION_CODE);
        organizationOptions.setProcessingChartOfAccountCode(CHART_OF_ACCOUNTS_CODE);
        organizationOptions.setProcessingOrganizationCode(ORGANIZATION_CODE);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)organizationOptions);
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = ((ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class)).createCGInvoiceDocumentByAwardInfo(award, awardAccounts, CHART_OF_ACCOUNTS_CODE, ORGANIZATION_CODE, errorMessages, null, null);
        cgInvoice.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("A");
        for (InvoiceAddressDetail invoiceAddressDetail : cgInvoice.getInvoiceAddressDetails()) {
            invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
            invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        }
        documentService.saveDocument((Document)cgInvoice);
        CollectionEvent event = new CollectionEvent();
        event.setInvoiceNumber(cgInvoice.getDocumentNumber());
        event.setActivityCode("TEST");
        event.setUser(this.user);
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        Date today = new Date(ts.getTime());
        event.setFollowupDate(today);
        event.setInvoiceDocument(cgInvoice);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)event);
        cgInvoice.getCollectionEvents().add(event);
        documentService.saveDocument((Document)cgInvoice);
        this.ticklersReportLookupForm.setFieldsForLookup(this.fieldValues);
        TicklersReportLookupableHelperServiceImplTest.assertTrue((this.ticklersReportLookupableHelperServiceImpl.performLookup((LookupForm)this.ticklersReportLookupForm, resultTable, true).size() > 0 ? 1 : 0) != 0);
    }
}

