/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.UniversityDateService;

public class CustomerInvoiceWriteoffFinancialObjectCodeValidation
extends GenericValidation {
    private CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument;
    private BusinessObjectService businessObjectService;

    public boolean validate(AttributedDocumentEvent event) {
        Integer currentFiscalYear = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
        String billByChartOfAccountCode = this.customerInvoiceWriteoffDocument.getCustomerInvoiceDocument().getBillByChartOfAccountCode();
        String billedByOrganizationCode = this.customerInvoiceWriteoffDocument.getCustomerInvoiceDocument().getBilledByOrganizationCode();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", currentFiscalYear);
        criteria.put("chartOfAccountsCode", billByChartOfAccountCode);
        criteria.put("organizationCode", billedByOrganizationCode);
        OrganizationAccountingDefault organizationAccountingDefault = (OrganizationAccountingDefault)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(OrganizationAccountingDefault.class, criteria);
        if (ObjectUtils.isNull((Object)((Object)organizationAccountingDefault))) {
            GlobalVariables.getMessageMap().putError("document.customerInvoiceDetailsForWriteoff", "error.document.customerInvoiceWriteoff.writeoffFAUMustExist", new String[]{currentFiscalYear.toString(), billByChartOfAccountCode, billedByOrganizationCode});
            return false;
        }
        if (StringUtils.isEmpty((String)organizationAccountingDefault.getWriteoffFinancialObjectCode())) {
            GlobalVariables.getMessageMap().putError("document.customerInvoiceDetailsForWriteoff", "error.document.customerInvoiceWriteoff.chartWriteoffFAUObjectMustExist", new String[]{organizationAccountingDefault.getUniversityFiscalYear().toString(), organizationAccountingDefault.getChartOfAccountsCode(), organizationAccountingDefault.getOrganizationCode()});
            return false;
        }
        return true;
    }

    public CustomerInvoiceWriteoffDocument getCustomerInvoiceWriteoffDocument() {
        return this.customerInvoiceWriteoffDocument;
    }

    public void setCustomerInvoiceWriteoffDocument(CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument) {
        this.customerInvoiceWriteoffDocument = customerInvoiceWriteoffDocument;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

