/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coa.service.impl.MockAccountingPeriodService;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;

public class BillingPeriodTest {
    protected void verifyBillingPeriodPriorTo(String awardStartDate, String currentDate, String lastBilledDate, String expectedBillingPeriodStart, String expectedBillingPeriodEnd, boolean expectedBillable, String billingFrequencyCode) {
        Date lastBilledDateAsDate = this.nullSafeDateFromString(lastBilledDate);
        AccountingPeriodService accountingPeriodService = this.getMockAccountingPeriodService();
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)Date.valueOf(awardStartDate), (Date)Date.valueOf(currentDate), (Date)lastBilledDateAsDate, (String)billingFrequencyCode, (AccountingPeriodService)accountingPeriodService);
        Date expectedStartDate = this.nullSafeDateFromString(expectedBillingPeriodStart);
        Assert.assertEquals((String)"Billing period start wasn't what we thought it was going to be", (Object)expectedStartDate, (Object)priorBillingPeriod.getStartDate());
        Date expectedEndDate = this.nullSafeDateFromString(expectedBillingPeriodEnd);
        Assert.assertEquals((String)"Billing period end wasn't what we thought it was going to be", (Object)expectedEndDate, (Object)priorBillingPeriod.getEndDate());
        Assert.assertEquals((String)"Billing period billable wasn't what we thought it was going to be", (Object)expectedBillable, (Object)priorBillingPeriod.isBillable());
    }

    protected AccountingPeriodService getMockAccountingPeriodService() {
        return new MockAccountingPeriodService();
    }

    protected Date nullSafeDateFromString(String date) {
        return StringUtils.isBlank((String)date) ? null : Date.valueOf(date);
    }
}

