/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.CustomerFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.DocumentSystemSaveEvent;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class CustomerInvoiceDocumentTestUtil {
    public static final String CUSTOMER_MAINT_DOC_NAME = "CUS";
    public static Logger LOG = Logger.getLogger(CustomerInvoiceDocumentTestUtil.class);

    public static void saveNewCustomer(CustomerFixture customerFixture) throws Exception {
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)customerFixture.createCustomer());
    }

    public static String saveNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture customerInvoiceDocumentFixture, CustomerInvoiceDetailFixture[] customerInvoiceDocumentFixtures, CustomerFixture customerFixture) throws WorkflowException {
        CustomerInvoiceDocument document = null;
        document = ObjectUtils.isNotNull((Object)((Object)customerFixture)) ? customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerFixture, customerInvoiceDocumentFixtures) : customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerInvoiceDocumentFixtures);
        Document savedDocument = null;
        try {
            ((DocumentService)SpringContext.getBean(DocumentService.class)).saveDocument((Document)document, DocumentSystemSaveEvent.class);
        }
        catch (Exception e) {
            LOG.fatal((Object)"The Customer Invoice Document was not routed, and is not available for testing.", (Throwable)e);
            Assert.fail((String)("The Customer Invoice Document was not routed, and is not available for testing." + e.getClass().getName() + " : " + e.getMessage()));
        }
        savedDocument = ((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(document.getDocumentNumber());
        return ObjectUtils.isNotNull((Object)savedDocument) ? savedDocument.getDocumentNumber() : null;
    }

    public static String submitNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture customerInvoiceDocumentFixture, CustomerInvoiceDetailFixture[] customerInvoiceDetailFixtures, CustomerFixture customerFixture) throws WorkflowException {
        CustomerInvoiceDocument document = null;
        document = ObjectUtils.isNotNull((Object)((Object)customerFixture)) ? customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerFixture, customerInvoiceDetailFixtures) : customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerInvoiceDetailFixtures);
        document.getDocumentHeader().setDocumentDescription("CREATING TEST CUSTOMER INVOICE DOCUMENT");
        Document routedDocument = null;
        try {
            ((DocumentService)SpringContext.getBean(DocumentService.class)).routeDocument((Document)document, "TESTING", new ArrayList());
        }
        catch (Exception e) {
            LOG.fatal((Object)"The Customer Invoice Document was not routed, and is not available for testing.", (Throwable)e);
            Assert.fail((String)("The Customer Invoice Document was not routed, and is not available for testing." + e.getClass().getName() + " : " + e.getMessage()));
        }
        routedDocument = ((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(document.getDocumentNumber());
        return ObjectUtils.isNotNull((Object)routedDocument) ? routedDocument.getDocumentNumber() : null;
    }

    public static CustomerInvoiceDocument submitNewCustomerInvoiceDocumentAndReturnIt(CustomerInvoiceDocumentFixture customerInvoiceDocumentFixture, CustomerInvoiceDetailFixture[] customerInvoiceDetailFixtures, CustomerFixture customerFixture) throws WorkflowException {
        CustomerInvoiceDocument document = null;
        document = ObjectUtils.isNotNull((Object)((Object)customerFixture)) ? customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerFixture, customerInvoiceDetailFixtures) : customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerInvoiceDetailFixtures);
        document.getDocumentHeader().setDocumentDescription("CREATING TEST CUSTOMER INVOICE DOCUMENT");
        Document routedDocument = null;
        try {
            ((DocumentService)SpringContext.getBean(DocumentService.class)).routeDocument((Document)document, "TESTING", new ArrayList());
        }
        catch (Exception e) {
            LOG.fatal((Object)"The Customer Invoice Document was not routed, and is not available for testing.", (Throwable)e);
            Assert.fail((String)("The Customer Invoice Document was not routed, and is not available for testing." + e.getClass().getName() + " : " + e.getMessage() + "\n" + CustomerInvoiceDocumentTestUtil.dumpMessageMapErrors() + "\n" + document));
        }
        routedDocument = ((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(document.getDocumentNumber());
        return (CustomerInvoiceDocument)routedDocument;
    }

    protected static String dumpMessageMapErrors() {
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            return "";
        }
        StringBuilder message = new StringBuilder();
        for (String key : GlobalVariables.getMessageMap().getErrorMessages().keySet()) {
            List errorList = (List)GlobalVariables.getMessageMap().getErrorMessages().get(key);
            for (ErrorMessage em : errorList) {
                message.append(key).append(" = ").append(em.getErrorKey());
                if (em.getMessageParameters() == null) continue;
                message.append(" : ");
                String delim = "";
                for (String parm : em.getMessageParameters()) {
                    message.append(delim).append("'").append(parm).append("'");
                    if (!"".equals(delim)) continue;
                    delim = ", ";
                }
            }
            message.append('\n');
        }
        return message.toString();
    }
}

