/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coa.service.impl.AccountingPeriodServiceImpl;
import org.kuali.kfs.coa.service.impl.MockAccountingPeriodService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.module.ar.batch.service.impl.VerifyBillingFrequencyServiceImpl;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.sys.service.impl.ConfigurableDateTimeServiceImpl;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class VerifyBillingFrequencyServiceTest {
    private VerifyBillingFrequencyServiceImpl verifyBillingFrequencyService;

    @Before
    public void setUp() throws Exception {
        this.verifyBillingFrequencyService = new VerifyBillingFrequencyServiceImpl();
        this.verifyBillingFrequencyService.setAccountingPeriodService((AccountingPeriodService)this.getMockAccountingPeriodService());
    }

    @Test
    public void testMonthlyNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-09-30", ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL, true);
    }

    @Test
    public void testMilestoneNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-09-30", ARAwardFixture.CG_AWARD_MILESTONE_BILLED_DATE_NULL, true);
    }

    @Test
    public void testPredeterminedBillingNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-09-30", ARAwardFixture.CG_AWARD_PREDETERMINED_BILLED_DATE_NULL, true);
    }

    @Test
    public void testQuarterlyNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-09-30", ARAwardFixture.CG_AWARD_QUAR_BILLED_DATE_NULL, true);
    }

    @Test
    public void testSemiAnnualNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-06-30", ARAwardFixture.CG_AWARD_SEMI_ANN_BILLED_DATE_NULL, true);
    }

    @Test
    public void testAnnualNullLastBilledDate() {
        this.runBillingTest("2011-10-31", "2011-01-01", "2011-06-30", ARAwardFixture.CG_AWARD_ANNUAL_BILLED_DATE_NULL, true);
    }

    @Test
    public void testMonthValidLastBilledDate() {
        this.runBillingTest("2011-11-01", "2011-09-01", "2011-10-31", ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID, true);
    }

    @Test
    public void testMilestoneValidLastBilledDate() {
        this.runBillingTest("2011-11-01", "2011-09-01", "2011-10-31", ARAwardFixture.CG_AWARD_MILESTONE_BILLED_DATE_VALID, true);
    }

    @Test
    public void testPredeterminedValidLastBilledDate() {
        this.runBillingTest("2011-11-01", "2011-09-01", "2011-10-31", ARAwardFixture.CG_AWARD_PREDETERMINED_BILLED_DATE_VALID, true);
    }

    @Test
    public void testQuarterlyValidLastBilledDate() {
        this.runBillingTest("2011-11-01", "2011-04-01", "2011-09-30", ARAwardFixture.CG_AWARD_QUAR_BILLED_DATE_VALID, true);
    }

    @Test
    public void testSemiAnnualBillingValidLastBilledDate() {
        this.runBillingTest("2012-01-01", "2011-01-01", "2011-12-31", ARAwardFixture.CG_AWARD_SEMI_ANN_BILLED_DATE_VALID, true);
    }

    @Test
    public void testAnnualBillingValidLastBilledDate() {
        this.runBillingTest("2011-07-01", "2009-07-01", "2011-06-30", ARAwardFixture.CG_AWARD_ANNUAL_BILLED_DATE_VALID, true);
    }

    @Test
    public void testLOCBillingNullLastBilledDate() {
        this.runLOCBillingTest("2011-10-31", "2011-01-01", ARAwardFixture.CG_AWARD_LOCB_BILLED_DATE_NULL);
    }

    @Test
    public void testLOCBillingValidLastBilledDate() {
        this.runLOCBillingTest("2011-12-15", "2010-12-13", ARAwardFixture.CG_AWARD_LOCB_BILLED_DATE_VALID);
    }

    protected void runLOCBillingTest(String currentDate, String startDate, ARAwardFixture awardFixture) {
        AccountingPeriod currPeriod = this.getMockAccountingPeriodService().getByDate(java.sql.Date.valueOf(currentDate));
        ContractsAndGrantsBillingAward award = awardFixture.createAwardWithLastBillingDate();
        ConfigurableDateTimeServiceImpl dateTimeService = new ConfigurableDateTimeServiceImpl();
        dateTimeService.setCurrentDate((Date)java.sql.Date.valueOf(currentDate));
        this.verifyBillingFrequencyService.setDateTimeService((DateTimeService)dateTimeService);
        BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(award, currPeriod);
        Assert.assertEquals((Object)java.sql.Date.valueOf(startDate), (Object)billingPeriod.getStartDate());
    }

    protected void runBillingTest(String currentDate, String beginningDate, String endDate, ARAwardFixture awardFixture, boolean expectedWithinGracePeriod) {
        java.sql.Date date = java.sql.Date.valueOf(currentDate);
        AccountingPeriod currPeriod = this.getMockAccountingPeriodService().getByDate(date);
        ContractsAndGrantsBillingAward award = awardFixture.createAwardWithLastBillingDate();
        ConfigurableDateTimeServiceImpl dateTimeService = new ConfigurableDateTimeServiceImpl();
        dateTimeService.setCurrentDate((Date)java.sql.Date.valueOf(currentDate));
        this.verifyBillingFrequencyService.setDateTimeService((DateTimeService)dateTimeService);
        BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(award, currPeriod);
        Assert.assertEquals((Object)java.sql.Date.valueOf(beginningDate), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)java.sql.Date.valueOf(endDate), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.verifyBillingFrequencyService.calculateIfWithinGracePeriod(date, billingPeriod, award.getLastBilledDate(), award.getBillingFrequency());
        Assert.assertEquals((Object)expectedWithinGracePeriod, (Object)withinGracePeriod);
    }

    protected AccountingPeriodServiceImpl getMockAccountingPeriodService() {
        return new MockAccountingPeriodService();
    }
}

