/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.lookup.LookupUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.lookup.AccountsReceivableLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;

public class ContractsGrantsInvoiceDocumentErrorLogLookupableHelperServiceImpl
extends AccountsReceivableLookupableHelperServiceImplBase {
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    protected DateTimeService dateTimeService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        return this.getSearchResultsHelper(LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), this.updateFieldValuesForSearchCriteria(fieldValues)), false);
    }

    public List<? extends BusinessObject> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        return this.getSearchResultsHelper(LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), this.updateFieldValuesForSearchCriteria(fieldValues)), true);
    }

    protected Map<String, String> updateFieldValuesForSearchCriteria(Map<String, String> fieldValues) {
        HashMap<String, String> newFieldValues = new HashMap<String, String>();
        newFieldValues.putAll(fieldValues);
        String accounts = (String)newFieldValues.get("accounts");
        if (StringUtils.isNotBlank((String)accounts)) {
            if (!StringUtils.startsWith((String)accounts, (String)"*")) {
                accounts = "*" + accounts;
            }
            if (!StringUtils.endsWith((String)accounts, (String)"*")) {
                accounts = accounts + "*";
            }
        }
        newFieldValues.put("accounts", accounts);
        String errorDate = (String)newFieldValues.get("errorDate");
        int index = StringUtils.indexOf((String)errorDate, (String)SearchOperator.LESS_THAN_EQUAL.toString());
        if (index == -1) {
            index = StringUtils.indexOf((String)errorDate, (String)SearchOperator.BETWEEN.toString());
            if (index != -1) {
                this.incrementErrorDate(newFieldValues, errorDate, index);
            }
        } else {
            this.incrementErrorDate(newFieldValues, errorDate, index);
        }
        return newFieldValues;
    }

    protected void incrementErrorDate(Map<String, String> newFieldValues, String errorDate, int index) {
        String errorDatePrefix = errorDate.substring(0, index + 2);
        String newDateString = this.contractsGrantsReportHelperService.correctEndDateForTime(errorDate.substring(index + 2));
        if (StringUtils.isNotBlank((String)errorDate.substring(index + 2))) {
            newFieldValues.put("errorDate", errorDatePrefix + newDateString);
        }
    }

    public void validateSearchParameters(Map<String, String> fieldValues) {
        Person person;
        super.validateSearchParameters(fieldValues);
        String proposalNumber = fieldValues.get("proposalNumber");
        String awardBeginningDateFromString = fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate");
        String awardBeginningDateToString = fieldValues.get("awardBeginningDate");
        String awardEndingpDateFromString = fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate");
        String awardEndingDateToString = fieldValues.get("awardEndingDate");
        String awardTotalAmount = fieldValues.get("awardTotalAmount");
        String cumulativeExpensesAmount = fieldValues.get("cumulativeExpensesAmount");
        String errorDateFromString = fieldValues.get("rangeLowerBoundKeyPrefix_errorDate");
        String errorDateToString = fieldValues.get("errorDate");
        String primaryFundManagerPrincipalId = fieldValues.get("primaryFundManagerPrincipalName");
        String awardBeginningDateLabel = this.lookupPropertyLabel("awardBeginningDate");
        this.validateDate(awardBeginningDateFromString, "rangeLowerBoundKeyPrefix_awardBeginningDate", awardBeginningDateLabel + " From");
        this.validateDate(awardBeginningDateToString, "awardBeginningDate", awardBeginningDateLabel + " To");
        String awardEndingDateLabel = this.lookupPropertyLabel("awardEndingDate");
        this.validateDate(awardEndingpDateFromString, "rangeLowerBoundKeyPrefix_awardEndingDate", awardEndingDateLabel + " From");
        this.validateDate(awardEndingDateToString, "awardEndingDate", awardEndingDateLabel + " To");
        if (StringUtils.isNotBlank((String)awardTotalAmount) && !KualiDecimal.isNumeric((String)awardTotalAmount)) {
            GlobalVariables.getMessageMap().putError("awardTotalAmount", "error.numeric", new String[]{this.lookupPropertyLabel("awardTotalAmount")});
        }
        if (StringUtils.isNotBlank((String)cumulativeExpensesAmount) && !KualiDecimal.isNumeric((String)cumulativeExpensesAmount)) {
            GlobalVariables.getMessageMap().putError("cumulativeExpensesAmount", "error.numeric", new String[]{this.lookupPropertyLabel("cumulativeExpensesAmount")});
        }
        String errorDateLabel = this.lookupPropertyLabel("errorDate");
        this.validateDate(errorDateFromString, "rangeLowerBoundKeyPrefix_errorDate", errorDateLabel + " From");
        this.validateDate(errorDateToString, "errorDate", errorDateLabel + " To");
        if (StringUtils.isNotEmpty((String)primaryFundManagerPrincipalId) && ObjectUtils.isNull((Object)(person = ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByPrincipalName(primaryFundManagerPrincipalId)))) {
            GlobalVariables.getMessageMap().putError("primaryFundManagerPrincipalName", "error.no.principal.name.found", new String[]{this.lookupPropertyLabel("primaryFundManagerPrincipalName")});
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            throw new ValidationException("Error(s) in search criteria");
        }
    }

    protected String lookupPropertyLabel(String propertyName) {
        String attributeLabel = this.getDataDictionaryService().getAttributeLabel(ContractsGrantsInvoiceDocumentErrorLog.class, propertyName);
        return attributeLabel;
    }

    protected void validateDate(String dateString, String fieldName, String fieldLabel) {
        if (StringUtils.isNotBlank((String)dateString)) {
            try {
                this.dateTimeService.convertToDate(dateString);
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError(fieldName, "error.invalidDateTime", new String[]{fieldLabel});
            }
        }
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

