/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.CustomerAgingReportDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerOpenItemReportDetail;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.CustomerAgingReportService;
import org.kuali.kfs.module.ar.web.struts.CustomerAgingReportForm;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.beans.factory.InitializingBean;

public class CustomerAgingReportLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl
implements InitializingBean {
    private Logger LOG = Logger.getLogger(CustomerAgingReportLookupableHelperServiceImpl.class);
    protected DateTimeService dateTimeService;
    protected CustomerAgingReportService customerAgingReportService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    private String customerNameLabel;
    private String customerNumberLabel;
    private String cutoffdate30Label;
    private String cutoffdate60Label;
    private String cutoffdate90Label;
    private KualiDecimal total0to30 = KualiDecimal.ZERO;
    private KualiDecimal total31to60 = KualiDecimal.ZERO;
    private KualiDecimal total61to90 = KualiDecimal.ZERO;
    private KualiDecimal total91toSYSPR = KualiDecimal.ZERO;
    private KualiDecimal totalSYSPRplus1orMore = KualiDecimal.ZERO;
    private KualiDecimal totalOpenInvoices = KualiDecimal.ZERO;
    private KualiDecimal totalCredits = KualiDecimal.ZERO;
    private KualiDecimal totalWriteOffs = KualiDecimal.ZERO;
    private java.util.Date reportRunDate;
    private String reportOption;
    private String accountNumber;
    private String processingOrBillingChartCode;
    private String accountChartCode;
    private String orgCode;
    private String nbrDaysForLastBucket;
    private String cutoffdate91toSYSPRlabel;
    private String cutoffdateSYSPRplus1orMorelabel;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.reportOption = fieldValues.get("reportOption");
        this.accountNumber = fieldValues.get("accountNumber");
        this.processingOrBillingChartCode = fieldValues.get("processingOrBillingChartOfAccountsCode");
        this.accountChartCode = fieldValues.get("accountChartOfAccountsCode");
        this.orgCode = fieldValues.get("organizationCode");
        this.total0to30 = KualiDecimal.ZERO;
        this.total31to60 = KualiDecimal.ZERO;
        this.total61to90 = KualiDecimal.ZERO;
        this.total91toSYSPR = KualiDecimal.ZERO;
        this.totalSYSPRplus1orMore = KualiDecimal.ZERO;
        this.totalOpenInvoices = KualiDecimal.ZERO;
        this.totalWriteOffs = KualiDecimal.ZERO;
        this.totalCredits = KualiDecimal.ZERO;
        java.util.Date today = this.getDateTimeService().getCurrentDate();
        try {
            this.reportRunDate = this.getDateTimeService().convertToDate(fieldValues.get("reportRunDate"));
        }
        catch (ParseException e) {
            this.reportRunDate = today;
            this.LOG.error((Object)"problem during CustomerAgingReportLookupableHelperServiceImpl.getSearchResults()", (Throwable)e);
        }
        java.util.Date cutoffdate30 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-30);
        java.util.Date cutoffdate31 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-31);
        java.util.Date cutoffdate60 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-60);
        java.util.Date cutoffdate61 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-61);
        java.util.Date cutoffdate90 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-90);
        java.util.Date cutoffdate91 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-91);
        java.util.Date cutoffdate120 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)(-1 * Integer.parseInt(this.nbrDaysForLastBucket)));
        java.util.Date cutoffdate121 = DateUtils.addDays((java.util.Date)cutoffdate120, (int)-1);
        ArrayList invoices = new ArrayList();
        HashMap<String, CustomerAgingReportDetail> knownCustomers = new HashMap<String, CustomerAgingReportDetail>();
        if (this.reportOption.equalsIgnoreCase("Processing Organization") && StringUtils.isNotBlank((String)this.processingOrBillingChartCode) && StringUtils.isNotBlank((String)this.orgCode)) {
            this.computeFor0To30DaysByProcessingChartAndOrg(new Date(cutoffdate30.getTime()), new Date(this.reportRunDate.getTime()), knownCustomers);
            this.computeFor31To60DaysByProcessingChartAndOrg(new Date(cutoffdate60.getTime()), new Date(cutoffdate31.getTime()), knownCustomers);
            this.computeFor61To90DaysByProcessingChartAndOrg(new Date(cutoffdate90.getTime()), new Date(cutoffdate61.getTime()), knownCustomers);
            this.computeFor91ToSYSPRDaysByProcessingChartAndOrg(new Date(cutoffdate120.getTime()), new Date(cutoffdate91.getTime()), knownCustomers);
            this.computeForSYSPRplus1orMoreDaysByProcessingChartAndOrg(null, new Date(cutoffdate121.getTime()), knownCustomers);
        }
        if (this.reportOption.equalsIgnoreCase("Billing Organization") && StringUtils.isNotBlank((String)this.processingOrBillingChartCode) && StringUtils.isNotBlank((String)this.orgCode)) {
            this.computeFor0To30DaysByBillingChartAndOrg(new Date(cutoffdate30.getTime()), new Date(this.reportRunDate.getTime()), knownCustomers);
            this.computeFor31To60DaysByBillingChartAndOrg(new Date(cutoffdate60.getTime()), new Date(cutoffdate31.getTime()), knownCustomers);
            this.computeFor61To90DaysByBillingChartAndOrg(new Date(cutoffdate90.getTime()), new Date(cutoffdate61.getTime()), knownCustomers);
            this.computeFor91ToSYSPRDaysByBillingChartAndOrg(new Date(cutoffdate120.getTime()), new Date(cutoffdate91.getTime()), knownCustomers);
            this.computeForSYSPRplus1orMoreDaysByBillingChartAndOrg(null, new Date(cutoffdate121.getTime()), knownCustomers);
        }
        if (this.reportOption.equalsIgnoreCase("Account") && StringUtils.isNotBlank((String)this.accountChartCode) && StringUtils.isNotBlank((String)this.accountNumber)) {
            this.computeFor0To30DaysByAccount(new Date(cutoffdate30.getTime()), new Date(this.reportRunDate.getTime()), knownCustomers);
            this.computeFor31To60DaysByAccount(new Date(cutoffdate60.getTime()), new Date(cutoffdate31.getTime()), knownCustomers);
            this.computeFor61To90DaysByAccount(new Date(cutoffdate90.getTime()), new Date(cutoffdate61.getTime()), knownCustomers);
            this.computeFor91ToSYSPRDaysByAccount(new Date(cutoffdate120.getTime()), new Date(cutoffdate91.getTime()), knownCustomers);
            this.computeForSYSPRplus1orMoreDaysByAccount(null, new Date(cutoffdate121.getTime()), knownCustomers);
        }
        ArrayList<CustomerAgingReportDetail> results = new ArrayList<CustomerAgingReportDetail>();
        for (CustomerAgingReportDetail detail : knownCustomers.values()) {
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)((KualiDecimal)detail.getUnpaidBalance0to30().add((AbstractKualiDecimal)detail.getUnpaidBalance31to60())).add((AbstractKualiDecimal)detail.getUnpaidBalance61to90())).add(detail.getUnpaidBalance91toSYSPR().add((AbstractKualiDecimal)detail.getUnpaidBalanceSYSPRplus1orMore()));
            detail.setTotalOpenInvoices(amount);
            this.totalOpenInvoices = (KualiDecimal)this.totalOpenInvoices.add((AbstractKualiDecimal)amount);
            KualiDecimal writeOffAmt = this.getCustomerAgingReportService().findWriteOffAmountByCustomerNumber(detail.getCustomerNumber());
            if (ObjectUtils.isNotNull((Object)writeOffAmt)) {
                this.totalWriteOffs = (KualiDecimal)this.totalWriteOffs.add((AbstractKualiDecimal)writeOffAmt);
            } else {
                writeOffAmt = KualiDecimal.ZERO;
            }
            detail.setTotalWriteOff(writeOffAmt);
            results.add(detail);
        }
        return new CollectionIncomplete(results, Long.valueOf(results.size()));
    }

    public List getReturnKeys() {
        return new ArrayList(this.fieldConversions.keySet());
    }

    protected Properties getParameters(BusinessObject bo, Map fieldConversions, String lookupImpl, List pkNames) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "refresh");
        parameters.put("docFormKey", this.getDocFormKey());
        parameters.put("refreshCaller", lookupImpl);
        if (this.getReferencesToRefresh() != null) {
            parameters.put("referencesToRefresh", this.getReferencesToRefresh());
        }
        for (Object o : this.getReturnKeys()) {
            String fieldNm = (String)o;
            Object fieldVal = ObjectUtils.getPropertyValue((Object)bo, (String)fieldNm);
            if (fieldVal == null) {
                fieldVal = "";
            }
            if (fieldConversions.containsKey(fieldNm)) {
                fieldNm = (String)fieldConversions.get(fieldNm);
            }
            if (fieldVal instanceof java.util.Date) {
                DateFormatter dateFormatter = new DateFormatter();
                fieldVal = dateFormatter.format(fieldVal);
            }
            parameters.put(fieldNm, fieldVal.toString());
        }
        return parameters;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        List<? extends BusinessObject> displayList = this.getSearchResults(lookupForm.getFieldsForLookup());
        HashMap<String, Class> propertyTypes = new HashMap<String, Class>();
        boolean hasReturnableRow = false;
        Person user = GlobalVariables.getUserSession().getPerson();
        for (Object e : displayList) {
            BusinessObject element = (BusinessObject)e;
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            if (ObjectUtils.isNotNull((Object)this.getColumns())) {
                List columns = this.getColumns();
                this.populateCutoffdateLabels();
                for (Object column : columns) {
                    Column col = (Column)column;
                    Formatter formatter = col.getFormatter();
                    String propValue = "";
                    Object prop = ObjectUtils.getPropertyValue((Object)element, (String)col.getPropertyName());
                    Class propClass = (Class)propertyTypes.get(col.getPropertyName());
                    if (propClass == null && (propClass = ObjectUtils.getPropertyType((Object)element, (String)col.getPropertyName(), (PersistenceStructureService)this.getPersistenceStructureService())) != null) {
                        propertyTypes.put(col.getPropertyName(), propClass);
                    }
                    if (prop != null) {
                        propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
                    }
                    col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                    col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                    propValue = super.maskValueIfNecessary(element.getClass(), col.getPropertyName(), propValue, businessObjectRestrictions);
                    col.setPropertyValue(propValue);
                    if (StringUtils.equals((String)"unpaidBalance91toSYSPR", (String)col.getPropertyName())) {
                        col.setColumnTitle(this.cutoffdate91toSYSPRlabel);
                    }
                    if (StringUtils.equals((String)"unpaidBalanceSYSPRplus1orMore", (String)col.getPropertyName())) {
                        col.setColumnTitle(this.cutoffdateSYSPRplus1orMorelabel);
                    }
                    if (!StringUtils.isNotBlank((String)propValue)) continue;
                    if (StringUtils.equals((String)this.customerNameLabel, (String)col.getColumnTitle())) {
                        col.setPropertyURL("");
                        continue;
                    }
                    col.setPropertyURL(this.getCustomerOpenItemReportUrl(element, col.getColumnTitle()));
                }
                ResultRow row = new ResultRow(columns, "", "");
                if (element instanceof PersistableBusinessObject) {
                    row.setObjectId(((PersistableBusinessObject)element).getObjectId());
                }
                boolean isRowReturnable = this.isResultReturnable(element);
                row.setRowReturnable(isRowReturnable);
                if (isRowReturnable) {
                    hasReturnableRow = true;
                }
                resultTable.add(row);
            }
            lookupForm.setHasReturnableRow(hasReturnableRow);
        }
        if (displayList.size() != 0) {
            ((CustomerAgingReportForm)lookupForm).setTotal0to30(this.total0to30.toString());
            ((CustomerAgingReportForm)lookupForm).setTotal31to60(this.total31to60.toString());
            ((CustomerAgingReportForm)lookupForm).setTotal61to90(this.total61to90.toString());
            ((CustomerAgingReportForm)lookupForm).setTotal91toSYSPR(this.total91toSYSPR.toString());
            ((CustomerAgingReportForm)lookupForm).setTotalSYSPRplus1orMore(this.totalSYSPRplus1orMore.toString());
            ((CustomerAgingReportForm)lookupForm).setTotalOpenInvoices(this.totalOpenInvoices.toString());
            ((CustomerAgingReportForm)lookupForm).setTotalWriteOffs(this.totalWriteOffs.toString());
        }
        return displayList;
    }

    protected void populateCutoffdateLabels() {
        this.customerNameLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(CustomerAgingReportDetail.class.getName()).getAttributeDefinition("customerName").getLabel();
        this.customerNumberLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(CustomerAgingReportDetail.class.getName()).getAttributeDefinition("customerNumber").getLabel();
        this.cutoffdate30Label = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(CustomerAgingReportDetail.class.getName()).getAttributeDefinition("unpaidBalance0to30").getLabel();
        this.cutoffdate60Label = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(CustomerAgingReportDetail.class.getName()).getAttributeDefinition("unpaidBalance31to60").getLabel();
        this.cutoffdate90Label = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(CustomerAgingReportDetail.class.getName()).getAttributeDefinition("unpaidBalance61to90").getLabel();
    }

    protected String getCustomerOpenItemReportUrl(BusinessObject bo, String columnTitle) {
        CustomerAgingReportDetail detail = (CustomerAgingReportDetail)bo;
        Properties parameters = new Properties();
        parameters.put("businessObjectClassName", CustomerOpenItemReportDetail.class.getName());
        parameters.put("returnLocation", "");
        parameters.put("lookupableImplServiceName", "arCustomerOpenItemReportLookupable");
        parameters.put("methodToCall", "search");
        parameters.put("reportName", "Customer Open Item Report");
        parameters.put("docFormKey", "88888888");
        parameters.put("customerNumber", detail.getCustomerNumber());
        parameters.put("customerName", detail.getCustomerName());
        parameters.put("reportOption", this.reportOption);
        if (this.reportOption.equals("Account")) {
            parameters.put("accountChartCode", this.accountChartCode);
            parameters.put("accountNumber", this.accountNumber);
        } else {
            parameters.put("processingOrBillingChartCode", this.processingOrBillingChartCode);
            parameters.put("orgCode", this.orgCode);
        }
        DateFormatter dateFormatter = new DateFormatter();
        parameters.put("reportRunDate", dateFormatter.format((Object)this.reportRunDate).toString());
        if (StringUtils.equals((String)columnTitle, (String)this.customerNumberLabel)) {
            columnTitle = "All days";
        } else {
            String startDate = "";
            String endDate = "";
            if (StringUtils.equals((String)columnTitle, (String)this.cutoffdate30Label)) {
                startDate = dateFormatter.format((Object)DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-30)).toString();
                endDate = dateFormatter.format((Object)this.reportRunDate).toString();
            } else if (StringUtils.equals((String)columnTitle, (String)this.cutoffdate60Label)) {
                startDate = dateFormatter.format((Object)DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-60)).toString();
                endDate = dateFormatter.format((Object)DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-31)).toString();
            } else if (StringUtils.equals((String)columnTitle, (String)this.cutoffdate90Label)) {
                startDate = dateFormatter.format((Object)DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-90)).toString();
                endDate = dateFormatter.format((Object)DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-61)).toString();
            } else if (StringUtils.equals((String)columnTitle, (String)this.cutoffdate91toSYSPRlabel)) {
                startDate = dateFormatter.format((Object)DateUtils.addDays((java.util.Date)this.reportRunDate, (int)(-Integer.parseInt(this.nbrDaysForLastBucket)))).toString();
                endDate = dateFormatter.format((Object)DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-91)).toString();
            } else if (StringUtils.equals((String)columnTitle, (String)this.cutoffdateSYSPRplus1orMorelabel)) {
                endDate = dateFormatter.format((Object)DateUtils.addDays((java.util.Date)this.reportRunDate, (int)(-1 - Integer.parseInt(this.nbrDaysForLastBucket)))).toString();
                columnTitle = Integer.toString(Integer.parseInt(this.nbrDaysForLastBucket) + 1) + " days and older";
            } else {
                endDate = dateFormatter.format((Object)this.reportRunDate).toString();
                columnTitle = "All days";
            }
            parameters.put("startDate", startDate);
            parameters.put("endDate", endDate);
        }
        parameters.put("columnTitle", columnTitle);
        String href = UrlFactory.parameterizeUrl((String)"arCustomerOpenItemReportLookup.do", (Properties)parameters);
        return href;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public KualiDecimal getTotal0to30() {
        return this.total0to30;
    }

    public void setTotal0to30(KualiDecimal total0to30) {
        this.total0to30 = total0to30;
    }

    public KualiDecimal getTotal31to60() {
        return this.total31to60;
    }

    public void setTotal31to60(KualiDecimal total31to60) {
        this.total31to60 = total31to60;
    }

    public KualiDecimal getTotal61to90() {
        return this.total61to90;
    }

    public void setTotal61to90(KualiDecimal total61to90) {
        this.total61to90 = total61to90;
    }

    public KualiDecimal getTotal91toSYSPR() {
        return this.total91toSYSPR;
    }

    public void setTotal91toSYSPR(KualiDecimal total91toSYSPR) {
        this.total91toSYSPR = total91toSYSPR;
    }

    public KualiDecimal getTotalSYSPRplus1orMore() {
        return this.totalSYSPRplus1orMore;
    }

    public void setTotalSYSPRplus1orMore(KualiDecimal totalSYSPRplus1orMore) {
        this.totalSYSPRplus1orMore = totalSYSPRplus1orMore;
    }

    protected void computeFor0To30DaysByProcessingChartAndOrg(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance0to30(amount);
            this.total0to30 = (KualiDecimal)this.total0to30.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor31To60DaysByProcessingChartAndOrg(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance31to60(amount);
            this.total31to60 = (KualiDecimal)this.total31to60.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor61To90DaysByProcessingChartAndOrg(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance61to90(amount);
            this.total61to90 = (KualiDecimal)this.total61to90.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor91ToSYSPRDaysByProcessingChartAndOrg(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance91toSYSPR(amount);
            this.total91toSYSPR = (KualiDecimal)this.total91toSYSPR.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeForSYSPRplus1orMoreDaysByProcessingChartAndOrg(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByProcessingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalanceSYSPRplus1orMore(amount);
            this.totalSYSPRplus1orMore = (KualiDecimal)this.totalSYSPRplus1orMore.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor0To30DaysByBillingChartAndOrg(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance0to30(amount);
            this.total0to30 = (KualiDecimal)this.total0to30.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor31To60DaysByBillingChartAndOrg(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance31to60(amount);
            this.total31to60 = (KualiDecimal)this.total31to60.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor61To90DaysByBillingChartAndOrg(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance61to90(amount);
            this.total61to90 = (KualiDecimal)this.total61to90.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor91ToSYSPRDaysByBillingChartAndOrg(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance91toSYSPR(amount);
            this.total91toSYSPR = (KualiDecimal)this.total91toSYSPR.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeForSYSPRplus1orMoreDaysByBillingChartAndOrg(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByBillingChartAndOrg(this.processingOrBillingChartCode, this.orgCode, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalanceSYSPRplus1orMore(amount);
            this.totalSYSPRplus1orMore = (KualiDecimal)this.totalSYSPRplus1orMore.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor0To30DaysByAccount(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance0to30(amount);
            this.total0to30 = (KualiDecimal)this.total0to30.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor31To60DaysByAccount(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance31to60(amount);
            this.total31to60 = (KualiDecimal)this.total31to60.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor61To90DaysByAccount(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance61to90(amount);
            this.total61to90 = (KualiDecimal)this.total61to90.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor91ToSYSPRDaysByAccount(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalance91toSYSPR(amount);
            this.total91toSYSPR = (KualiDecimal)this.total91toSYSPR.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeForSYSPRplus1orMoreDaysByAccount(Date begin, Date end, Map<String, CustomerAgingReportDetail> knownCustomers) {
        HashMap<String, KualiDecimal> invAmountDays = this.getCustomerAgingReportService().findInvoiceAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        HashMap<String, KualiDecimal> appliedAmountDays = this.getCustomerAgingReportService().findAppliedAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        HashMap<String, KualiDecimal> discountAmountDays = this.getCustomerAgingReportService().findDiscountAmountByAccount(this.accountChartCode, this.accountNumber, begin, end);
        Set<String> customerIds = invAmountDays.keySet();
        for (String customer : customerIds) {
            CustomerAgingReportDetail agingReportDetail = this.pickCustomerAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = (KualiDecimal)((KualiDecimal)this.replaceNull(invAmountDays, customer).subtract((AbstractKualiDecimal)this.replaceNull(discountAmountDays, customer))).subtract((AbstractKualiDecimal)this.replaceNull(appliedAmountDays, customer));
            agingReportDetail.setUnpaidBalanceSYSPRplus1orMore(amount);
            this.totalSYSPRplus1orMore = (KualiDecimal)this.totalSYSPRplus1orMore.add((AbstractKualiDecimal)amount);
        }
    }

    protected CustomerAgingReportDetail pickCustomerAgingReportDetail(Map<String, CustomerAgingReportDetail> knownCustomers, String customer) {
        CustomerAgingReportDetail agingReportDetail = null;
        agingReportDetail = knownCustomers.get(customer);
        if (agingReportDetail == null) {
            agingReportDetail = new CustomerAgingReportDetail();
            agingReportDetail.setCustomerNumber(customer.substring(0, customer.indexOf(45)));
            agingReportDetail.setCustomerName(customer.substring(customer.indexOf(45) + 1));
            knownCustomers.put(customer, agingReportDetail);
        }
        return agingReportDetail;
    }

    protected KualiDecimal replaceNull(HashMap<String, KualiDecimal> amountMap, String customer) {
        return amountMap.get(customer) != null ? amountMap.get(customer) : KualiDecimal.ZERO;
    }

    public void afterPropertiesSet() throws Exception {
        this.nbrDaysForLastBucket = this.getParameterService().getParameterValueAsString(CustomerAgingReportDetail.class, "CUSTOMER_INVOICE_AGE");
        this.cutoffdate91toSYSPRlabel = "91-" + this.nbrDaysForLastBucket + " days";
        this.cutoffdateSYSPRplus1orMorelabel = Integer.toString(Integer.parseInt(this.nbrDaysForLastBucket) + 1) + "+ days";
    }

    public CustomerAgingReportService getCustomerAgingReportService() {
        return this.customerAgingReportService;
    }

    public void setCustomerAgingReportService(CustomerAgingReportService customerAgingReportService) {
        this.customerAgingReportService = customerAgingReportService;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }
}

