/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.businessobject.lookup.TemplateLookupableHelperServiceImplBase;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class InvoiceTemplateLookupableHelperServiceImpl
extends TemplateLookupableHelperServiceImplBase {
    protected FinancialSystemUserService financialSystemUserService;

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        InvoiceTemplate invoiceTemplate = (InvoiceTemplate)businessObject;
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        boolean isValid = false;
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        ChartOrgHolder chartOrg = this.getFinancialSystemUserService().getPrimaryOrganization(currentUser, "KFS-AR");
        if (ObjectUtils.isNotNull((Object)invoiceTemplate.getBillByChartOfAccountCode()) && ObjectUtils.isNotNull((Object)invoiceTemplate.getBilledByOrganizationCode()) && StringUtils.equals((String)invoiceTemplate.getBillByChartOfAccountCode(), (String)chartOrg.getChartOfAccountsCode()) && StringUtils.equals((String)invoiceTemplate.getBilledByOrganizationCode(), (String)chartOrg.getOrganizationCode())) {
            isValid = true;
        }
        if (isValid) {
            if (StringUtils.isNotBlank((String)this.getMaintenanceDocumentTypeName()) && this.allowsMaintenanceEditAction(businessObject)) {
                htmlDataList.add((HtmlData)this.getUrlData(businessObject, "edit", pkNames));
            }
            if (this.allowsMaintenanceNewOrCopyAction()) {
                htmlDataList.add((HtmlData)this.getUrlData(businessObject, "copy", pkNames));
            }
            if (this.isTemplateValidForUser(invoiceTemplate, currentUser)) {
                htmlDataList.add((HtmlData)this.getTemplateUploadUrl("invoiceTemplateCode", invoiceTemplate.getInvoiceTemplateCode()));
            }
            if (StringUtils.isNotBlank((String)invoiceTemplate.getFilename()) && this.templateFileExists(invoiceTemplate.getFilename())) {
                htmlDataList.add((HtmlData)this.getTemplateDownloadUrl(invoiceTemplate.getFilename()));
            }
        }
        return htmlDataList;
    }

    protected boolean isTemplateValidForUser(InvoiceTemplate invoiceTemplate, Person user) {
        ChartOrgHolder userChartOrg = this.getFinancialSystemUserService().getPrimaryOrganization(user, "KFS-AR");
        if (!StringUtils.isBlank((String)invoiceTemplate.getBillByChartOfAccountCode()) && !StringUtils.isBlank((String)invoiceTemplate.getBilledByOrganizationCode())) {
            return StringUtils.equals((String)invoiceTemplate.getBillByChartOfAccountCode(), (String)userChartOrg.getChartOfAccountsCode()) && StringUtils.equals((String)invoiceTemplate.getBilledByOrganizationCode(), (String)userChartOrg.getOrganizationCode());
        }
        return false;
    }

    @Override
    protected String getAction() {
        return "arAccountsReceivableInvoiceTemplateUpload.do";
    }

    public FinancialSystemUserService getFinancialSystemUserService() {
        return this.financialSystemUserService;
    }

    public void setFinancialSystemUserService(FinancialSystemUserService financialSystemUserService) {
        this.financialSystemUserService = financialSystemUserService;
    }
}

