/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.BusinessObject;

public class CustomerRule
extends MaintenanceDocumentRuleBase {
    protected static Logger LOG = Logger.getLogger(CustomerRule.class);
    protected Customer oldCustomer;
    protected Customer newCustomer;
    protected DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);

    protected void initializeAttributes(MaintenanceDocument document) {
        if (this.newCustomer == null) {
            this.newCustomer = (Customer)document.getNewMaintainableObject().getBusinessObject();
        }
        if (this.oldCustomer == null) {
            this.oldCustomer = (Customer)document.getOldMaintainableObject().getBusinessObject();
        }
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean isValid = true;
        isValid &= super.processCustomRouteDocumentBusinessRules(document);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (isValid &= !errorMap.hasErrors()) {
            this.initializeAttributes(document);
            if (isValid &= this.checkCustomerHasAddress(this.newCustomer)) {
                isValid &= this.validateAddresses(this.newCustomer);
            }
            if (isValid) {
                isValid &= this.checkAddresses(this.newCustomer);
            }
            if (isValid) {
                isValid &= this.checkTaxNumber(this.newCustomer);
            }
            if (isValid) {
                isValid &= this.checkNameIsValidLength(this.newCustomer.getCustomerName());
            }
            if (isValid) {
                isValid &= this.checkStopWorkReason();
            }
            if (isValid && document.isNew() && StringUtils.isBlank((String)this.newCustomer.getCustomerNumber())) {
                isValid &= this.setCustomerNumber();
            }
        }
        return isValid;
    }

    protected boolean setCustomerNumber() {
        boolean success = true;
        try {
            String customerNumber = ((CustomerService)SpringContext.getBean(CustomerService.class)).getNextCustomerNumber(this.newCustomer);
            this.newCustomer.setCustomerNumber(customerNumber);
            if (this.oldCustomer != null) {
                this.oldCustomer.setCustomerNumber(customerNumber);
            }
        }
        catch (StringIndexOutOfBoundsException sibe) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.customerName", "error.document.customer.customerNameLessThanThreeCharacters", new String[0]);
            success = false;
        }
        return success;
    }

    public boolean checkCustomerHasAddress(Customer newCustomer) {
        boolean success = true;
        if (newCustomer.getCustomerAddresses().isEmpty()) {
            success = false;
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.customerAddresses", "error.document.customer.addressRequired", new String[0]);
        }
        return success;
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        boolean isValid = true;
        isValid &= super.processCustomAddCollectionLineBusinessRules(document, collectionName, line);
        if (collectionName.equals("customerAddresses")) {
            CustomerAddress customerAddress = (CustomerAddress)line;
            if (isValid) {
                isValid &= this.checkAddressIsValid(customerAddress);
                isValid &= this.validateEndDateForNewAddressLine(customerAddress.getCustomerAddressEndDate());
            }
            if (isValid) {
                Customer customer = (Customer)document.getNewMaintainableObject().getBusinessObject();
                if ("P".equalsIgnoreCase(customerAddress.getCustomerAddressTypeCode())) {
                    for (int i = 0; i < customer.getCustomerAddresses().size(); ++i) {
                        if (!"P".equalsIgnoreCase(customer.getCustomerAddresses().get(i).getCustomerAddressTypeCode())) continue;
                        customer.getCustomerAddresses().get(i).setCustomerAddressTypeCode("A");
                    }
                } else {
                    boolean isActivePrimaryAddress = false;
                    for (int i = 0; i < customer.getCustomerAddresses().size(); ++i) {
                        if (!"P".equalsIgnoreCase(customer.getCustomerAddresses().get(i).getCustomerAddressTypeCode())) continue;
                        java.sql.Date endDate = customer.getCustomerAddresses().get(i).getCustomerAddressEndDate();
                        if (!this.checkEndDateIsValid(endDate, false)) {
                            customer.getCustomerAddresses().get(i).setCustomerAddressTypeCode("A");
                            continue;
                        }
                        isActivePrimaryAddress = true;
                    }
                    if (!isActivePrimaryAddress) {
                        customerAddress.setCustomerAddressTypeCode("P");
                    } else if (StringUtils.isEmpty((String)customerAddress.getCustomerAddressTypeCode())) {
                        customerAddress.setCustomerAddressTypeCode("A");
                    }
                }
            }
        }
        return isValid;
    }

    public boolean checkEndDateIsValid(java.sql.Date endDate, boolean canBeTodaysDateFlag) {
        boolean isValid = true;
        if (ObjectUtils.isNull((Object)endDate)) {
            return isValid;
        }
        Timestamp today = this.dateTimeService.getCurrentTimestamp();
        today.setTime(DateUtils.truncate((Date)today, (int)5).getTime());
        if (canBeTodaysDateFlag) {
            if (endDate.before(today)) {
                isValid = false;
            }
        } else if (!endDate.after(today)) {
            isValid = false;
        }
        return isValid;
    }

    public boolean validateEndDateForNewAddressLine(java.sql.Date endDate) {
        boolean isValid = this.checkEndDateIsValid(endDate, false);
        if (!isValid) {
            String propertyName = "add.customerAddresses.customerAddressEndDate";
            this.putFieldError(propertyName, "error.document.customer.endDateMustBeFutureDate");
        }
        return isValid;
    }

    public boolean validateEndDateForExistingCustomerAddress(java.sql.Date newEndDate, int ind) {
        boolean isValid = this.checkEndDateIsValid(newEndDate, true);
        if (!isValid) {
            java.sql.Date oldEndDate = this.oldCustomer.getCustomerAddresses().get(ind).getCustomerAddressEndDate();
            if (ObjectUtils.isNull((Object)oldEndDate) || ObjectUtils.isNotNull((Object)oldEndDate) && !oldEndDate.toString().equals(newEndDate.toString())) {
                String propertyName = "customerAddresses[" + ind + "]." + "customerAddressEndDate";
                this.putFieldError(propertyName, "error.document.customer.endDateMustBeCurrenOrFutureDate");
            } else {
                isValid = true;
            }
        }
        return isValid;
    }

    public boolean checkNameIsValidLength(String customerName) {
        boolean success = true;
        if (customerName.length() < 3) {
            success = false;
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.customerName", "error.document.customer.customerNameLessThanThreeCharacters", new String[0]);
        }
        if (customerName.indexOf(32) > -1 && customerName.indexOf(32) < 3) {
            success = false;
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.customerName", "error.document.customer.customerNameNoSpacesInFirstThreeCharacters", new String[0]);
        }
        return success;
    }

    public boolean checkAddressIsValid(CustomerAddress customerAddress, int ind) {
        boolean isValid = true;
        String propertyName = "customerAddresses[" + ind + "].";
        if ("US".equalsIgnoreCase(customerAddress.getCustomerCountryCode())) {
            if (customerAddress.getCustomerZipCode() == null || "".equalsIgnoreCase(customerAddress.getCustomerZipCode())) {
                isValid = false;
                this.putFieldError(propertyName + "customerZipCode", "error.document.customer.zipCodeIsRequiredWhenCountryUS");
            }
            if (customerAddress.getCustomerStateCode() == null || "".equalsIgnoreCase(customerAddress.getCustomerStateCode())) {
                isValid = false;
                this.putFieldError(propertyName + "customerStateCode", "error.document.customer.stateCodeIsRequiredWhenCountryUS");
            }
        } else {
            if (customerAddress.getCustomerInternationalMailCode() == null || "".equalsIgnoreCase(customerAddress.getCustomerInternationalMailCode())) {
                isValid = false;
                this.putFieldError(propertyName + "customerInternationalMailCode", "error.document.customer.internationalMailCodeIsRequiredWhenCountryNonUS");
            }
            if (customerAddress.getCustomerAddressInternationalProvinceName() == null || "".equalsIgnoreCase(customerAddress.getCustomerAddressInternationalProvinceName())) {
                isValid = false;
                this.putFieldError(propertyName + "customerAddressInternationalProvinceName", "error.document.customer.addressInternationalProvinceNameIsRequiredWhenCountryNonUS");
            }
        }
        return isValid;
    }

    public boolean checkAddressIsValid(CustomerAddress customerAddress) {
        boolean isValid = true;
        if ("US".equalsIgnoreCase(customerAddress.getCustomerCountryCode())) {
            if (customerAddress.getCustomerZipCode() == null || "".equalsIgnoreCase(customerAddress.getCustomerZipCode())) {
                isValid = false;
                GlobalVariables.getMessageMap().putError("customerZipCode", "error.document.customer.zipCodeIsRequiredWhenCountryUS", new String[0]);
            }
            if (customerAddress.getCustomerStateCode() == null || "".equalsIgnoreCase(customerAddress.getCustomerStateCode())) {
                isValid = false;
                GlobalVariables.getMessageMap().putError("customerStateCode", "error.document.customer.stateCodeIsRequiredWhenCountryUS", new String[0]);
            }
        } else {
            if (customerAddress.getCustomerInternationalMailCode() == null || "".equalsIgnoreCase(customerAddress.getCustomerInternationalMailCode())) {
                isValid = false;
                GlobalVariables.getMessageMap().putError("customerInternationalMailCode", "error.document.customer.internationalMailCodeIsRequiredWhenCountryNonUS", new String[0]);
            }
            if (customerAddress.getCustomerAddressInternationalProvinceName() == null || "".equalsIgnoreCase(customerAddress.getCustomerAddressInternationalProvinceName())) {
                isValid = false;
                GlobalVariables.getMessageMap().putError("customerAddressInternationalProvinceName", "error.document.customer.addressInternationalProvinceNameIsRequiredWhenCountryNonUS", new String[0]);
            }
        }
        return isValid;
    }

    public boolean checkAddresses(Customer customer) {
        boolean isValid = true;
        boolean hasPrimaryAddress = false;
        for (CustomerAddress customerAddress : customer.getCustomerAddresses()) {
            if (!customerAddress.getCustomerAddressTypeCode().equalsIgnoreCase("P")) continue;
            if (hasPrimaryAddress) {
                isValid = false;
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.customerAddresses", "error.document.customer.oneAndOnlyOnePrimaryAddressRequired", new String[0]);
                continue;
            }
            hasPrimaryAddress = true;
        }
        if (!hasPrimaryAddress) {
            isValid = false;
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.customerAddresses", "error.document.customer.oneAndOnlyOnePrimaryAddressRequired", new String[0]);
        }
        return isValid;
    }

    public boolean validateAddresses(Customer customer) {
        boolean isValid = true;
        int i = 0;
        for (CustomerAddress customerAddress : customer.getCustomerAddresses()) {
            if (ObjectUtils.isNotNull((Object)customerAddress.getCustomerEmailAddress())) {
                String errorPath = "document.newMaintainableObject.customerAddresses[" + i + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                this.getDictionaryValidationService().validateBusinessObject((BusinessObject)customerAddress);
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            }
            ++i;
        }
        i = 0;
        for (CustomerAddress customerAddress : customer.getCustomerAddresses()) {
            isValid &= this.checkAddressIsValid(customerAddress, i);
            isValid &= this.validateEndDateForExistingCustomerAddress(customerAddress.getCustomerAddressEndDate(), i);
            ++i;
        }
        if (GlobalVariables.getMessageMap().getErrorCount() > 0) {
            isValid = false;
        }
        if (isValid) {
            i = 0;
            for (CustomerAddress customerAddress : customer.getCustomerAddresses()) {
                if (customerAddress.getCustomerAddressTypeCode().equalsIgnoreCase("P") && ObjectUtils.isNotNull((Object)customerAddress.getCustomerAddressEndDate())) {
                    isValid &= this.checkIfPrimaryAddressActive(customerAddress.getCustomerAddressEndDate(), i);
                }
                ++i;
            }
        }
        return isValid;
    }

    public boolean checkIfPrimaryAddressActive(java.sql.Date newEndDate, int ind) {
        boolean isActiveAddressFlag = this.checkEndDateIsValid(newEndDate, false);
        if (!isActiveAddressFlag) {
            String propertyName = "customerAddresses[" + ind + "]." + "customerAddressEndDate";
            this.putFieldError(propertyName, "error.document.customer.primaryAddressMustHaveFutureEndDate");
        }
        return isActiveAddressFlag;
    }

    public boolean checkTaxNumber(Customer customer) {
        boolean isValid = true;
        if (this.isTaxNumberRequired()) {
            boolean noTaxNumber;
            boolean bl = noTaxNumber = customer.getCustomerTaxNbr() == null || customer.getCustomerTaxNbr().equalsIgnoreCase("");
            if (noTaxNumber) {
                isValid = false;
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.customerSocialSecurityNumberIdentifier", "error.document.customer.taxNumberRequired", new String[0]);
            }
        }
        return isValid;
    }

    public boolean isTaxNumberRequired() {
        boolean paramExists = ((ParameterService)SpringContext.getBean(ParameterService.class)).parameterExists(Customer.class, "TAX_NUMBER_REQUIRED_IND");
        if (paramExists) {
            return ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(Customer.class, "TAX_NUMBER_REQUIRED_IND");
        }
        return false;
    }

    protected boolean checkStopWorkReason() {
        boolean success = true;
        if (this.newCustomer.isStopWorkIndicator() && StringUtils.isBlank((String)this.newCustomer.getStopWorkReason())) {
            success = false;
            this.putFieldError("stopWorkReason", "error.stop.work.reason.required");
        }
        return success;
    }
}

