/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.businessobject.NonInvoiced;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.NonAppliedHoldingService;
import org.kuali.kfs.module.ar.document.service.PaymentApplicationDocumentService;
import org.kuali.kfs.module.ar.document.validation.impl.PaymentApplicationDocumentRuleUtil;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationForm;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationInvoiceApply;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationInvoiceDetailApply;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentActionBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class PaymentApplicationAction
extends FinancialSystemTransactionalDocumentActionBase {
    protected static Logger LOG = Logger.getLogger(PaymentApplicationAction.class);
    protected BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    protected DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
    protected PaymentApplicationDocumentService paymentApplicationDocumentService = (PaymentApplicationDocumentService)SpringContext.getBean(PaymentApplicationDocumentService.class);
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
    protected CustomerInvoiceDetailService customerInvoiceDetailService = (CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class);
    protected NonAppliedHoldingService nonAppliedHoldingService = (NonAppliedHoldingService)SpringContext.getBean(NonAppliedHoldingService.class);

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doApplicationOfFunds((PaymentApplicationForm)form);
        return super.save(mapping, form, request, response);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, ServletRequest request, ServletResponse response) throws Exception {
        PaymentApplicationForm payAppForm = (PaymentApplicationForm)form;
        if (!payAppForm.getPaymentApplicationDocument().isFinal()) {
            this.doApplicationOfFunds(payAppForm);
        }
        return super.execute(mapping, form, request, response);
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doApplicationOfFunds((PaymentApplicationForm)form);
        return super.route(mapping, form, request, response);
    }

    public ActionForward deleteNonArLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm paymentApplicationForm = (PaymentApplicationForm)form;
        PaymentApplicationDocument paymentApplicationDocument = paymentApplicationForm.getPaymentApplicationDocument();
        Map parameters = request.getParameterMap();
        String indexToRemoveString = null;
        Integer indexToRemove = null;
        for (String k : parameters.keySet()) {
            if (!k.startsWith("methodToCall.deleteNonArLine.line") || !k.endsWith(".x") || null == parameters.get(k)) continue;
            int beginIndex = "methodToCall.deleteNonArLine.line".length();
            int endIndex = k.lastIndexOf(".");
            if (beginIndex < 0 || endIndex <= beginIndex) break;
            indexToRemoveString = k.substring(beginIndex, endIndex);
            break;
        }
        if (null != indexToRemoveString) {
            indexToRemove = new Integer(indexToRemoveString);
            NonInvoiced toRemove = null;
            for (NonInvoiced nonInvoiced : paymentApplicationDocument.getNonInvoiceds()) {
                if (!indexToRemove.equals(nonInvoiced.getFinancialDocumentLineNumber())) continue;
                toRemove = nonInvoiced;
                break;
            }
            if (null != toRemove) {
                paymentApplicationDocument.getNonInvoiceds().remove((Object)toRemove);
            }
        }
        Integer nonInvoicedItemNumber = 1;
        for (NonInvoiced n : paymentApplicationDocument.getNonInvoiceds()) {
            Integer n2 = nonInvoicedItemNumber;
            Integer n3 = nonInvoicedItemNumber = Integer.valueOf(nonInvoicedItemNumber + 1);
            n.setFinancialDocumentLineNumber(n2);
            n2 = nonInvoicedItemNumber;
            n3 = nonInvoicedItemNumber = Integer.valueOf(nonInvoicedItemNumber + 1);
            n.setFinancialDocumentLineNumber(n2);
            n.refreshReferenceObject("chartOfAccounts");
            n.refreshReferenceObject("account");
            n.refreshReferenceObject("subAccount");
            n.refreshReferenceObject("financialObject");
            n.refreshReferenceObject("financialSubObject");
            n.refreshReferenceObject("project");
        }
        return mapping.findForward("basic");
    }

    protected InvoicePaidApplied generateAndValidateNewPaidApplied(PaymentApplicationInvoiceDetailApply detailApplication, String fieldName, PaymentApplicationDocument document) {
        InvoicePaidApplied paidApplied = detailApplication.generatePaidApplied();
        LOG.debug((Object)("Validating the generated paidApplied " + paidApplied.getDocumentNumber()));
        PaymentApplicationDocumentRuleUtil.validateInvoicePaidApplied(paidApplied, fieldName, document);
        return paidApplied;
    }

    public ActionForward applyAllAmounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doApplicationOfFunds((PaymentApplicationForm)form);
        return mapping.findForward("basic");
    }

    protected void doApplicationOfFunds(PaymentApplicationForm paymentApplicationForm) throws WorkflowException {
        KualiDecimal controlTotalAmount;
        PaymentApplicationDocument paymentApplicationDocument = paymentApplicationForm.getPaymentApplicationDocument();
        ArrayList<InvoicePaidApplied> invoicePaidApplieds = new ArrayList<InvoicePaidApplied>();
        invoicePaidApplieds.addAll(this.applyToIndividualCustomerInvoiceDetails(paymentApplicationForm));
        invoicePaidApplieds.addAll(this.quickApplyToInvoices(paymentApplicationForm, invoicePaidApplieds));
        int paidAppliedItemNumber = 1;
        for (InvoicePaidApplied i : invoicePaidApplieds) {
            i.setPaidAppliedItemNumber(paidAppliedItemNumber++);
        }
        NonInvoiced nonInvoiced = this.applyNonInvoiced(paymentApplicationForm);
        NonAppliedHolding nonAppliedHolding = this.applyUnapplied(paymentApplicationForm);
        KualiDecimal sumOfInvoicePaidApplieds = KualiDecimal.ZERO;
        for (InvoicePaidApplied invoicePaidApplied : invoicePaidApplieds) {
            KualiDecimal amount = invoicePaidApplied.getInvoiceItemAppliedAmount();
            if (null == amount) {
                amount = KualiDecimal.ZERO;
            }
            sumOfInvoicePaidApplieds = (KualiDecimal)sumOfInvoicePaidApplieds.add((AbstractKualiDecimal)amount);
        }
        KualiDecimal appliedAmount = KualiDecimal.ZERO;
        appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)sumOfInvoicePaidApplieds);
        if (null != nonInvoiced && null != nonInvoiced.getFinancialDocumentLineAmount()) {
            appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)nonInvoiced.getFinancialDocumentLineAmount());
        }
        appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)paymentApplicationDocument.getSumOfNonAppliedDistributions());
        appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)paymentApplicationDocument.getSumOfNonInvoicedDistributions());
        appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)paymentApplicationDocument.getSumOfNonInvoiceds());
        if (null != paymentApplicationDocument.getNonAppliedHoldingAmount()) {
            appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)paymentApplicationDocument.getNonAppliedHoldingAmount());
        }
        if (appliedAmount.isGreaterThan((AbstractKualiDecimal)(controlTotalAmount = paymentApplicationForm.getTotalFromControl()))) {
            this.addGlobalError("error.document.paymentApplication.quickAppliedExceedsCashControlTotalAmount");
        }
        paymentApplicationDocument.getInvoicePaidApplieds().clear();
        paymentApplicationDocument.getInvoicePaidApplieds().addAll(invoicePaidApplieds);
        if (null != nonInvoiced) {
            paymentApplicationDocument.getNonInvoiceds().add(nonInvoiced);
            Integer nonInvoicedItemNumber = 1;
            for (NonInvoiced n : paymentApplicationDocument.getNonInvoiceds()) {
                Integer n2 = nonInvoicedItemNumber;
                Integer n3 = nonInvoicedItemNumber = Integer.valueOf(nonInvoicedItemNumber + 1);
                n.setFinancialDocumentLineNumber(n2);
                n.refreshReferenceObject("chartOfAccounts");
                n.refreshReferenceObject("account");
                n.refreshReferenceObject("subAccount");
                n.refreshReferenceObject("financialObject");
                n.refreshReferenceObject("financialSubObject");
                n.refreshReferenceObject("project");
            }
            paymentApplicationForm.setNonInvoicedAddLine(new NonInvoiced());
        }
        paymentApplicationForm.setNonAppliedControlAllocations(null);
        if (!paymentApplicationDocument.hasCashControlDetail()) {
            paymentApplicationDocument.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(appliedAmount);
        }
    }

    protected List<InvoicePaidApplied> applyToIndividualCustomerInvoiceDetails(PaymentApplicationForm paymentApplicationForm) {
        PaymentApplicationDocument paymentApplicationDocument = paymentApplicationForm.getPaymentApplicationDocument();
        String applicationDocNbr = paymentApplicationDocument.getDocumentNumber();
        int paidAppliedsGenerated = 1;
        int simpleInvoiceDetailApplicationCounter = 0;
        List<InvoicePaidApplied> invoicePaidApplieds = this.filterTempInvoicePaidApplieds(paymentApplicationForm);
        for (PaymentApplicationInvoiceApply invoiceApplication : paymentApplicationForm.getInvoiceApplications()) {
            for (PaymentApplicationInvoiceDetailApply detailApplication : invoiceApplication.getDetailApplications()) {
                String fieldName = "selectedInvoiceDetailApplications[" + Integer.toString(simpleInvoiceDetailApplicationCounter) + "].amountApplied";
                ++simpleInvoiceDetailApplicationCounter;
                if (detailApplication.isFullApply()) {
                    detailApplication.setAmountApplied(detailApplication.getAmountOpen());
                } else if (detailApplication.isFullApplyChanged()) {
                    detailApplication.setAmountApplied(KualiDecimal.ZERO);
                }
                if (KualiDecimal.ZERO.equals((Object)detailApplication.getAmountApplied()) || this.containsIdentical(detailApplication.getInvoiceDetail(), detailApplication.getAmountApplied(), invoicePaidApplieds)) continue;
                LOG.debug((Object)("Generating paid applied for detail application " + detailApplication.getInvoiceDocumentNumber()));
                InvoicePaidApplied invoicePaidApplied = this.generateAndValidateNewPaidApplied(detailApplication, fieldName, paymentApplicationDocument);
                GlobalVariables.getMessageMap().addToErrorPath("customerInvoiceDetail*");
                GlobalVariables.getMessageMap().removeFromErrorPath("customerInvoiceDetail*");
                invoicePaidApplieds.add(invoicePaidApplied);
                ++paidAppliedsGenerated;
            }
        }
        return invoicePaidApplieds;
    }

    protected List<InvoicePaidApplied> filterTempInvoicePaidApplieds(PaymentApplicationForm paymentApplicationForm) {
        PaymentApplicationDocument paymentApplicationDocument = paymentApplicationForm.getPaymentApplicationDocument();
        ArrayList<InvoicePaidApplied> filteredInvoicePaidApplieds = new ArrayList<InvoicePaidApplied>();
        List<InvoicePaidApplied> invoicePaidApplieds = paymentApplicationDocument.getInvoicePaidApplieds();
        String currentCustomerNumber = this.findCustomerNumber(paymentApplicationForm);
        for (InvoicePaidApplied invoicePaidApplied : invoicePaidApplieds) {
            filteredInvoicePaidApplieds.add(invoicePaidApplied);
        }
        return filteredInvoicePaidApplieds;
    }

    protected String findCustomerNumber(PaymentApplicationForm paymentApplicationForm) {
        boolean validInvoice = this.isValidInvoice(paymentApplicationForm);
        String customerNumber = paymentApplicationForm.getSelectedCustomerNumber();
        String currentInvoiceNumber = paymentApplicationForm.getEnteredInvoiceDocumentNumber();
        if (StringUtils.isBlank((String)customerNumber) && StringUtils.isNotBlank((String)currentInvoiceNumber) && validInvoice) {
            Customer customer = this.customerInvoiceDocumentService.getCustomerByInvoiceDocumentNumber(currentInvoiceNumber);
            customerNumber = customer.getCustomerNumber();
        }
        return customerNumber;
    }

    protected boolean isValidInvoice(PaymentApplicationForm paymentApplicationForm) {
        boolean validInvoice = true;
        if (StringUtils.isNotBlank((String)paymentApplicationForm.getEnteredInvoiceDocumentNumber())) {
            HashMap pkMap = new HashMap();
            if (!((CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class)).checkIfInvoiceNumberIsFinal(paymentApplicationForm.getEnteredInvoiceDocumentNumber())) {
                validInvoice &= false;
            }
        }
        return validInvoice;
    }

    protected boolean containsIdentical(CustomerInvoiceDetail customerInvoiceDetail, KualiDecimal amountApplied, List<InvoicePaidApplied> invoicePaidApplieds) {
        boolean identicalFlag = false;
        String custRefInvoiceDocNumber = customerInvoiceDetail.getDocumentNumber();
        Integer custInvoiceSequenceNumber = customerInvoiceDetail.getInvoiceItemNumber();
        for (InvoicePaidApplied invoicePaidApplied : invoicePaidApplieds) {
            String payAppDocNumber = invoicePaidApplied.getDocumentNumber();
            String refInvoiceDocNumber = invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber();
            Integer invoiceSequenceNumber = invoicePaidApplied.getInvoiceItemNumber();
            KualiDecimal appliedAmount = invoicePaidApplied.getInvoiceItemAppliedAmount();
            Integer paidAppliedItemNumber = invoicePaidApplied.getPaidAppliedItemNumber();
            if (!custRefInvoiceDocNumber.equals(refInvoiceDocNumber) || !custInvoiceSequenceNumber.equals(invoiceSequenceNumber) || !amountApplied.equals((Object)appliedAmount)) continue;
            identicalFlag = true;
            break;
        }
        return identicalFlag;
    }

    protected List<InvoicePaidApplied> quickApplyToInvoices(PaymentApplicationForm paymentApplicationForm, List<InvoicePaidApplied> appliedToIndividualDetails) {
        PaymentApplicationDocument applicationDocument = (PaymentApplicationDocument)paymentApplicationForm.getDocument();
        ArrayList<InvoicePaidApplied> invoicePaidApplieds = new ArrayList<InvoicePaidApplied>();
        boolean index = false;
        for (PaymentApplicationInvoiceApply invoiceApplication : paymentApplicationForm.getInvoiceApplications()) {
            String invoiceDocNumber = invoiceApplication.getDocumentNumber();
            if (!invoiceApplication.isQuickApply()) {
                if (!invoiceApplication.isQuickApplyChanged()) continue;
                for (PaymentApplicationInvoiceDetailApply detailApplication : invoiceApplication.getDetailApplications()) {
                    detailApplication.setAmountApplied(KualiDecimal.ZERO);
                    detailApplication.setFullApply(false);
                    for (int i = appliedToIndividualDetails.size() - 1; i >= 0; --i) {
                        InvoicePaidApplied applied = appliedToIndividualDetails.get(i);
                        if (!applied.getFinancialDocumentReferenceInvoiceNumber().equals(invoiceApplication.getDocumentNumber())) continue;
                        appliedToIndividualDetails.remove(i);
                    }
                }
                continue;
            }
            if (invoiceApplication.getOpenAmount().isZero()) {
                this.addGlobalError("error.document.paymentApplication.cannotQuickApplyOnInvoiceWithZeroOpenAmount");
                return invoicePaidApplieds;
            }
            for (int i = appliedToIndividualDetails.size() - 1; i >= 0; --i) {
                InvoicePaidApplied applied = appliedToIndividualDetails.get(i);
                if (!applied.getFinancialDocumentReferenceInvoiceNumber().equals(invoiceApplication.getDocumentNumber())) continue;
                appliedToIndividualDetails.remove(i);
            }
            String fieldName = "invoiceApplications[" + invoiceDocNumber + "].quickApply";
            for (PaymentApplicationInvoiceDetailApply detailApplication : invoiceApplication.getDetailApplications()) {
                detailApplication.setAmountApplied(detailApplication.getAmountOpen());
                detailApplication.setFullApply(true);
                InvoicePaidApplied paidApplied = this.generateAndValidateNewPaidApplied(detailApplication, fieldName, applicationDocument);
                if (paidApplied == null) continue;
                invoicePaidApplieds.add(paidApplied);
            }
            if (!invoiceDocNumber.equals(paymentApplicationForm.getEnteredInvoiceDocumentNumber())) continue;
            paymentApplicationForm.setSelectedInvoiceDocumentNumber(invoiceDocNumber);
        }
        return invoicePaidApplieds;
    }

    protected NonInvoiced applyNonInvoiced(PaymentApplicationForm payAppForm) throws WorkflowException {
        boolean isValid;
        PaymentApplicationDocument applicationDocument = (PaymentApplicationDocument)payAppForm.getDocument();
        NonInvoiced nonInvoiced = payAppForm.getNonInvoicedAddLine();
        if (ObjectUtils.isNull((Object)((Object)payAppForm.getNonInvoicedAddLine())) || nonInvoiced.getFinancialDocumentLineAmount() == null || nonInvoiced.getFinancialDocumentLineAmount().isZero()) {
            return null;
        }
        nonInvoiced.setFinancialDocumentPostingYear(applicationDocument.getPostingYear());
        nonInvoiced.setDocumentNumber(applicationDocument.getDocumentNumber());
        nonInvoiced.setFinancialDocumentLineNumber(payAppForm.getNextNonInvoicedLineNumber());
        if (StringUtils.isNotBlank((String)nonInvoiced.getChartOfAccountsCode())) {
            nonInvoiced.setChartOfAccountsCode(nonInvoiced.getChartOfAccountsCode().toUpperCase());
        }
        if (!(isValid = PaymentApplicationDocumentRuleUtil.validateNonInvoiced(nonInvoiced, applicationDocument, payAppForm.getTotalFromControl()))) {
            return null;
        }
        return nonInvoiced;
    }

    protected NonAppliedHolding applyUnapplied(PaymentApplicationForm payAppForm) throws WorkflowException {
        PaymentApplicationDocument payAppDoc = payAppForm.getPaymentApplicationDocument();
        KualiDecimal amount = payAppForm.getNonAppliedHoldingAmount();
        if (StringUtils.isNotBlank((String)payAppForm.getNonAppliedHoldingCustomerNumber())) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("customerNumber", payAppForm.getNonAppliedHoldingCustomerNumber().toUpperCase());
            int found = this.businessObjectService.countMatching(Customer.class, pkMap);
            if (found == 0) {
                this.addFieldError("document.nonAppliedHolding*", "document.nonAppliedHolding.customerNumber", "error.document.paymentApplication.enteredInvoiceCustomerNumberInvalid");
                return null;
            }
            payAppForm.setNonAppliedHoldingCustomerNumber(payAppForm.getNonAppliedHoldingCustomerNumber().toUpperCase());
        }
        if (payAppForm.getNonAppliedHoldingAmount() != null && payAppForm.getNonAppliedHoldingAmount().isNegative()) {
            this.addFieldError("document.nonAppliedHolding*", "document.nonAppliedHolding.financialDocumentLineAmount", "error.document.paymentApplication.unappliedAmountCannotBeNegative");
            return null;
        }
        if (StringUtils.isBlank((String)payAppForm.getNonAppliedHoldingCustomerNumber()) || amount == null || amount.isZero()) {
            payAppDoc.setNonAppliedHolding(null);
            return null;
        }
        NonAppliedHolding nonAppliedHolding = new NonAppliedHolding();
        nonAppliedHolding.setCustomerNumber(payAppForm.getNonAppliedHoldingCustomerNumber().toUpperCase());
        nonAppliedHolding.setReferenceFinancialDocumentNumber(payAppDoc.getDocumentNumber());
        nonAppliedHolding.setFinancialDocumentLineAmount(amount);
        payAppDoc.setNonAppliedHolding(nonAppliedHolding);
        boolean isValid = PaymentApplicationDocumentRuleUtil.validateNonAppliedHolding(payAppDoc, payAppForm.getTotalFromControl());
        if (!isValid) {
            return null;
        }
        return nonAppliedHolding;
    }

    protected void loadInvoices(PaymentApplicationForm payAppForm, String selectedInvoiceNumber) {
        String customerNumber;
        boolean validInvoice;
        PaymentApplicationDocument payAppDoc = payAppForm.getPaymentApplicationDocument();
        AccountsReceivableDocumentHeader arDocHeader = payAppDoc.getAccountsReceivableDocumentHeader();
        String currentInvoiceNumber = selectedInvoiceNumber;
        if (StringUtils.isNotBlank((String)payAppForm.getSelectedCustomerNumber())) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("customerNumber", payAppForm.getSelectedCustomerNumber());
            int found = this.businessObjectService.countMatching(Customer.class, pkMap);
            if (found == 0) {
                this.addFieldError("customerInvoiceDetail*", "selectedCustomerNumber", "error.document.paymentApplication.enteredInvoiceCustomerNumberInvalid");
            }
        }
        if (!(validInvoice = this.isValidInvoice(payAppForm))) {
            this.addFieldError("customerInvoiceDetail*", "enteredInvoiceDocumentNumber", "error.document.customerInvoiceDocument.notFinal");
        }
        if (StringUtils.isBlank((String)payAppForm.getSelectedCustomerNumber())) {
            if (StringUtils.isBlank((String)arDocHeader.getCustomerNumber())) {
                if (payAppDoc.hasCashControlDetail()) {
                    payAppForm.setSelectedCustomerNumber(payAppDoc.getCashControlDetail().getCustomerNumber());
                    arDocHeader.setCustomerNumber(payAppDoc.getCashControlDetail().getCustomerNumber());
                }
            } else {
                payAppForm.setSelectedCustomerNumber(arDocHeader.getCustomerNumber());
            }
        } else {
            arDocHeader.setCustomerNumber(payAppForm.getSelectedCustomerNumber());
        }
        if (StringUtils.isBlank((String)(customerNumber = payAppForm.getSelectedCustomerNumber())) && StringUtils.isNotBlank((String)currentInvoiceNumber) && validInvoice) {
            Customer customer = this.customerInvoiceDocumentService.getCustomerByInvoiceDocumentNumber(currentInvoiceNumber);
            customerNumber = customer.getCustomerNumber();
            payAppDoc.getAccountsReceivableDocumentHeader().setCustomerNumber(customerNumber);
        }
        if (StringUtils.isNotBlank((String)customerNumber) && !payAppDoc.hasCashControlDocument()) {
            ArrayList<PaymentApplicationDocument> nonAppliedControlDocs = new ArrayList<PaymentApplicationDocument>();
            ArrayList<NonAppliedHolding> nonAppliedControlHoldings = new ArrayList<NonAppliedHolding>();
            if (payAppDoc.isFinal()) {
                nonAppliedControlDocs.addAll(payAppDoc.getPaymentApplicationDocumentsUsedAsControlDocuments());
                nonAppliedControlHoldings.addAll(payAppDoc.getNonAppliedHoldingsUsedAsControls());
            } else {
                NonAppliedHoldingService nonAppliedHoldingService = (NonAppliedHoldingService)SpringContext.getBean(NonAppliedHoldingService.class);
                nonAppliedControlHoldings.addAll(nonAppliedHoldingService.getNonAppliedHoldingsForCustomer(customerNumber));
                ArrayList<String> controlDocNumbers = new ArrayList<String>();
                for (Object nonAppliedHolding : nonAppliedControlHoldings) {
                    if (!nonAppliedHolding.getAvailableUnappliedAmount().isPositive() || controlDocNumbers.contains(nonAppliedHolding.getReferenceFinancialDocumentNumber())) continue;
                    controlDocNumbers.add(nonAppliedHolding.getReferenceFinancialDocumentNumber());
                }
                if (!controlDocNumbers.isEmpty()) {
                    try {
                        List docs = this.documentService.getDocumentsByListOfDocumentHeaderIds(PaymentApplicationDocument.class, controlDocNumbers);
                        for (Document doc : docs) {
                            nonAppliedControlDocs.add((PaymentApplicationDocument)doc);
                        }
                    }
                    catch (WorkflowException e) {
                        throw new RuntimeException("A runtimeException was thrown when trying to retrieve a list of documents.", e);
                    }
                }
            }
            payAppForm.setNonAppliedControlDocs(nonAppliedControlDocs);
            payAppForm.setNonAppliedControlHoldings(nonAppliedControlHoldings);
            payAppDoc.setNonAppliedHoldingsForCustomer(new ArrayList<NonAppliedHolding>(nonAppliedControlHoldings));
            payAppForm.setNonAppliedControlAllocations(null);
        }
        if (StringUtils.isNotBlank((String)customerNumber)) {
            Collection<CustomerInvoiceDocument> openInvoicesForCustomer = payAppDoc.isFinal() ? payAppDoc.getInvoicesPaidAgainst() : this.customerInvoiceDocumentService.getOpenInvoiceDocumentsByCustomerNumber(customerNumber);
            payAppForm.setInvoices(new ArrayList<CustomerInvoiceDocument>(openInvoicesForCustomer));
            payAppForm.setupInvoiceWrappers(payAppDoc.getDocumentNumber());
        }
        if (StringUtils.isNotBlank((String)customerNumber) && StringUtils.isBlank((String)currentInvoiceNumber)) {
            currentInvoiceNumber = payAppForm.getInvoices() == null || payAppForm.getInvoices().isEmpty() ? null : payAppForm.getInvoices().get(0).getDocumentNumber();
        }
        if (StringUtils.isNotBlank((String)currentInvoiceNumber)) {
            payAppForm.setSelectedInvoiceDocumentNumber(currentInvoiceNumber);
            payAppForm.setEnteredInvoiceDocumentNumber(currentInvoiceNumber);
        }
        for (InvoicePaidApplied paidApplied : payAppDoc.getInvoicePaidApplieds()) {
            for (PaymentApplicationInvoiceApply invoiceApplication : payAppForm.getInvoiceApplications()) {
                if (!paidApplied.getFinancialDocumentReferenceInvoiceNumber().equalsIgnoreCase(invoiceApplication.getDocumentNumber())) continue;
                for (PaymentApplicationInvoiceDetailApply detailApplication : invoiceApplication.getDetailApplications()) {
                    if (!paidApplied.getInvoiceItemNumber().equals(detailApplication.getSequenceNumber()) || paidApplied.getInvoiceItemAppliedAmount().equals((Object)detailApplication.getAmountApplied())) continue;
                    detailApplication.setAmountApplied(paidApplied.getInvoiceItemAppliedAmount());
                    if (!paidApplied.getInvoiceItemAppliedAmount().equals((Object)detailApplication.getAmountOpen())) continue;
                    detailApplication.setFullApply(true);
                }
            }
        }
        payAppForm.setNonInvoicedAddLine(null);
        if (payAppDoc.getNonAppliedHolding() != null) {
            payAppForm.setNonAppliedHoldingCustomerNumber(payAppDoc.getNonAppliedHolding().getCustomerNumber());
            payAppForm.setNonAppliedHoldingAmount(payAppDoc.getNonAppliedHolding().getFinancialDocumentLineAmount());
        } else {
            payAppForm.setNonAppliedHoldingCustomerNumber(null);
            payAppForm.setNonAppliedHoldingAmount(null);
        }
        payAppForm.setInvoiceApplications(this.sortInvoiceApplications(payAppForm.getInvoiceApplications()));
    }

    protected List<PaymentApplicationInvoiceApply> sortInvoiceApplications(List<PaymentApplicationInvoiceApply> invoiceApplications) {
        EntryHolderComparator entryHolderComparator = new EntryHolderComparator();
        ArrayList<EntryHolder> entryHoldings = new ArrayList<EntryHolder>();
        for (PaymentApplicationInvoiceApply paymentApplicationInvoiceApply : invoiceApplications) {
            entryHoldings.add(new EntryHolder(paymentApplicationInvoiceApply.getInvoice().getDocumentHeader().getWorkflowDocument().getDateCreated().toDate(), paymentApplicationInvoiceApply));
        }
        if (entryHoldings.size() > 0) {
            Collections.sort(entryHoldings, entryHolderComparator);
        }
        ArrayList<PaymentApplicationInvoiceApply> results = new ArrayList<PaymentApplicationInvoiceApply>();
        for (EntryHolder entryHolder : entryHoldings) {
            results.add((PaymentApplicationInvoiceApply)entryHolder.getHolder());
        }
        return results;
    }

    public ActionForward goToInvoice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm payAppForm = (PaymentApplicationForm)form;
        this.loadInvoices(payAppForm, payAppForm.getSelectedInvoiceDocumentNumber());
        if (!payAppForm.getPaymentApplicationDocument().isFinal()) {
            this.doApplicationOfFunds(payAppForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward goToNextInvoice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm payAppForm = (PaymentApplicationForm)form;
        this.loadInvoices(payAppForm, payAppForm.getNextInvoiceDocumentNumber());
        if (!payAppForm.getPaymentApplicationDocument().isFinal()) {
            this.doApplicationOfFunds(payAppForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward goToPreviousInvoice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm payAppForm = (PaymentApplicationForm)form;
        this.loadInvoices(payAppForm, payAppForm.getPreviousInvoiceDocumentNumber());
        if (!payAppForm.getPaymentApplicationDocument().isFinal()) {
            this.doApplicationOfFunds(payAppForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward loadInvoices(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm pform = (PaymentApplicationForm)form;
        this.loadInvoices(pform, pform.getEnteredInvoiceDocumentNumber());
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm newForm = (PaymentApplicationForm)form;
        if (null == newForm.getCashControlDocument()) {
            return super.cancel(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        PaymentApplicationForm form = (PaymentApplicationForm)kualiDocumentFormBase;
        PaymentApplicationDocument document = form.getPaymentApplicationDocument();
        AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService = (AccountsReceivableDocumentHeaderService)SpringContext.getBean(AccountsReceivableDocumentHeaderService.class);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = accountsReceivableDocumentHeaderService.getNewAccountsReceivableDocumentHeaderForCurrentUser();
        accountsReceivableDocumentHeader.setDocumentNumber(document.getDocumentNumber());
        document.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        PaymentApplicationForm pform = (PaymentApplicationForm)kualiDocumentFormBase;
        this.loadInvoices(pform, pform.getEnteredInvoiceDocumentNumber());
    }

    protected void addFieldError(String errorPathToAdd, String propertyName, String errorKey) {
        GlobalVariables.getMessageMap().addToErrorPath(errorPathToAdd);
        GlobalVariables.getMessageMap().putError(propertyName, errorKey, new String[0]);
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPathToAdd);
    }

    protected void addGlobalError(String errorKey) {
        GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorKey, new String[]{"document.hiddenFieldForErrors"});
    }

    protected static class EntryHolderComparator
    implements Comparator<EntryHolder> {
        protected EntryHolderComparator() {
        }

        @Override
        public int compare(EntryHolder rosencrantz, EntryHolder guildenstern) {
            return rosencrantz.getDate().compareTo(guildenstern.getDate());
        }
    }

    protected class EntryHolder {
        private Date date;
        private Object holder;

        public EntryHolder(Date date, Object holder) {
            this.date = date;
            this.holder = holder;
        }

        public Date getDate() {
            return this.date;
        }

        public Object getHolder() {
            return this.holder;
        }
    }
}

