/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;

public class BillingFrequencyEnumTest {
    @Test
    public void testMilestoneAward() {
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)EasyMock.createMock(ContractsAndGrantsBillingAward.class);
        EasyMock.expect((Object)award.getBillingFrequencyCode()).andReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode()).anyTimes();
        EasyMock.replay((Object[])new Object[]{award});
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isMilestone should be true of awards with milestone", (boolean)ArConstants.BillingFrequencyValues.isMilestone((ContractsAndGrantsBillingAward)award));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of awards with milestones", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((ContractsAndGrantsBillingAward)award));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of awards with milestones", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((ContractsAndGrantsBillingAward)award));
    }

    @Test
    public void testPredeterminedBillingAward() {
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)EasyMock.createMock(ContractsAndGrantsBillingAward.class);
        EasyMock.expect((Object)award.getBillingFrequencyCode()).andReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode()).anyTimes();
        EasyMock.replay((Object[])new Object[]{award});
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isPredeterminedBilling should be true of awards with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((ContractsAndGrantsBillingAward)award));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMileston should not be true of awards with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((ContractsAndGrantsBillingAward)award));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of awards with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((ContractsAndGrantsBillingAward)award));
    }

    @Test
    public void testLetterOfCreditAward() {
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)EasyMock.createMock(ContractsAndGrantsBillingAward.class);
        EasyMock.expect((Object)award.getBillingFrequencyCode()).andReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode()).anyTimes();
        EasyMock.replay((Object[])new Object[]{award});
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isLetterOfCredit should be true of awards with letter of credit", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((ContractsAndGrantsBillingAward)award));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMileston should not be true of awards with letter of credit", (boolean)ArConstants.BillingFrequencyValues.isMilestone((ContractsAndGrantsBillingAward)award));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of awards with letter of credit", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((ContractsAndGrantsBillingAward)award));
    }

    @Test
    public void testMilestoneInvoiceGeneralDetail() {
        InvoiceGeneralDetail invoiceDetail = (InvoiceGeneralDetail)EasyMock.createMock(InvoiceGeneralDetail.class);
        EasyMock.expect((Object)invoiceDetail.getBillingFrequencyCode()).andReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode()).anyTimes();
        EasyMock.replay((Object[])new Object[]{invoiceDetail});
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isMilestone should be true of invoice general details with milestone", (boolean)ArConstants.BillingFrequencyValues.isMilestone((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with milestones", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with milestones", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isTimeBased should not be true of invoice general details with milestones", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((InvoiceGeneralDetail)invoiceDetail));
    }

    @Test
    public void testPredeterminedBillingInvoiceGeneralDetail() {
        InvoiceGeneralDetail invoiceDetail = (InvoiceGeneralDetail)EasyMock.createMock(InvoiceGeneralDetail.class);
        EasyMock.expect((Object)invoiceDetail.getBillingFrequencyCode()).andReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode()).anyTimes();
        EasyMock.replay((Object[])new Object[]{invoiceDetail});
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isPredeterminedBilling should be true of invoice general details with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isTimeBased should not be true of invoice general details with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((InvoiceGeneralDetail)invoiceDetail));
    }

    @Test
    public void testLetterOfCreditInvoiceGeneralDetail() {
        InvoiceGeneralDetail invoiceDetail = (InvoiceGeneralDetail)EasyMock.createMock(InvoiceGeneralDetail.class);
        EasyMock.expect((Object)invoiceDetail.getBillingFrequencyCode()).andReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode()).anyTimes();
        EasyMock.replay((Object[])new Object[]{invoiceDetail});
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with letter of credit billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with letter of credit billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isLetterOfCredit should be true of invoice general details with letter of credit billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isTimeBased should not be true of invoice general details with letter of credit billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((InvoiceGeneralDetail)invoiceDetail));
    }

    @Test
    public void testAnnuallyInvoiceGeneralDetail() {
        InvoiceGeneralDetail invoiceDetail = (InvoiceGeneralDetail)EasyMock.createMock(InvoiceGeneralDetail.class);
        EasyMock.expect((Object)invoiceDetail.getBillingFrequencyCode()).andReturn((Object)ArConstants.BillingFrequencyValues.ANNUALLY.getCode()).anyTimes();
        EasyMock.replay((Object[])new Object[]{invoiceDetail});
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should be not true of invoice general details with annual billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with annual billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with annual billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with annual billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((InvoiceGeneralDetail)invoiceDetail));
    }

    @Test
    public void testSemiAnnuallyInvoiceGeneralDetail() {
        InvoiceGeneralDetail invoiceDetail = (InvoiceGeneralDetail)EasyMock.createMock(InvoiceGeneralDetail.class);
        EasyMock.expect((Object)invoiceDetail.getBillingFrequencyCode()).andReturn((Object)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY.getCode()).anyTimes();
        EasyMock.replay((Object[])new Object[]{invoiceDetail});
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with semi-annual billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with semi-annual billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with semi-annual billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with semi-annual billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((InvoiceGeneralDetail)invoiceDetail));
    }

    @Test
    public void testQuarterlyInvoiceGeneralDetail() {
        InvoiceGeneralDetail invoiceDetail = (InvoiceGeneralDetail)EasyMock.createMock(InvoiceGeneralDetail.class);
        EasyMock.expect((Object)invoiceDetail.getBillingFrequencyCode()).andReturn((Object)ArConstants.BillingFrequencyValues.QUARTERLY.getCode()).anyTimes();
        EasyMock.replay((Object[])new Object[]{invoiceDetail});
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with quarterly billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with quarterly billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with quarterly billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with quarterly billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((InvoiceGeneralDetail)invoiceDetail));
    }

    @Test
    public void testMonthlyInvoiceGeneralDetail() {
        InvoiceGeneralDetail invoiceDetail = (InvoiceGeneralDetail)EasyMock.createMock(InvoiceGeneralDetail.class);
        EasyMock.expect((Object)invoiceDetail.getBillingFrequencyCode()).andReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode()).anyTimes();
        EasyMock.replay((Object[])new Object[]{invoiceDetail});
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with monthly billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with monthly billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with monthly billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((InvoiceGeneralDetail)invoiceDetail));
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with monthly billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((InvoiceGeneralDetail)invoiceDetail));
    }
}

