/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.impl.ContractsGrantsInvoiceBatchCreateDocumentServiceImpl;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorMessage;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateTestBase;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.kfs)
public class ContractsGrantsInvoiceBatchCreateDocumentServiceTest
extends ContractsGrantsInvoiceCreateTestBase {
    protected ContractsGrantsInvoiceBatchCreateDocumentServiceImpl contractsGrantsInvoiceBatchCreateDocumentService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.contractsGrantsInvoiceBatchCreateDocumentService = new ContractsGrantsInvoiceBatchCreateDocumentServiceImpl();
        this.contractsGrantsInvoiceBatchCreateDocumentService.setConfigurationService(this.configurationService);
        this.contractsGrantsInvoiceBatchCreateDocumentService.setContractsGrantsInvoiceCreateDocumentService((ContractsGrantsInvoiceCreateDocumentService)this.contractsGrantsInvoiceCreateDocumentService);
    }

    public void testBatchCreateCGInvoiceDocumentsByAwardsOneValid() throws Exception {
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.buildMockUniversityDateService());
        List<ContractsAndGrantsBillingAward> awards = this.setupBillableAwards();
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertFalse((String)"errors should not be written", (boolean)errors.exists());
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertEquals((String)"no errors should be persisted", (int)0, (int)persistedErrors.size());
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
    }

    protected ContractsGrantsInvoiceBatchCreateDocumentServiceImpl setInvoiceCreateServiceOnInvoiceBatchCreateService(ContractsGrantsInvoiceCreateDocumentServiceImpl contractsGrantsInvoiceCreateDocumentService) throws Exception {
        ContractsGrantsInvoiceBatchCreateDocumentServiceImpl contractsGrantsInvoiceBatchCreateDocumentService = (ContractsGrantsInvoiceBatchCreateDocumentServiceImpl)TestUtils.getUnproxiedService((String)"contractsGrantsInvoiceBatchCreateDocumentService");
        contractsGrantsInvoiceBatchCreateDocumentService.setContractsGrantsInvoiceCreateDocumentService((ContractsGrantsInvoiceCreateDocumentService)contractsGrantsInvoiceCreateDocumentService);
        return contractsGrantsInvoiceBatchCreateDocumentService;
    }

    public void testBatchCreateCGInvoiceDocumentsByAwardsEmptyAwardsList() throws IOException {
        ArrayList awards = new ArrayList();
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.award");
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"process type should be batch", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode()));
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByAwardsNullAwardsList() throws IOException {
        Collection awards = null;
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.award");
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"process type should be batch", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode()));
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByAwardsNoOrg() throws IOException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setAwardOrganizations(new ArrayList());
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.organization.on.award");
        errorMessage = MessageFormat.format(errorMessage, award.getProposalNumber().toString());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"process type should be batch", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode()));
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByAccountNonBillable() throws WorkflowException, IOException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwards();
        Award award2 = (Award)awards2.get(0);
        award2.setInvoicingOptionCode("2");
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, ((ContractsAndGrantsBillingAwardAccount)award2.getActiveAwardAccounts().get(0)).getAccountNumber(), award.getProposalNumber().toString());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"process type should be batch", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode()));
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByAccountOneBillableOneNonBillable() throws Exception {
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.buildMockUniversityDateService());
        List<ContractsAndGrantsBillingAward> awards = this.setupBillableAwards();
        Award award = (Award)awards.get(0);
        award.setInvoicingOptionCode("2");
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        awardAccount_2.setCurrentLastBilledDate(new Date(System.currentTimeMillis()));
        awardAccount_2.refreshReferenceObject("account");
        award.getAwardAccounts().add(awardAccount_2);
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, awardAccount_2.getAccountNumber(), award.getProposalNumber().toString());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"process type should be batch", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode()));
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
    }

    public void testBatchCreateCGInvoiceDocumentsByCCAContractAccountNotBillable() throws WorkflowException, IOException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwards();
        Award award2 = (Award)awards2.get(0);
        award2.setInvoicingOptionCode("3");
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.control.account.non.billable");
        errorMessage = MessageFormat.format(errorMessage, ((ContractsAndGrantsBillingAwardAccount)award2.getActiveAwardAccounts().get(0)).getAccount().getContractControlAccount().getAccountNumber(), award.getProposalNumber().toString());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"process type should be batch", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode()));
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByAwardNotAllBillableAccounts() throws WorkflowException, IOException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwards();
        Award award2 = (Award)awards2.get(0);
        award2.setInvoicingOptionCode("1");
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.not.all.billable.accounts");
        errorMessage = MessageFormat.format(errorMessage, award2.getProposalNumber().toString());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"process type should be batch", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode()));
            ContractsGrantsInvoiceBatchCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }
}

