/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.fixture;

import java.sql.Date;
import java.util.ArrayList;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.BillingFrequency;
import org.kuali.kfs.module.ar.businessobject.DunningCampaign;
import org.kuali.kfs.module.ar.fixture.ARAgencyFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardOrganizationFixture;
import org.kuali.kfs.module.ar.fixture.BillingFrequencyFixture;
import org.kuali.kfs.module.ar.fixture.DunningCampaignFixture;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardOrganization;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public enum ARAwardFixture {
    CG_AWARD1("11", "2011-10-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, null, true, null),
    CG_AWARD2("11", "2011-07-01", "1969-06-30", Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), KualiDecimal.ZERO, false, null, true, null),
    CG_AWARD3("1234", "2011-01-01", "2011-09-22", Date.valueOf("2011-10-01"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, null, true, null),
    CG_AWARD4("11", "2011-07-01", new Date(System.currentTimeMillis() + 604800000L).toString(), Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), KualiDecimal.ZERO, false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD5("11", "2011-07-01", "1969-06-30", Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), KualiDecimal.ZERO, false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD6("11", "2011-07-01", new Date(System.currentTimeMillis() + 604800000L).toString(), Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), new KualiDecimal(1000000.0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD7("11", "2011-07-01", new Date(System.currentTimeMillis() + 604800000L).toString(), Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), null, false, null, true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD8("11", "2011-07-01", "1969-06-30", Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), KualiDecimal.ZERO, false, "1", true, null),
    CG_AWARD9("11", "2011-07-01", new Date(System.currentTimeMillis() + 604800000L).toString(), Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), KualiDecimal.ZERO, false, "1", true, BillingFrequencyFixture.BILL_FREQ_LOCB.createBillingFrequency()),
    CG_AWARD10("11", "2011-07-01", new Date(System.currentTimeMillis() + 604800000L).toString(), Date.valueOf("1969-01-01"), new KualiDecimal(100000.0), KualiDecimal.ZERO, KualiDecimal.ZERO, false, "1", true, BillingFrequencyFixture.BILL_FREQ_LOCB.createBillingFrequency()),
    CG_AWARD_INV_AWARD("11", "2011-10-01", "2011-09-22", Date.valueOf("2011-10-01"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, null),
    CG_AWARD_INV_ACCOUNT("11", "2011-10-01", "2011-09-22", Date.valueOf("2011-10-01"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "Income", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD_INV_CCA("11", "2011-10-01", "2011-09-22", Date.valueOf("2011-10-01"), null, null, null, false, "3", true, null),
    CG_AWARD_MONTHLY_BILLED_DATE_NULL("11", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD_MILESTONE_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MS.createBillingFrequency()),
    CG_AWARD_PREDETERMINED_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency()),
    CG_AWARD_QUAR_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_QUAR.createBillingFrequency()),
    CG_AWARD_SEMI_ANN_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_SEMI_ANN.createBillingFrequency()),
    CG_AWARD_ANNUAL_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_ANNUALLY.createBillingFrequency()),
    CG_AWARD_LOCB_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_LOCB.createBillingFrequency()),
    CG_AWARD_MONTHLY_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2011-09-30"), new KualiDecimal(1000), new KualiDecimal(1000), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD_MILESTONE_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2011-09-30"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MS.createBillingFrequency()),
    CG_AWARD_PREDETERMINED_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2011-09-30"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency()),
    CG_AWARD_QUAR_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2011-06-30"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_QUAR.createBillingFrequency()),
    CG_AWARD_SEMI_ANN_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2011-06-30"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_SEMI_ANN.createBillingFrequency()),
    CG_AWARD_ANNUAL_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2010-06-30"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_ANNUALLY.createBillingFrequency()),
    CG_AWARD_LOCB_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2010-12-13"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_LOCB.createBillingFrequency()),
    CG_AWARD_MONTHLY_INVALID_DATES("11", "2012-01-01", "2011-09-22", new Date(System.currentTimeMillis() + 604800000L), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency());

    private String proposalNumber;
    private String awardBeginningDate;
    private String awardEndingDate;
    private Date lastBilledDate;
    private KualiDecimal awardDirectCostAmount;
    private KualiDecimal awardIndirectCostAmount;
    private KualiDecimal minInvoiceAmount;
    private KualiDecimal awardTotalAmount;
    private boolean excludedFromInvoicing;
    private String invoicingOptionCode;
    private boolean active;
    private BillingFrequency billingFrequency;

    private ARAwardFixture(String proposalNumber, String awardBeginningDate, String awardEndingDate, Date lastBilledDate, KualiDecimal awardDirectCostAmount, KualiDecimal awardIndirectCostAmount, KualiDecimal minInvoiceAmount, boolean excludedFromInvoicing, String invoicingOptionCode, boolean active, BillingFrequency billingFrequency) {
        this.proposalNumber = proposalNumber;
        this.awardBeginningDate = awardBeginningDate;
        this.awardEndingDate = awardEndingDate;
        this.lastBilledDate = lastBilledDate;
        this.awardDirectCostAmount = awardDirectCostAmount;
        this.awardIndirectCostAmount = awardIndirectCostAmount;
        this.minInvoiceAmount = minInvoiceAmount;
        this.excludedFromInvoicing = excludedFromInvoicing;
        this.invoicingOptionCode = invoicingOptionCode;
        this.active = active;
        this.billingFrequency = billingFrequency;
    }

    public ContractsAndGrantsBillingAward createAward() {
        Award award = new Award();
        this.populateAwardFromFixture(award);
        return award;
    }

    public ContractsAndGrantsBillingAward createAwardWithLastBillingDate() {
        AwardWithLastBilledDate award = new AwardWithLastBilledDate();
        this.populateAwardFromFixture(award);
        award.setLastBilledDate(this.lastBilledDate);
        return award;
    }

    protected void populateAwardFromFixture(Award award) {
        award.setProposalNumber(this.proposalNumber);
        award.setAwardBeginningDate(Date.valueOf(this.awardBeginningDate));
        award.setAwardEndingDate(Date.valueOf(this.awardEndingDate));
        award.setAwardDirectCostAmount(this.awardDirectCostAmount);
        award.setAwardIndirectCostAmount(this.awardIndirectCostAmount);
        award.setMinInvoiceAmount(this.minInvoiceAmount);
        award.setExcludedFromInvoicing(this.excludedFromInvoicing);
        award.setInvoicingOptionCode(this.invoicingOptionCode);
        award.setActive(this.active);
        award.setBillingFrequency((AccountsReceivableBillingFrequency)this.billingFrequency);
        if (ObjectUtils.isNotNull((Object)this.billingFrequency)) {
            award.setBillingFrequencyCode(this.billingFrequency.getFrequency());
        }
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_1.createAwardAccount();
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_2.createAwardAccount();
        if (ObjectUtils.isNotNull((Object)this.lastBilledDate)) {
            awardAccount_1.setCurrentLastBilledDate(this.lastBilledDate);
            awardAccount_2.setCurrentLastBilledDate(this.lastBilledDate);
        }
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        awardAccounts.add(awardAccount_2);
        award.setAwardAccounts(awardAccounts);
        BillingFrequencyFixture.BILL_FREQ_LOCB.createBillingFrequency();
        award.setAutoApproveIndicator(true);
    }

    public Award setAgencyFromFixture(Award award) {
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        award.setAgency(agency);
        award.setAgencyNumber(agency.getAgencyNumber());
        return award;
    }

    public Award setDunningCampaignFromFixture(Award award) {
        DunningCampaign dunningCampaign = DunningCampaignFixture.AR_DUNC1.createDunningCampaign();
        award.setDunningCampaign(dunningCampaign.getCampaignID());
        return award;
    }

    public Award setAwardOrganizationFromFixture(Award award) {
        AwardOrganization awardOrganization = ARAwardOrganizationFixture.AWD_ORG1.createAwardOrganization();
        award.getAwardOrganizations().add(awardOrganization);
        return award;
    }

    public class AwardWithLastBilledDate
    extends Award {
        protected Date lbd;

        public Date getLastBilledDate() {
            return this.lbd;
        }

        public void setLastBilledDate(Date lbd) {
            this.lbd = lbd;
        }
    }
}

