/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service;

import java.util.ArrayList;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class AccountsReceivableModuleBillingServiceTest
extends KualiTestBase {
    protected AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;
    protected BusinessObjectService businessObjectService;

    public void setUp() {
        this.accountsReceivableModuleBillingService = (AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    public void testHasActiveBills() {
        this.setupPredeterminedBillingSchedule("1", true);
        this.setupPredeterminedBillingSchedule("2", false);
        AccountsReceivableModuleBillingServiceTest.assertTrue((boolean)this.accountsReceivableModuleBillingService.hasActiveBills("1"));
        AccountsReceivableModuleBillingServiceTest.assertFalse((boolean)this.accountsReceivableModuleBillingService.hasActiveBills("2"));
        AccountsReceivableModuleBillingServiceTest.assertFalse((boolean)this.accountsReceivableModuleBillingService.hasActiveBills("111"));
    }

    public void testHasActiveMilestones() {
        this.setupMilestoneSchedule("1", true);
        this.setupMilestoneSchedule("2", false);
        AccountsReceivableModuleBillingServiceTest.assertTrue((boolean)this.accountsReceivableModuleBillingService.hasActiveMilestones("1"));
        AccountsReceivableModuleBillingServiceTest.assertFalse((boolean)this.accountsReceivableModuleBillingService.hasActiveMilestones("2"));
        AccountsReceivableModuleBillingServiceTest.assertFalse((boolean)this.accountsReceivableModuleBillingService.hasActiveMilestones("111"));
    }

    protected void setupMilestoneSchedule(String proposalNumber, boolean active) {
        Milestone milestone = new Milestone();
        milestone.setProposalNumber(proposalNumber);
        milestone.setMilestoneNumber(Long.valueOf(Long.parseLong(proposalNumber)));
        milestone.setMilestoneIdentifier(Long.valueOf(Long.parseLong(proposalNumber) + 1000L));
        milestone.setActive(active);
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        milestoneSchedule.setProposalNumber(proposalNumber);
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(milestone);
        milestoneSchedule.setMilestones(milestones);
        this.businessObjectService.save((PersistableBusinessObject)milestoneSchedule);
        this.businessObjectService.save((PersistableBusinessObject)milestone);
    }

    protected void setupPredeterminedBillingSchedule(String proposalNumber, boolean active) {
        Bill bill = new Bill();
        bill.setProposalNumber(proposalNumber);
        bill.setBillNumber(Long.valueOf(Long.parseLong(proposalNumber)));
        bill.setBillIdentifier(Long.valueOf(Long.parseLong(proposalNumber) + 1000L));
        bill.setActive(active);
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule.setProposalNumber(proposalNumber);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill);
        predeterminedBillingSchedule.setBills(bills);
        this.businessObjectService.save((PersistableBusinessObject)predeterminedBillingSchedule);
        this.businessObjectService.save((PersistableBusinessObject)bill);
    }
}

