/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardOrganizationFixture;
import org.kuali.kfs.module.ar.fixture.BillingFrequencyFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceBillFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceMilestoneFixture;
import org.kuali.kfs.module.ar.fixture.OrganizationAccountingDefaultFixture;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardOrganization;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ContractsGrantsInvoiceCreateDocumentServiceImplTest
extends KualiTestBase {
    private ContractsGrantsInvoiceCreateDocumentServiceImpl contractsGrantsInvoiceCreateDocumentServiceImpl;
    protected ConfigurationService configurationService;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected VerifyBillingFrequencyService verifyBillingFrequencyService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected BusinessObjectService businessObjectService;
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected AccountingPeriodService accountingPeriodService;
    protected AccountService accountService;
    protected ContractsGrantsBillingAwardVerificationService contractsGrantsBillingAwardVerificationService;

    public void setUp() throws Exception {
        super.setUp();
        this.configurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        this.contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        this.verifyBillingFrequencyService = (VerifyBillingFrequencyService)SpringContext.getBean(VerifyBillingFrequencyService.class);
        this.financialSystemDocumentService = (FinancialSystemDocumentService)SpringContext.getBean(FinancialSystemDocumentService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.accountingPeriodService = (AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class);
        this.accountService = (AccountService)SpringContext.getBean(AccountService.class);
        this.contractsGrantsBillingAwardVerificationService = (ContractsGrantsBillingAwardVerificationService)SpringContext.getBean(ContractsGrantsBillingAwardVerificationService.class);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setConfigurationService(this.configurationService);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentService);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setVerifyBillingFrequencyService(this.verifyBillingFrequencyService);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setFinancialSystemDocumentService(this.financialSystemDocumentService);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setBusinessObjectService(this.businessObjectService);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setAccountService(this.accountService);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setContractsGrantsBillingAwardVerificationService(this.contractsGrantsBillingAwardVerificationService);
    }

    public void testPerformAwardValidationStartDateMissing() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        ((Award)award).setAwardBeginningDate(null);
        awards.add(award);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(award)).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.startDate.missing")));
    }

    public void testPerformAwardValidationInvalidBillingFrequency() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        awards.add(award);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(award)).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.billing.missing.frequency")));
    }

    public void testPerformAwardValidationInvalidBillingPeriod() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_INVALID_DATES.createAward();
        ((Award)award).setAwardBeginningDate(new Date(DateTimeUtils.currentTimeMillis()));
        awards.add(award);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(award)).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.not.eligible.invoice")));
    }

    public void testPerformAwardValidationValidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should be empty.", (invalidGroup.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should  contain one award.", (qualifiedAwards.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should contain our initial award.", (boolean)((ContractsAndGrantsBillingAward)qualifiedAwards.get(0)).equals(awards.get(0)));
    }

    public void testPerformAwardValidationAwardInvoicingSuspended() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).setExcludedFromInvoicing(true);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.excluded.from.invoicing")));
    }

    public void testPerformAwardValidationInactiveAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).setActive(false);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.inactive")));
    }

    public void testPerformAwardValidationSuspendedAndInactiveAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).setActive(false);
        ((Award)awards.get(0)).setExcludedFromInvoicing(true);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.excluded.from.invoicing")));
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(1)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.inactive")));
    }

    public void testPerformAwardValidationTwoInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwards();
        ((Award)awards.get(0)).setActive(false);
        ((Award)awards2.get(0)).setExcludedFromInvoicing(true);
        awards.addAll(awards2);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 2 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our first award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.inactive")));
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our second award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(1))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.excluded.from.invoicing")));
    }

    public void testPerformAwardValidationOneValidOneInvalidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwards();
        ((Award)awards2.get(0)).setExcludedFromInvoicing(true);
        awards.addAll(awards2);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertEquals((String)"invalidGroup should contain one award.", (int)1, (int)invalidGroup.size());
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertEquals((String)"qualifiedAwards should contain one award.", (int)1, (int)qualifiedAwards.size());
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should contain our initial award.", (boolean)((ContractsAndGrantsBillingAward)qualifiedAwards.get(0)).equals(awards.get(0)));
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our second award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(1))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.excluded.from.invoicing")));
    }

    public void testPerformAwardValidationMissingAwardInvoicingOption() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).setInvoicingOptionCode(null);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.missing")));
    }

    public void testPerformAwardValidationInvalidPredeterminedBillingFrequency() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        award.setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        awardAccount_2.refreshReferenceObject("account");
        award.getAwardAccounts().add(awardAccount_2);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.single.account")));
    }

    public void testPerformAwardValidationInvalidMilestoneBillingFrequency() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        awardAccount_2.refreshReferenceObject("account");
        award.getAwardAccounts().add(awardAccount_2);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.single.account")));
    }

    public void testPerformAwardValidationNoActiveAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).getAwardAccounts().clear();
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.no.active.accounts.assigned")));
    }

    public void testPerformAwardValidationExpiredAccount() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        List awardAccounts = ((Award)awards.get(0)).getActiveAwardAccounts();
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardAccounts) {
            ((AwardAccount)awardAccount).getAccount().setAccountExpirationDate(new Date(DateTime.now().minusDays(1).toDate().getTime()));
        }
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(this.configurationService.getPropertyValueAsString("error.cginvoice.award.contain.expired.account"));
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardAccounts) {
            errorMessage.append(" (expired account: " + ((AwardAccount)awardAccount).getAccount().getAccountNumber() + " expiration date " + ((AwardAccount)awardAccount).getAccount().getAccountExpirationDate() + ") ");
        }
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(errorMessage.toString()));
    }

    public void testPerformAwardValidationExpiredAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        List awardAccounts = ((Award)awards.get(0)).getAwardAccounts();
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        awardAccount_2.refreshReferenceObject("account");
        awardAccounts.add(awardAccount_2);
        for (AwardAccount awardAccount : awardAccounts) {
            awardAccount.getAccount().setAccountExpirationDate(new Date(DateTime.now().minusDays(1).toDate().getTime()));
        }
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(this.configurationService.getPropertyValueAsString("error.cginvoice.award.contain.expired.account"));
        for (ContractsAndGrantsBillingAwardAccount awardAccount : awardAccounts) {
            errorMessage.append(" (expired account: " + ((AwardAccount)awardAccount).getAccount().getAccountNumber() + " expiration date " + ((AwardAccount)awardAccount).getAccount().getAccountExpirationDate() + ") ");
        }
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(errorMessage.toString()));
    }

    public void testPerformAwardValidationAwardFinalInvoiceAlreadyBilled() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        List awardAccounts = ((Award)awards.get(0)).getAwardAccounts();
        for (AwardAccount awardAccount : awardAccounts) {
            awardAccount.setFinalBilledIndicator(true);
        }
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.already.billed")));
    }

    public void testPerformAwardValidationAwardFinalInvoiceAlreadyBilledTwoAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        List awardAccounts = ((Award)awards.get(0)).getAwardAccounts();
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        awardAccount_2.refreshReferenceObject("account");
        awardAccounts.add(awardAccount_2);
        for (AwardAccount awardAccount : awardAccounts) {
            awardAccount.setFinalBilledIndicator(true);
        }
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.already.billed")));
    }

    public void testPerformAwardValidationAwardFinalInvoicePartiallyBilled() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        List awardAccounts = ((Award)awards.get(0)).getAwardAccounts();
        for (AwardAccount awardAccount : awardAccounts) {
            awardAccount.setFinalBilledIndicator(true);
        }
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        awardAccount_2.refreshReferenceObject("account");
        awardAccounts.add(awardAccount_2);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.already.billed")));
    }

    public void testPerformAwardValidationNoValidMilestonesToInvoice() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.not.valid.milestones")));
    }

    public void testPerformAwardValidationNoValidBillsToInvoice() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ((Award)awards.get(0)).setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.not.valid.bills")));
    }

    public void testPerformAwardValidationOneValidOneInvalidAwardAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        awardAccount_2.setCurrentLastBilledDate(new Date(System.currentTimeMillis()));
        awardAccount_2.refreshReferenceObject("account");
        ((Award)awards.get(0)).getAwardAccounts().add(awardAccount_2);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should be empty", (invalidGroup.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should contain one award.", (qualifiedAwards.size() == 1 ? 1 : 0) != 0);
    }

    public void testPerformAwardValidationAgencyHasNoMatchingCustomer() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).getAgency().setCustomerNumber(null);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.not.valid.customer")));
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testPerformAwardValidationNoValidAwardAccounts() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = ((ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class)).createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cgivoice.award.not.valid.accounts")));
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testPerformAwardValidAwardAccountsValidationMilestone() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = ((ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class)).createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.not.valid.milestones")));
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testPerformAwardValidAwardAccountsValidationPredeterminedBilling() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        award.setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = ((ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class)).createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.award.not.valid.bills")));
    }

    public void testPerformAwardValidationNoContractControlAccountsByCCA() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).setInvoicingOptionCode("3");
        List awardAccounts = ((Award)awards.get(0)).getAwardAccounts();
        for (AwardAccount awardAccount : awardAccounts) {
            awardAccount.getAccount().setContractControlAccount(null);
        }
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertEquals((String)"invalidGroup should contain our initial award with the error message we're expecting.", (String)this.configurationService.getPropertyValueAsString("error.cg.no.control.account").replace("{0}", awards.get(0).getInvoicingOptionDescription()), (String)((String)((List)invalidGroup.get(awards.get(0))).get(0)));
    }

    public void testPerformAwardValidationNoContractControlAccountsByAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).setInvoicingOptionCode("1");
        List awardAccounts = ((Award)awards.get(0)).getAwardAccounts();
        for (AwardAccount awardAccount : awardAccounts) {
            awardAccount.getAccount().setContractControlAccount(null);
        }
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertEquals((String)"invalidGroup should contain our initial award with the error message we're expecting.", (String)this.configurationService.getPropertyValueAsString("error.cg.no.control.account").replace("{0}", awards.get(0).getInvoicingOptionDescription()), (String)((String)((List)invalidGroup.get(awards.get(0))).get(0)));
    }

    public void testPerformAwardValidationMultipleContractControlAccountsByAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        ((Award)awards.get(0)).setInvoicingOptionCode("1");
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_3.createAwardAccount();
        awardAccount_2.refreshReferenceObject("account");
        ((Award)awards.get(0)).getAwardAccounts().add(awardAccount_2);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cg.multiple.control.account").replace("{0}", awards.get(0).getInvoicingOptionDescription())));
    }

    public void testPerformAwardValidationNoSysInfo() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.getAwardOrganizations().clear();
        AwardOrganization awardOrganization = ARAwardOrganizationFixture.AWD_ORG2.createAwardOrganization();
        award.getAwardOrganizations().add(awardOrganization);
        OrganizationAccountingDefault orgAcctDefault = OrganizationAccountingDefaultFixture.BASE_OAD.createOrganizationAccountingDefault();
        this.businessObjectService.save((PersistableBusinessObject)orgAcctDefault);
        OrganizationOptions organizationOptions = new OrganizationOptions();
        organizationOptions.setChartOfAccountsCode(orgAcctDefault.getChartOfAccountsCode());
        organizationOptions.setOrganizationCode(orgAcctDefault.getOrganizationCode());
        organizationOptions.setProcessingChartOfAccountCode(orgAcctDefault.getChartOfAccountsCode());
        organizationOptions.setProcessingOrganizationCode(orgAcctDefault.getOrganizationCode());
        this.businessObjectService.save((PersistableBusinessObject)organizationOptions);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.sys.info.not.setup")));
    }

    public void testPerformAwardValidationNoOrgAccountingDefault() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.getAwardOrganizations().clear();
        AwardOrganization awardOrganization = ARAwardOrganizationFixture.AWD_ORG3.createAwardOrganization();
        award.getAwardOrganizations().add(awardOrganization);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.sys.info.not.setup")));
    }

    public void testPerformAwardValidationNoSysInfoOrOrgAccountingDefault() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.getAwardOrganizations().clear();
        AwardOrganization awardOrganization = ARAwardOrganizationFixture.AWD_ORG4.createAwardOrganization();
        award.getAwardOrganizations().add(awardOrganization);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cginvoice.sys.info.not.setup")));
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testPerformAwardValidationInvoicesInProgressMilestone() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = ((ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class)).createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupMilestones(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cgivoice.award.not.valid.accounts")));
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testPerformAwardValidationInvoicesInProgressPredeterminedBilling() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        award.setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = ((ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class)).createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        HashMap invalidGroup = new HashMap();
        ArrayList qualifiedAwards = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain one award.", (invalidGroup.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceImplTest.assertTrue((String)"invalidGroup should contain our initial award with the error message we're expecting.", (boolean)((String)((List)invalidGroup.get(awards.get(0))).get(0)).equals(this.configurationService.getPropertyValueAsString("error.cgivoice.award.not.valid.accounts")));
    }

    protected List<ContractsAndGrantsBillingAward> setupAwards() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.createAward();
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAgencyFromFixture((Award)award);
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1.createAwardAccount();
        awardAccount_1.refreshReferenceObject("account");
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        ((Award)award).setAwardAccounts(awardAccounts);
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAwardOrganizationFromFixture((Award)award);
        awards.add(award);
        return awards;
    }

    protected void setupMilestones(ContractsGrantsInvoiceDocument document) {
        ArrayList<InvoiceMilestone> invoiceMilestones = new ArrayList<InvoiceMilestone>();
        InvoiceMilestone invMilestone_1 = InvoiceMilestoneFixture.INV_MLSTN_2.createInvoiceMilestone();
        invMilestone_1.setDocumentNumber(document.getDocumentNumber());
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        Date today = new Date(ts.getTime());
        AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
        BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(document.getInvoiceGeneralDetail().getAward(), currPeriod);
        Date invoiceDate = billingPeriod.getEndDate();
        Date completionDate = new Date(new DateTime(invoiceDate.getTime()).minusDays(1).toDate().getTime());
        invMilestone_1.setMilestoneActualCompletionDate(completionDate);
        this.businessObjectService.save((PersistableBusinessObject)invMilestone_1);
        invoiceMilestones.add(invMilestone_1);
        document.setInvoiceMilestones(invoiceMilestones);
        Milestone milestone = new Milestone();
        milestone.setProposalNumber(document.getInvoiceGeneralDetail().getProposalNumber());
        milestone.setMilestoneNumber(invMilestone_1.getMilestoneNumber());
        milestone.setMilestoneIdentifier(invMilestone_1.getMilestoneIdentifier());
        milestone.setMilestoneDescription(invMilestone_1.getMilestoneDescription());
        milestone.setMilestoneAmount(invMilestone_1.getMilestoneAmount());
        milestone.setMilestoneActualCompletionDate(invMilestone_1.getMilestoneActualCompletionDate());
        milestone.setMilestoneExpectedCompletionDate(completionDate);
        milestone.setBilled(false);
        milestone.setAward(document.getInvoiceGeneralDetail().getAward());
        milestone.setActive(true);
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        milestoneSchedule.setProposalNumber(document.getInvoiceGeneralDetail().getProposalNumber());
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(milestone);
        milestoneSchedule.setMilestones(milestones);
        this.businessObjectService.save((PersistableBusinessObject)milestoneSchedule);
        this.businessObjectService.save((PersistableBusinessObject)milestone);
    }

    protected void setupBills(ContractsGrantsInvoiceDocument document) {
        ArrayList<InvoiceBill> invoiceBills = new ArrayList<InvoiceBill>();
        InvoiceBill invBill_1 = InvoiceBillFixture.INV_BILL_2.createInvoiceBill();
        invBill_1.setDocumentNumber(document.getDocumentNumber());
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        Date today = new Date(ts.getTime());
        AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
        BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(document.getInvoiceGeneralDetail().getAward(), currPeriod);
        Date invoiceDate = billingPeriod.getEndDate();
        Date billDate = new Date(new DateTime(invoiceDate.getTime()).minusDays(1).toDate().getTime());
        invBill_1.setBillDate(billDate);
        this.businessObjectService.save((PersistableBusinessObject)invBill_1);
        invoiceBills.add(invBill_1);
        document.setInvoiceBills(invoiceBills);
        Bill bill = new Bill();
        bill.setProposalNumber(document.getInvoiceGeneralDetail().getProposalNumber());
        bill.setBillNumber(invBill_1.getBillNumber());
        bill.setBillDescription(invBill_1.getBillDescription());
        bill.setBillIdentifier(invBill_1.getBillIdentifier());
        bill.setBillDate(invBill_1.getBillDate());
        bill.setEstimatedAmount(invBill_1.getEstimatedAmount());
        bill.setBilled(false);
        bill.setAward(document.getInvoiceGeneralDetail().getAward());
        bill.setActive(true);
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule.setProposalNumber(document.getInvoiceGeneralDetail().getProposalNumber());
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill);
        predeterminedBillingSchedule.setBills(bills);
        this.businessObjectService.save((PersistableBusinessObject)predeterminedBillingSchedule);
        this.businessObjectService.save((PersistableBusinessObject)bill);
    }
}

