/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service;

import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorMessage;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.ARAgencyFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.fixture.ContractsGrantsInvoiceDocumentFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceAccountDetailFixture;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateTestBase;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ContractsGrantsInvoiceCreateDocumentServiceTest
extends ContractsGrantsInvoiceCreateTestBase {
    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testCreateCGInvoiceDocumentByAwardInfo() {
        String coaCode = "BL";
        String orgCode = "UGCS";
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument_1 = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(this.documentService);
        contractsGrantsInvoiceDocument_1.setBillByChartOfAccountCode(coaCode);
        contractsGrantsInvoiceDocument_1.setBilledByOrganizationCode(orgCode);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setDocumentNumber(contractsGrantsInvoiceDocument_1.getDocumentNumber());
        List procCodes = this.contractsGrantsInvoiceDocumentService.getProcessingFromBillingCodes(coaCode, orgCode);
        accountsReceivableDocumentHeader.setProcessingChartOfAccountCode((String)procCodes.get(0));
        accountsReceivableDocumentHeader.setProcessingOrganizationCode((String)procCodes.get(1));
        contractsGrantsInvoiceDocument_1.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_1.createAwardAccount();
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        award.getActiveAwardAccounts().clear();
        award.getActiveAwardAccounts().add(awardAccount_1);
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.setAgencyFromFixture((Award)award);
        contractsGrantsInvoiceDocument_1.getInvoiceGeneralDetail().setAward(award);
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL3.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument_1.setAccountDetails(accountDetails);
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument_2 = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo(award, awardAccounts, coaCode, orgCode, errorMessages, null, null);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)contractsGrantsInvoiceDocument_1.getInvoiceGeneralDetail().getProposalNumber(), (String)contractsGrantsInvoiceDocument_2.getInvoiceGeneralDetail().getProposalNumber());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)((InvoiceAccountDetail)contractsGrantsInvoiceDocument_1.getAccountDetails().get(0)).getAccountNumber(), (String)((InvoiceAccountDetail)contractsGrantsInvoiceDocument_2.getAccountDetails().get(0)).getAccountNumber());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)((InvoiceAccountDetail)contractsGrantsInvoiceDocument_1.getAccountDetails().get(0)).getChartOfAccountsCode(), (String)((InvoiceAccountDetail)contractsGrantsInvoiceDocument_2.getAccountDetails().get(0)).getChartOfAccountsCode());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)contractsGrantsInvoiceDocument_1.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode(), (String)contractsGrantsInvoiceDocument_2.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)contractsGrantsInvoiceDocument_1.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode(), (String)contractsGrantsInvoiceDocument_2.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)contractsGrantsInvoiceDocument_1.getBillByChartOfAccountCode(), (String)contractsGrantsInvoiceDocument_2.getBillByChartOfAccountCode());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)contractsGrantsInvoiceDocument_1.getBilledByOrganizationCode(), (String)contractsGrantsInvoiceDocument_2.getBilledByOrganizationCode());
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByAwardsOneValid() throws Exception {
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.buildMockUniversityDateService());
        List<ContractsAndGrantsBillingAward> awards = this.setupBillableAwards();
        List errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should be empty.", (int)0, (int)errorMessages.size());
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"no errors should be persisted", (int)0, (int)persistedErrors.size());
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
    }

    public void testManualCreateCGInvoiceDocumentsByAwardsEmptyAwardsList() {
        ArrayList awards = new ArrayList();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((contractsGrantsInvoiceDocumentErrorLogs.size() == 0 ? 1 : 0) != 0);
        List errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.award");
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should not be empty.", (errorMessages.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"process type should be manual", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode()));
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    public void testManualCreateCGInvoiceDocumentsByAwardsNullAwardsList() {
        Collection awards = null;
        List errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.award");
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should not be empty.", (errorMessages.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"process type should be manual", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode()));
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    public void testManualCreateCGInvoiceDocumentsByAwardsNoOrg() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setAwardOrganizations(new ArrayList());
        List errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.organization.on.award");
        errorMessage = MessageFormat.format(errorMessage, award.getProposalNumber().toString());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should not be empty.", (errorMessages.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"process type should be manual", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode()));
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByAccountNonBillable() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        List<ErrorMessage> errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwards();
        Award award2 = (Award)awards2.get(0);
        award2.setInvoicingOptionCode("2");
        errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, ((ContractsAndGrantsBillingAwardAccount)award2.getActiveAwardAccounts().get(0)).getAccountNumber(), award.getProposalNumber().toString());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should not be empty.", (errorMessages.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"process type should be manual", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode()));
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByAccountOneBillableOneNonBillable() throws Exception {
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.buildMockUniversityDateService());
        List<ContractsAndGrantsBillingAward> awards = this.setupBillableAwards();
        Award award = (Award)awards.get(0);
        award.setInvoicingOptionCode("2");
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        awardAccount_2.setCurrentLastBilledDate(new Date(System.currentTimeMillis()));
        awardAccount_2.refreshReferenceObject("account");
        award.getAwardAccounts().add(awardAccount_2);
        List errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, awardAccount_2.getAccountNumber(), award.getProposalNumber().toString());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should contain one message", (int)1, (int)errorMessages.size());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"process type should be manual", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode()));
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByCCAContractAccountNotBillable() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        List<ErrorMessage> errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwards();
        Award award2 = (Award)awards2.get(0);
        award2.setInvoicingOptionCode("3");
        errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.control.account.non.billable");
        errorMessage = MessageFormat.format(errorMessage, ((ContractsAndGrantsBillingAwardAccount)award2.getActiveAwardAccounts().get(0)).getAccount().getContractControlAccount().getAccountNumber(), award.getProposalNumber().toString());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should not be empty.", (errorMessages.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"process type should be manual", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode()));
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByAwardNotAllBillableAccounts() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwards();
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        List<ErrorMessage> errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo((ContractsAndGrantsBillingAward)award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwards();
        Award award2 = (Award)awards2.get(0);
        award2.setInvoicingOptionCode("1");
        errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.not.all.billable.accounts");
        errorMessage = MessageFormat.format(errorMessage, award2.getProposalNumber().toString());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should not be empty.", (errorMessages.size() == 1 ? 1 : 0) != 0);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"one error should be persisted", (persistedErrors.size() == 1 ? 1 : 0) != 0);
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"process type should be manual", (boolean)persistedError.getCreationProcessTypeCode().equals(ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode()));
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"error message text should match", (boolean)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText().equals(errorMessage));
        }
    }

    private boolean messagesContainsExpectedError(List<ErrorMessage> errorMessages, String expectedErrorMessage) {
        ErrorMessage errorMessage = errorMessages.get(0);
        String errorMessageString = MessageFormat.format(this.configurationService.getPropertyValueAsString(errorMessage.getErrorKey()), errorMessage.getMessageParameters());
        return StringUtils.equals((String)errorMessageString, (String)expectedErrorMessage);
    }

    private boolean errorLogContainsAward(Collection<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs, ContractsAndGrantsBillingAward award) {
        for (ContractsGrantsInvoiceDocumentErrorLog contractsGrantsInvoiceDocumentErrorLog : contractsGrantsInvoiceDocumentErrorLogs) {
            if (!contractsGrantsInvoiceDocumentErrorLog.getProposalNumber().equals(award.getProposalNumber())) continue;
            return true;
        }
        return false;
    }
}

