/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.document.CGInvoiceDocumentTestBase;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.wklykins)
public class FinalInvoiceTest
extends CGInvoiceDocumentTestBase {
    WorkflowDocumentService workflowDocumentService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.workflowDocumentService = (WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class);
    }

    public void testInvoiceOnFinal() throws WorkflowException {
        FinalInvoiceTest.assertTrue((boolean)this.document.getDocumentHeader().getWorkflowDocument().isInitiated());
        this.documentService.saveDocument((Document)this.document);
        String documentNumber = this.document.getDocumentNumber();
        String proposalNumber = this.document.getInvoiceGeneralDetail().getProposalNumber();
        this.setupMilestones(documentNumber, proposalNumber, false);
        this.setupBills(documentNumber, proposalNumber, false);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proposalNumber", proposalNumber);
        ((ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class)).updateBillsAndMilestones(true, this.document.getInvoiceMilestones(), this.document.getInvoiceBills());
        List updatedMilestones = (List)this.boService.findMatching(Milestone.class, map);
        FinalInvoiceTest.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)updatedMilestones));
        if (CollectionUtils.isNotEmpty((Collection)updatedMilestones)) {
            Iterator iterator = updatedMilestones.iterator();
            while (iterator.hasNext()) {
                FinalInvoiceTest.assertTrue((boolean)((Milestone)iterator.next()).isBilled());
            }
        }
        List updatedBills = (List)this.boService.findMatching(Bill.class, map);
        FinalInvoiceTest.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)updatedBills));
        if (CollectionUtils.isNotEmpty((Collection)updatedBills)) {
            Iterator iterator = updatedBills.iterator();
            while (iterator.hasNext()) {
                FinalInvoiceTest.assertTrue((boolean)((Bill)iterator.next()).isBilled());
            }
        }
    }

    public void testMultipleInvoices() {
        this.document.getInvoiceGeneralDetail().setFinalBillIndicator(true);
        FinalInvoiceTest.assertTrue((boolean)this.document.getDocumentHeader().getWorkflowDocument().isInitiated());
        ((ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class)).updateLastBilledDate(this.document);
        for (InvoiceAccountDetail id : this.document.getAccountDetails()) {
            HashMap<String, String> mapKey = new HashMap<String, String>();
            mapKey.put("accountNumber", id.getAccountNumber());
            mapKey.put("chartOfAccountsCode", id.getChartOfAccountsCode());
            mapKey.put("proposalNumber", this.document.getInvoiceGeneralDetail().getProposalNumber());
            ContractsAndGrantsBillingAwardAccount awardAccount = (ContractsAndGrantsBillingAwardAccount)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAwardAccount.class, mapKey);
            FinalInvoiceTest.assertTrue((boolean)awardAccount.isFinalBilledIndicator());
        }
    }

    private void route() throws Exception {
        AccountingDocumentTestUtils.testRouteDocument((FinancialSystemTransactionalDocument)this.document, (DocumentService)this.documentService);
        this.documentService.prepareWorkflowDocument((Document)this.document);
        this.documentService.superUserApproveDocument((Document)this.document, "");
        this.documentService.routeDocument((Document)this.document, "routing test doc", new Vector());
        this.workflowDocumentService.route(this.document.getDocumentHeader().getWorkflowDocument(), "", null);
    }
}

