/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.Date;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.authorization.ContractsGrantsInvoiceDocumentPresentationController;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.UniversityDateService;

public class ContractsGrantsInvoiceDocumentPresentationControllerTest {
    @Test
    public void testCannotCorrectAlreadyCorrectedDocument() throws Exception {
        ContractsGrantsInvoiceDocumentPresentationController presentationController = this.getContractsGrantsInvoiceDocumentPresentationController(true);
        this.validateCanErrorCorrect(presentationController, null, "hi there, i am testing", false, false);
    }

    @Test
    public void testCannotCorrectReversedInvoice() throws Exception {
        ContractsGrantsInvoiceDocumentPresentationController presentationController = this.getContractsGrantsInvoiceDocumentPresentationController(true);
        this.validateCanErrorCorrect(presentationController, null, "", true, false);
    }

    @Test
    public void testCannotCorrectNonFinalDocument() throws Exception {
        ContractsGrantsInvoiceDocumentPresentationController presentationController = this.getContractsGrantsInvoiceDocumentPresentationController(false);
        this.validateCanErrorCorrect(presentationController, null, "", false, false);
    }

    @Test
    public void testCanCorrectFinalDocumentWithAppliedInvoices() throws Exception {
        ContractsGrantsInvoiceDocumentPresentationController presentationController = this.getContractsGrantsInvoiceDocumentPresentationController(true);
        this.validateCanErrorCorrect(presentationController, null, "", false, true);
    }

    @Test
    public void testCanCorrectFinalDocumentWithAppliedInvoicesNullDate() throws Exception {
        ContractsGrantsInvoiceDocumentPresentationController presentationController = this.getContractsGrantsInvoiceDocumentPresentationController(true);
        this.validateCanErrorCorrect(presentationController, null, "", false, true);
    }

    @Test
    public void testCannotCorrectPriorYearInvoice() {
        ContractsGrantsInvoiceDocumentPresentationController presentationController = this.getContractsGrantsInvoiceDocumentPresentationController(true);
        this.validateCanErrorCorrect(presentationController, "2014-06-25", "", false, false);
    }

    @Test
    public void testCanCorrectEarlierPriorYearInvoice() {
        ContractsGrantsInvoiceDocumentPresentationController presentationController = this.getContractsGrantsInvoiceDocumentPresentationController(true);
        this.validateCanErrorCorrect(presentationController, "2014-07-01", "", false, true);
    }

    private ContractsGrantsInvoiceDocumentPresentationController getContractsGrantsInvoiceDocumentPresentationController(final boolean docFinalNoAppliedAmounts) {
        ContractsGrantsInvoiceDocumentPresentationController contractsGrantsInvoiceDocumentPresentationController = new ContractsGrantsInvoiceDocumentPresentationController(){

            protected boolean isDocFinalWithNoAppliedAmountsExceptDiscounts(CustomerInvoiceDocument document) {
                return docFinalNoAppliedAmounts;
            }
        };
        FiscalYear2015UniversityDateService fakeUniversityDateService = new FiscalYear2015UniversityDateService();
        contractsGrantsInvoiceDocumentPresentationController.setUniversityDateService((UniversityDateService)fakeUniversityDateService);
        return contractsGrantsInvoiceDocumentPresentationController;
    }

    private void validateCanErrorCorrect(ContractsGrantsInvoiceDocumentPresentationController presentationController, String dateApprovedString, String correctedByDocumentId, boolean invoiceReversal, boolean expectedResult) {
        FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();
        documentHeader.setCorrectedByDocumentId(correctedByDocumentId);
        DateTime dateApproved = null;
        if (dateApprovedString != null) {
            dateApproved = new DateTime((Object)java.sql.Date.valueOf(dateApprovedString));
        }
        Assert.assertEquals((String)"canErrorCorrect returned unexpected value ", (Object)expectedResult, (Object)presentationController.canErrorCorrect(null, documentHeader, invoiceReversal, dateApproved));
    }

    private class FiscalYear2015UniversityDateService
    implements UniversityDateService {
        private FiscalYear2015UniversityDateService() {
        }

        public UniversityDate getCurrentUniversityDate() {
            UniversityDate universityDate = new UniversityDate();
            universityDate.setUniversityDate(java.sql.Date.valueOf("2014-07-02"));
            return universityDate;
        }

        public Integer getFiscalYear(Date date) {
            return 2015;
        }

        public Date getFirstDateOfFiscalYear(Integer fiscalYear) {
            return java.sql.Date.valueOf("2014-07-01");
        }

        public Date getLastDateOfFiscalYear(Integer fiscalYear) {
            return java.sql.Date.valueOf("2015-06-30");
        }

        public Integer getCurrentFiscalYear() {
            return 2015;
        }
    }
}

