/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.fp.document.GeneralErrorCorrectionDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.CashControlDocumentService;
import org.kuali.kfs.module.ar.document.validation.impl.CashControlDocumentRule;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CashControlDocumentRuleTest
extends KualiTestBase {
    protected CashControlDocumentRule rule;
    protected CashControlDocument document;
    protected DocumentService documentService;
    protected CashControlDocumentService cashControlDocumentService;
    protected AccountsReceivableDocumentHeaderService arDocHeaderService;
    protected PaymentApplicationDocument appDoc;
    protected static final KualiDecimal ZERO_AMOUNT = KualiDecimal.ZERO;
    protected static final KualiDecimal NEGATIVE_AMOUNT = new KualiDecimal(-1);
    protected static final KualiDecimal POSITIVE_AMOUNT = new KualiDecimal(2);
    protected static final String CUSTOMER_PAYMENT_MEDIUM_NOT_VALID_CODE = "MEH";
    protected static final String REFERENCE_DOCUMENT_NUMBER = "123456";

    protected void setUp() throws Exception {
        super.setUp();
        this.rule = new CashControlDocumentRule();
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.cashControlDocumentService = (CashControlDocumentService)SpringContext.getBean(CashControlDocumentService.class);
        this.arDocHeaderService = (AccountsReceivableDocumentHeaderService)SpringContext.getBean(AccountsReceivableDocumentHeaderService.class);
        this.document = this.createCashControlDocument();
    }

    protected void tearDown() throws Exception {
        this.rule = null;
        this.document = null;
        this.documentService = null;
        this.cashControlDocumentService = null;
        super.tearDown();
    }

    protected CashControlDocument createCashControlDocument() throws WorkflowException {
        CashControlDocument doc = (CashControlDocument)this.documentService.getNewDocument(CashControlDocument.class);
        doc.getDocumentHeader().setDocumentDescription("This is a test document.");
        doc.setCustomerPaymentMediumCode("CK");
        AccountsReceivableDocumentHeader arDocHeader = this.arDocHeaderService.getNewAccountsReceivableDocumentHeaderForCurrentUser();
        arDocHeader.setDocumentNumber(doc.getDocumentNumber());
        doc.setAccountsReceivableDocumentHeader(arDocHeader);
        try {
            this.documentService.saveDocument((Document)doc);
        }
        catch (ValidationException ex) {
            CashControlDocumentRuleTest.fail((String)("Unable to save document - failed validation: \n" + this.dumpMessageMapErrors() + "\nDocument: " + doc));
        }
        return doc;
    }

    public void testValidateCashControlDetails_True() {
        CashControlDetail detail1 = new CashControlDetail();
        detail1.setFinancialDocumentLineAmount(POSITIVE_AMOUNT);
        this.document.addCashControlDetail(detail1);
        CashControlDocumentRuleTest.assertTrue((String)("Document should have passed validation. " + GlobalVariables.getMessageMap()), (boolean)this.rule.validateCashControlDetails(this.document));
    }

    public void testValidateCashControlDetails_Negative_False() {
        CashControlDetail detail1 = new CashControlDetail();
        detail1.setFinancialDocumentLineAmount(NEGATIVE_AMOUNT);
        this.document.addCashControlDetail(detail1);
        CashControlDocumentRuleTest.assertFalse((String)"Document should have failed validation", (boolean)this.rule.validateCashControlDetails(this.document));
    }

    public void testValidateCashControlDetails_Zero_Amount_False() {
        CashControlDetail detail1 = new CashControlDetail();
        detail1.setFinancialDocumentLineAmount(ZERO_AMOUNT);
        this.document.addCashControlDetail(detail1);
        CashControlDocumentRuleTest.assertFalse((boolean)this.rule.validateCashControlDetails(this.document));
    }

    public void testCheckGLPEsCreated_True() throws WorkflowException {
        Document tempDocument = DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), GeneralErrorCorrectionDocument.class);
        GeneralLedgerPendingEntry tempEntry = new GeneralLedgerPendingEntry();
        this.documentService.saveDocument(tempDocument);
        this.document.getGeneralLedgerPendingEntries().add(tempEntry);
        CashControlDocumentRuleTest.assertTrue((String)("GLPE's should have been created: " + this.dumpMessageMapErrors()), (boolean)this.rule.checkGLPEsCreated(this.document));
    }

    public void testCheckGLPEsCreated_False() {
        this.document.setGeneralLedgerPendingEntries(null);
        CashControlDocumentRuleTest.assertFalse((String)"GLPE's should not have been created", (boolean)this.rule.checkGLPEsCreated(this.document));
    }

    public void testCheckPaymentMedium_True() {
        this.document.setCustomerPaymentMediumCode("CA");
        CashControlDocumentRuleTest.assertTrue((String)("Business Rules should not have failed: " + this.dumpMessageMapErrors()), (boolean)this.rule.checkPaymentMedium(this.document));
    }

    public void testCheckPaymentMedium_NotValid_False() {
        this.document.setCustomerPaymentMediumCode(CUSTOMER_PAYMENT_MEDIUM_NOT_VALID_CODE);
        CashControlDocumentRuleTest.assertFalse((boolean)this.rule.checkPaymentMedium(this.document));
    }

    public void testCheckPaymentMedium_Null_False() {
        this.document.setCustomerPaymentMediumCode(null);
        CashControlDocumentRuleTest.assertFalse((boolean)this.rule.checkPaymentMedium(this.document));
    }

    public void testCheckRefDocNumber_True() throws WorkflowException {
        GeneralErrorCorrectionDocument tempDoc = (GeneralErrorCorrectionDocument)DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), GeneralErrorCorrectionDocument.class);
        this.documentService.saveDocument((Document)tempDoc);
        this.document.setCustomerPaymentMediumCode("CA");
        this.document.setReferenceFinancialDocumentNumber(tempDoc.getDocumentNumber());
        CashControlDocumentRuleTest.assertTrue((String)("Business Rules should not have failed: " + this.dumpMessageMapErrors()), (boolean)this.rule.checkRefDocNumber(this.document));
    }

    public void testCheckRefDocNumber_False() {
        this.document.setCustomerPaymentMediumCode("CA");
        this.document.setReferenceFinancialDocumentNumber(null);
        CashControlDocumentRuleTest.assertFalse((boolean)this.rule.checkRefDocNumber(this.document));
    }

    public void testCheckGLPEsNotGenerated_True() {
        this.document.setGeneralLedgerPendingEntries(null);
        CashControlDocumentRuleTest.assertTrue((String)("Business Rules should not have failed: " + this.dumpMessageMapErrors()), (boolean)this.rule.checkGLPEsNotGenerated(this.document));
    }

    public void testCheckGLPEsNotGenerated_False() {
        GeneralLedgerPendingEntry tempEntry = new GeneralLedgerPendingEntry();
        this.document.getGeneralLedgerPendingEntries().add(tempEntry);
        CashControlDocumentRuleTest.assertFalse((boolean)this.rule.checkGLPEsNotGenerated(this.document));
    }
}

