/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceCustomerAddressValidation;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerInvoiceCustomerAddressValidationTest
extends KualiTestBase {
    private CustomerInvoiceCustomerAddressValidation validation;
    private static final String VALID_CUSTOMER_NUMBER = "ABB2";
    private static final Integer VALID_ADDRESS_IDENTIFIER = new Integer(1);
    private static final Integer INVALID_ADDRESS_IDENTIFIER = new Integer(99);

    protected void setUp() throws Exception {
        super.setUp();
        this.validation = new CustomerInvoiceCustomerAddressValidation();
        this.validation.setCustomerInvoiceDocument(new CustomerInvoiceDocument());
        this.validation.getCustomerInvoiceDocument().setAccountsReceivableDocumentHeader(new AccountsReceivableDocumentHeader());
        this.validation.setCustomerAddressService((CustomerAddressService)SpringContext.getBean(CustomerAddressService.class));
    }

    protected void tearDown() throws Exception {
        this.validation = null;
        super.tearDown();
    }

    public void testIsValidBillToAddress_True() {
        this.validation.getCustomerInvoiceDocument().getAccountsReceivableDocumentHeader().setCustomerNumber(VALID_CUSTOMER_NUMBER);
        this.validation.getCustomerInvoiceDocument().setCustomerBillToAddressIdentifier(VALID_ADDRESS_IDENTIFIER);
        CustomerInvoiceCustomerAddressValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testIsValidBillToAddress_False() {
        this.validation.getCustomerInvoiceDocument().getAccountsReceivableDocumentHeader().setCustomerNumber(VALID_CUSTOMER_NUMBER);
        this.validation.getCustomerInvoiceDocument().setCustomerBillToAddressIdentifier(INVALID_ADDRESS_IDENTIFIER);
        CustomerInvoiceCustomerAddressValidationTest.assertFalse((boolean)this.validation.validate(null));
    }

    public void testIsValidShipToAddress_True() {
        this.validation.getCustomerInvoiceDocument().getAccountsReceivableDocumentHeader().setCustomerNumber(VALID_CUSTOMER_NUMBER);
        this.validation.getCustomerInvoiceDocument().setCustomerShipToAddressIdentifier(VALID_ADDRESS_IDENTIFIER);
        CustomerInvoiceCustomerAddressValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testIsValidShipToAddress_False() {
        this.validation.getCustomerInvoiceDocument().getAccountsReceivableDocumentHeader().setCustomerNumber(VALID_CUSTOMER_NUMBER);
        this.validation.getCustomerInvoiceDocument().setCustomerShipToAddressIdentifier(INVALID_ADDRESS_IDENTIFIER);
        CustomerInvoiceCustomerAddressValidationTest.assertFalse((boolean)this.validation.validate(null));
    }
}

