/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailSystemInformationDiscountValidation;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerInvoiceDetailSystemInformationDiscountValidationTest
extends KualiTestBase {
    private CustomerInvoiceDetailSystemInformationDiscountValidation validation;
    public static final String PROCESSING_CHART_OF_ACCOUNTS = "UA";
    public static final String PROCESSING_ORGANIZATION_CODE = "ARCG";
    private static final String DISCOUNT_OBJECT_CODE = "1999";

    protected void setUp() throws Exception {
        super.setUp();
        this.validation = new CustomerInvoiceDetailSystemInformationDiscountValidation();
        this.validation.setUniversityDateService((UniversityDateService)SpringContext.getBean(UniversityDateService.class));
        this.validation.setBusinessObjectService((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class));
        SystemInformation systemInformation = new SystemInformation();
        systemInformation.setProcessingChartOfAccountCode(PROCESSING_CHART_OF_ACCOUNTS);
        systemInformation.setProcessingOrganizationCode(PROCESSING_ORGANIZATION_CODE);
        systemInformation.setDiscountObjectCode(DISCOUNT_OBJECT_CODE);
        systemInformation.setUniversityFiscalYear(this.validation.getUniversityDateService().getCurrentFiscalYear());
        this.validation.getBusinessObjectService().save((PersistableBusinessObject)systemInformation);
        CustomerInvoiceDocument customerInvoiceDocument = new CustomerInvoiceDocument();
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setProcessingChartOfAccountCode(PROCESSING_CHART_OF_ACCOUNTS);
        customerInvoiceDocument.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
    }

    protected void tearDown() throws Exception {
        this.validation = null;
        super.tearDown();
    }

    public void testSystemInformationWithDiscount_True() {
        this.validation.getCustomerInvoiceDocument().getAccountsReceivableDocumentHeader().setProcessingOrganizationCode(PROCESSING_ORGANIZATION_CODE);
        CustomerInvoiceDetailSystemInformationDiscountValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testSystemInformationWithDiscount_False() {
        CustomerInvoiceDetailSystemInformationDiscountValidationTest.assertFalse((boolean)this.validation.validate(null));
    }
}

