/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentService;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.easymock.EasyMock;
import org.joda.time.DateTimeUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFundManagerFixture;
import org.kuali.kfs.module.ar.fixture.BillingFrequencyFixture;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PerformValidationTest {
    private ContractsGrantsInvoiceCreateDocumentServiceImpl contractsGrantsInvoiceCreateDocumentService;
    private ContractsGrantsBillingAwardVerificationService contractsGrantsBillingAwardVerificationService;
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    private VerifyBillingFrequencyService verifyBillingFrequencyService;
    private FinancialSystemDocumentService financialSystemDocumentService;
    private BusinessObjectService businessObjectService;
    private ConfigurationService configurationService;
    private OptionsService optionsService;
    private DateTimeService dateTimeService;
    private AccountService accountService;
    private Set<String> pendingDocumentStatuses = new HashSet<String>(Arrays.asList("I", "S", "R", "E"));
    private Set<ContractsAndGrantsBillingAward> awardsInError;
    private boolean validBillingFrequency;
    private boolean correctBillingFrequency;
    private boolean alreadyBuilt;
    private boolean hasMilestones;
    private boolean validBills;
    private boolean customerRecord;
    private boolean chartOrgSetUp;
    private boolean invoiceInProgress;
    private List<String> ccaErrors;
    private List<ContractsGrantsInvoiceDocument> pendingDocuments;
    private Collection<Account> expiredAccounts;

    @Before
    public void setup() {
        this.contractsGrantsInvoiceCreateDocumentService = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.contractsGrantsBillingAwardVerificationService = (ContractsGrantsBillingAwardVerificationService)EasyMock.createMock(ContractsGrantsBillingAwardVerificationService.class);
        this.contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)EasyMock.createMock(ContractsGrantsInvoiceDocumentService.class);
        this.verifyBillingFrequencyService = (VerifyBillingFrequencyService)EasyMock.createMock(VerifyBillingFrequencyService.class);
        this.financialSystemDocumentService = (FinancialSystemDocumentService)EasyMock.createMock(FinancialSystemDocumentService.class);
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.configurationService = (ConfigurationService)EasyMock.createMock(ConfigurationService.class);
        this.optionsService = (OptionsService)EasyMock.createMock(OptionsService.class);
        this.dateTimeService = (DateTimeService)EasyMock.createMock(DateTimeService.class);
        this.accountService = (AccountService)EasyMock.createMock(AccountService.class);
        this.contractsGrantsInvoiceCreateDocumentService.setContractsGrantsBillingAwardVerificationService(this.contractsGrantsBillingAwardVerificationService);
        this.contractsGrantsInvoiceCreateDocumentService.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentService);
        this.contractsGrantsInvoiceCreateDocumentService.setVerifyBillingFrequencyService(this.verifyBillingFrequencyService);
        this.contractsGrantsInvoiceCreateDocumentService.setFinancialSystemDocumentService(this.financialSystemDocumentService);
        this.contractsGrantsInvoiceCreateDocumentService.setBusinessObjectService(this.businessObjectService);
        this.contractsGrantsInvoiceCreateDocumentService.setConfigurationService(this.configurationService);
        this.contractsGrantsInvoiceCreateDocumentService.setOptionsService(this.optionsService);
        this.contractsGrantsInvoiceCreateDocumentService.setDateTimeService(this.dateTimeService);
        this.contractsGrantsInvoiceCreateDocumentService.setAccountService(this.accountService);
        this.validBillingFrequency = true;
        this.correctBillingFrequency = true;
        this.alreadyBuilt = false;
        this.hasMilestones = true;
        this.expiredAccounts = null;
        this.validBills = true;
        this.customerRecord = true;
        this.chartOrgSetUp = true;
        this.invoiceInProgress = false;
        this.ccaErrors = new ArrayList<String>();
        this.pendingDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        this.awardsInError = new HashSet<ContractsAndGrantsBillingAward>();
    }

    @Test
    public void testPerformAwardValidationStartDateMissing() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        ((Award)award).setAwardBeginningDate(null);
        awards.add(award);
        this.prepareOtherMocks();
        this.expectError(award, "error.cginvoice.award.startDate.missing");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvalidBillingFrequency() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        awards.add(award);
        this.prepareOtherMocks();
        this.expectError(award, "error.cginvoice.billing.missing.frequency");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvalidBillingPeriod() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_INVALID_DATES.createAward();
        ((Award)award).setAwardBeginningDate(new Date(DateTimeUtils.currentTimeMillis()));
        awards.add(award);
        this.validBillingFrequency = false;
        this.prepareMocks(award);
        this.prepareOtherMocks();
        this.expectError(award, "error.cginvoice.award.not.eligible.invoice");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationValidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should  contain one award.", (qualifiedAwards.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"qualifiedAwards should contain our initial award.", (boolean)((List)qualifiedAwards).get(0).equals(awards.get(0)));
    }

    @Test
    public void testPerformAwardValidationAwardInvoicingSuspended() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setExcludedFromInvoicing(true);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.excluded.from.invoicing");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInactiveAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setActive(false);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.inactive");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationSuspendedAndInactiveAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setActive(false);
        ((Award)awards.get(0)).setExcludedFromInvoicing(true);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.excluded.from.invoicing");
        this.expectError(awards.get(0), "error.cginvoice.award.inactive");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationTwoInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2);
        ((Award)awards.get(0)).setActive(false);
        ((Award)awards2.get(0)).setExcludedFromInvoicing(true);
        awards.addAll(awards2);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.excluded.from.invoicing");
        this.expectError(awards.get(1), "error.cginvoice.award.inactive");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationOneValidOneInvalidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2);
        ((Award)awards2.get(0)).setExcludedFromInvoicing(true);
        awards.addAll(awards2);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(1), "error.cginvoice.award.excluded.from.invoicing");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertEquals((String)"qualifiedAwards should contain one award.", (long)1L, (long)qualifiedAwards.size());
        Assert.assertTrue((String)"qualifiedAwards should contain our initial award.", (boolean)((List)qualifiedAwards).get(0).equals(awards.get(0)));
    }

    @Test
    public void testPerformAwardValidationMissingAwardInvoicingOption() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setInvoicingOptionCode(null);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.missing");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvalidPredeterminedBillingFrequency() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        award.setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        award.getAwardAccounts().add(awardAccount_2);
        this.correctBillingFrequency = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError((ContractsAndGrantsBillingAward)award, "error.cginvoice.award.single.account");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvalidMilestoneBillingFrequency() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        award.setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        award.getAwardAccounts().add(awardAccount_2);
        this.correctBillingFrequency = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError((ContractsAndGrantsBillingAward)award, "error.cginvoice.award.single.account");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoActiveAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).getAwardAccounts().clear();
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.no.active.accounts.assigned");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationExpiredAccount() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.expiredAccounts = new ArrayList<Account>();
        this.expiredAccounts.add(new Account());
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.contain.expired.account");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationAwardFinalInvoiceAlreadyBilled() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.alreadyBuilt = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.already.billed");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoValidMilestonesToInvoice() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.hasMilestones = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.not.valid.milestones");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoValidBillsToInvoice() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ((Award)awards.get(0)).setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        this.validBills = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.not.valid.bills");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationOneValidOneInvalidAwardAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        awardAccount_2.setCurrentLastBilledDate(new Date(System.currentTimeMillis()));
        ((Award)awards.get(0)).getAwardAccounts().add(awardAccount_2);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should contain one award.", (qualifiedAwards.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationAgencyHasNoMatchingCustomer() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.customerRecord = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.not.valid.customer");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoValidAwardAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ContractsGrantsInvoiceDocument document = (ContractsGrantsInvoiceDocument)EasyMock.createMock(ContractsGrantsInvoiceDocument.class);
        InvoiceAccountDetail detail = new InvoiceAccountDetail();
        ContractsAndGrantsBillingAwardAccount awardAccount = (ContractsAndGrantsBillingAwardAccount)awards.get(0).getActiveAwardAccounts().get(0);
        detail.setAccountNumber(awardAccount.getAccountNumber());
        detail.setChartOfAccountsCode(awardAccount.getChartOfAccountsCode());
        EasyMock.expect((Object)document.getAccountDetails()).andReturn(Arrays.asList(detail));
        EasyMock.expect((Object)this.accountService.getByPrimaryId(awardAccount.getChartOfAccountsCode(), awardAccount.getAccountNumber())).andReturn((Object)awardAccount.getAccount());
        EasyMock.replay((Object[])new Object[]{document});
        this.pendingDocuments.add(document);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cgivoice.award.not.valid.accounts");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoContractControlAccountsByCCA() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.ccaErrors.add("error.cg.no.control.account");
        this.ccaErrors.add("");
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cg.no.control.account");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoSysInfo() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.chartOrgSetUp = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.sys.info.not.setup");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvoicesInProgressMilestone() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.invoiceInProgress = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cgivoice.award.not.valid.accounts");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvoicesInProgressPredeterminedBilling() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        award.setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        this.invoiceInProgress = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cgivoice.award.not.valid.accounts");
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    private void expectError(ContractsAndGrantsBillingAward award, String errorKey) {
        EasyMock.expect((Object)this.configurationService.getPropertyValueAsString(errorKey)).andReturn((Object)"Error");
        if (!this.awardsInError.contains(award)) {
            this.awardsInError.add(award);
            for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                EasyMock.expect((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null, (java.util.Date)award.getAwardBeginningDate())).andReturn((Object)KualiDecimal.ZERO);
            }
            EasyMock.expect((Object)this.dateTimeService.getCurrentTimestamp()).andReturn(null);
            EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)EasyMock.isA(ContractsGrantsInvoiceDocumentErrorLog.class))).andReturn(null);
        }
    }

    private List<ContractsAndGrantsBillingAward> setupAward(ARAwardAccountFixture awardAccountFixture) {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.createAward();
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAgencyFromFixture((Award)award);
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = awardAccountFixture.createAwardAccount();
        Account account = new Account();
        awardAccount_1.setAccount(account);
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        ((Award)award).setAwardAccounts(awardAccounts);
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAwardOrganizationFromFixture((Award)award);
        AwardFundManager awardFundManager = ARAwardFundManagerFixture.AWD_FND_MGR1.createAwardFundManager();
        ((Award)award).getAwardFundManagers().add(awardFundManager);
        ((Award)award).setAwardPrimaryFundManager(ARAwardFundManagerFixture.AWD_FND_MGR1.createAwardFundManager());
        awards.add(award);
        return awards;
    }

    private void prepareMocks(List<ContractsAndGrantsBillingAward> awards) {
        for (ContractsAndGrantsBillingAward award : awards) {
            this.prepareMocks(award);
        }
    }

    private void prepareMocks(ContractsAndGrantsBillingAward award) {
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(award)).andReturn((Object)true);
        EasyMock.expect((Object)this.verifyBillingFrequencyService.validateBillingFrequency(award)).andReturn((Object)this.validBillingFrequency);
        if (!this.validBillingFrequency) {
            return;
        }
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.isBillingFrequencySetCorrectly(award)).andReturn((Object)this.correctBillingFrequency);
        EasyMock.expect((Object)this.contractsGrantsInvoiceDocumentService.getExpiredAccountsOfAward(award)).andReturn(this.expiredAccounts);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.isAwardFinalInvoiceAlreadyBuilt(award)).andReturn((Object)this.alreadyBuilt);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.hasMilestonesToInvoice(award)).andReturn((Object)this.hasMilestones);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.hasBillsToInvoice(award)).andReturn((Object)this.validBills);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(award)).andReturn((Object)this.customerRecord);
        EasyMock.expect((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(award)).andReturn(this.ccaErrors);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(award)).andReturn((Object)this.chartOrgSetUp);
        if (ArConstants.BillingFrequencyValues.isMilestone((ContractsAndGrantsBillingAward)award) || ArConstants.BillingFrequencyValues.isPredeterminedBilling((ContractsAndGrantsBillingAward)award)) {
            EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.isInvoiceInProgress(award)).andReturn((Object)this.invoiceInProgress);
        } else if (award.getActiveAwardAccounts().size() > 0) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
            fieldValues.put("documentHeader.workflowDocumentStatusCode", this.pendingDocumentStatuses);
            EasyMock.expect((Object)this.businessObjectService.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).andReturn(this.pendingDocuments);
            if (this.pendingDocuments.isEmpty()) {
                for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                    EasyMock.expect((Object)this.verifyBillingFrequencyService.validateBillingFrequency(award, awardAccount)).andReturn((Object)true);
                }
            }
        }
    }

    private void prepareOtherMocks() {
        EasyMock.expect((Object)this.optionsService.getCurrentYearOptions()).andReturn((Object)new SystemOptions()).anyTimes();
        EasyMock.expect((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).andReturn(this.pendingDocumentStatuses).anyTimes();
        EasyMock.expect((Object)this.configurationService.getPropertyValueAsBoolean("module.external.kuali.coeus.enabled")).andReturn((Object)false).anyTimes();
    }

    private void replayMocks() {
        EasyMock.replay((Object[])new Object[]{this.contractsGrantsBillingAwardVerificationService, this.contractsGrantsInvoiceDocumentService, this.verifyBillingFrequencyService, this.financialSystemDocumentService, this.businessObjectService, this.configurationService, this.optionsService, this.dateTimeService, this.accountService});
    }

    private void verifyMocks() {
        EasyMock.verify((Object[])new Object[]{this.contractsGrantsBillingAwardVerificationService, this.contractsGrantsInvoiceDocumentService, this.verifyBillingFrequencyService, this.financialSystemDocumentService, this.businessObjectService, this.configurationService, this.optionsService, this.dateTimeService, this.accountService});
    }
}

