/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsAgingOpenInvoicesReportService;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.wklykins)
public class ContractsGrantsAgingOpenInvoicesReportServiceTest
extends KualiTestBase {
    private static final String CUSTOMER_NUMBER = "ABB2";
    private static final String CUSTOMER_NAME = "WOODS CORPORATION";
    ContractsGrantsAgingOpenInvoicesReportService contractsGrantsAgingOpenInvoicesReportService;

    public void setUp() throws Exception {
        super.setUp();
        String chartCode = "BL";
        String orgCode = "UGCS";
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAward();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_1.createAwardAccount();
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        award.getActiveAwardAccounts().clear();
        award.getActiveAwardAccounts().add(awardAccount_1);
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.setAgencyFromFixture((Award)award);
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = ((ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class)).createCGInvoiceDocumentByAwardInfo(award, awardAccounts, chartCode, orgCode, errorMessages, null, null);
        FinancialSystemDocumentHeader documentHeader = cgInvoice.getFinancialSystemDocumentHeader();
        cgInvoice.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("A");
        cgInvoice.getAccountsReceivableDocumentHeader().setCustomerNumber(CUSTOMER_NUMBER);
        cgInvoice.getAccountsReceivableDocumentHeader().setDocumentHeader(documentHeader);
        cgInvoice.setBillingDate(new Date(new java.util.Date().getTime()));
        cgInvoice.getInvoiceGeneralDetail().setAward(award);
        cgInvoice.setOpenInvoiceIndicator(true);
        cgInvoice.setCustomerName(CUSTOMER_NAME);
        for (InvoiceAddressDetail invoiceAddressDetail : cgInvoice.getInvoiceAddressDetails()) {
            invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
            invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        }
        documentService.saveDocument((Document)cgInvoice);
        this.contractsGrantsAgingOpenInvoicesReportService = (ContractsGrantsAgingOpenInvoicesReportService)SpringContext.getBean(ContractsGrantsAgingOpenInvoicesReportService.class);
    }

    public void testGetPopulatedReportDetails() {
        HashMap<String, String[]> urlParameters = new HashMap<String, String[]>();
        urlParameters.put("customerNumber", new String[]{CUSTOMER_NUMBER});
        urlParameters.put("customerName", new String[]{CUSTOMER_NAME});
        List openinvoicesList = this.contractsGrantsAgingOpenInvoicesReportService.getPopulatedReportDetails(urlParameters);
        ContractsGrantsAgingOpenInvoicesReportServiceTest.assertNotNull((Object)openinvoicesList);
    }
}

