/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsBillingAwardVerificationServiceImpl;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardOrganization;
import org.kuali.kfs.sys.service.UniversityDateService;

public class ContractsGrantsBillingAwardVerificationServiceTest {
    private ContractsGrantsBillingAwardVerificationServiceImpl contractsGrantsBillingAwardVerificationService;
    private BusinessObjectService businessObjectService;
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    private UniversityDateService universityDateService;

    @Before
    public void setup() {
        this.contractsGrantsBillingAwardVerificationService = new ContractsGrantsBillingAwardVerificationServiceImpl();
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.contractsGrantsBillingAwardVerificationService.setBusinessObjectService(this.businessObjectService);
        this.contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)EasyMock.createMock(ContractsGrantsInvoiceDocumentService.class);
        this.contractsGrantsBillingAwardVerificationService.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentService);
        this.universityDateService = (UniversityDateService)EasyMock.createMock(UniversityDateService.class);
        this.contractsGrantsBillingAwardVerificationService.setUniversityDateService(this.universityDateService);
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.businessObjectService, this.contractsGrantsInvoiceDocumentService, this.universityDateService});
    }

    private void executeIsChartAndOrgSetupForInvoicingTest(boolean hasPrimaryAwardOrganization, boolean hasProcessing, boolean hasOrganizationAccountingDefault, boolean hasSystemInformation, boolean expectedResult) {
        Award award = new Award();
        if (hasPrimaryAwardOrganization) {
            AwardOrganization primaryAwardOrganization = new AwardOrganization();
            primaryAwardOrganization.setChartOfAccountsCode("C1");
            primaryAwardOrganization.setOrganizationCode("11111");
            award.setPrimaryAwardOrganization(primaryAwardOrganization);
        }
        EasyMock.expect((Object)this.universityDateService.getCurrentFiscalYear()).andReturn((Object)2015);
        if (hasProcessing) {
            EasyMock.expect((Object)this.contractsGrantsInvoiceDocumentService.getProcessingFromBillingCodes("C1", "11111")).andReturn(Arrays.asList("C2", "22222"));
        } else {
            EasyMock.expect((Object)this.contractsGrantsInvoiceDocumentService.getProcessingFromBillingCodes("C1", "11111")).andReturn(new ArrayList());
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", 2015);
        criteria.put("chartOfAccountsCode", "C1");
        criteria.put("organizationCode", "11111");
        if (hasOrganizationAccountingDefault) {
            EasyMock.expect((Object)this.businessObjectService.findByPrimaryKey(OrganizationAccountingDefault.class, criteria)).andReturn((Object)new OrganizationAccountingDefault());
        } else {
            EasyMock.expect((Object)this.businessObjectService.findByPrimaryKey(OrganizationAccountingDefault.class, criteria)).andReturn(null);
        }
        HashMap<String, Object> sysCriteria = new HashMap<String, Object>();
        sysCriteria.put("universityFiscalYear", 2015);
        sysCriteria.put("processingChartOfAccountCode", "C2");
        sysCriteria.put("processingOrganizationCode", "22222");
        if (hasSystemInformation) {
            EasyMock.expect((Object)this.businessObjectService.findByPrimaryKey(SystemInformation.class, sysCriteria)).andReturn((Object)new SystemInformation());
        } else {
            EasyMock.expect((Object)this.businessObjectService.findByPrimaryKey(SystemInformation.class, sysCriteria)).andReturn(null);
        }
        this.replayAll();
        boolean result = this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing((ContractsAndGrantsBillingAward)award);
        Assert.assertTrue((String)("Method should return " + expectedResult), (result == expectedResult ? 1 : 0) != 0);
    }

    @Test
    public void testChartAndOrgValid() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, true, true, true);
    }

    @Test
    public void testNoPrimaryAwardOrganization() {
        this.executeIsChartAndOrgSetupForInvoicingTest(false, true, true, true, false);
    }

    @Test
    public void testNoProcessingFromBillingCodes() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, false, true, true, false);
    }

    @Test
    public void testNoOrganizationAccountingDefault() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, false, true, false);
    }

    @Test
    public void testNoSystemInformation() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, true, false, false);
    }
}

