/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.ArrayList;
import java.util.HashMap;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsLetterOfCreditFund;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceDetailAccountObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.InvoiceSuspensionCategory;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.dataaccess.AwardAccountObjectCodeTotalBilledDao;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.ContractsGrantsInvoiceDocumentDao;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.fixture.ARAgencyFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.fixture.ContractsGrantsInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.ContractsGrantsInvoiceDocumentFixture;
import org.kuali.kfs.module.ar.fixture.CustomerAddressFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceAccountDetailFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceAddressDetailFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceBillFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceDetailAccountObjectCodeFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceGeneralDetailFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceMilestoneFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceSuspensionCategoryFixture;
import org.kuali.kfs.module.ar.service.CostCategoryService;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.fixture.LetterOfCreditFundFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.wklykins)
public class ContractsGrantsInvoiceDocumentServiceTest
extends KualiTestBase {
    ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    ContractsGrantsInvoiceDocumentServiceImpl contractsGrantsInvoiceDocumentServiceImpl = new ContractsGrantsInvoiceDocumentServiceImpl();
    ContractsGrantsInvoiceCreateDocumentServiceImpl contractsGrantsInvoiceCreateDocumentServiceImpl = new ContractsGrantsInvoiceCreateDocumentServiceImpl();

    protected void setUp() throws Exception {
        this.contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        this.contractsGrantsInvoiceDocumentServiceImpl.setBusinessObjectService((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class));
        this.contractsGrantsInvoiceDocumentServiceImpl.setObjectCodeService((ObjectCodeService)SpringContext.getBean(ObjectCodeService.class));
        this.contractsGrantsInvoiceDocumentServiceImpl.setUniversityDateService((UniversityDateService)SpringContext.getBean(UniversityDateService.class));
        this.contractsGrantsInvoiceDocumentServiceImpl.setOptionsService((OptionsService)SpringContext.getBean(OptionsService.class));
        this.contractsGrantsInvoiceDocumentServiceImpl.setContractsGrantsInvoiceDocumentDao((ContractsGrantsInvoiceDocumentDao)SpringContext.getBean(ContractsGrantsInvoiceDocumentDao.class));
        this.contractsGrantsInvoiceDocumentServiceImpl.setCostCategoryService((CostCategoryService)SpringContext.getBean(CostCategoryService.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setAwardAccountObjectCodeTotalBilledDao((AwardAccountObjectCodeTotalBilledDao)SpringContext.getBean(AwardAccountObjectCodeTotalBilledDao.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setBusinessObjectService((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setUniversityDateService((UniversityDateService)SpringContext.getBean(UniversityDateService.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setContractsGrantsInvoiceDocumentService((ContractsGrantsInvoiceDocumentService)this.contractsGrantsInvoiceDocumentServiceImpl);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setCostCategoryService((CostCategoryService)SpringContext.getBean(CostCategoryService.class));
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.setOptionsService((OptionsService)SpringContext.getBean(OptionsService.class));
        super.setUp();
    }

    public void testProrateBill() throws WorkflowException {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL1.createInvoiceDetail();
        ContractsGrantsInvoiceDetail invoiceDetail_2 = ContractsGrantsInvoiceDetailFixture.INV_DTL2.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        invoiceDetails.add(invoiceDetail_2);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        KualiDecimal value1 = new KualiDecimal(5);
        KualiDecimal value2 = new KualiDecimal(0);
        ((ContractsGrantsInvoiceDetail)contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails().get(0)).setInvoiceAmount(value1);
        ((ContractsGrantsInvoiceDetail)contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails().get(1)).setInvoiceAmount(value2);
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail_2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        accountDetails.add(invoiceAccountDetail_2);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.generateValuesForCategories(contractsGrantsInvoiceDocument.getDocumentNumber(), contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes(), new HashMap(), new ArrayList());
        this.contractsGrantsInvoiceDocumentService.prorateBill(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((Object)value1, (Object)((ContractsGrantsInvoiceDetail)contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails().get(0)).getInvoiceAmount());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((Object)value2, (Object)((ContractsGrantsInvoiceDetail)contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails().get(1)).getInvoiceAmount());
        contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().setAwardTotal(new KualiDecimal(4));
        this.contractsGrantsInvoiceDocumentService.prorateBill(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((Object)new KualiDecimal(4.0), (Object)((ContractsGrantsInvoiceDetail)contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails().get(0)).getInvoiceAmount());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((Object)new KualiDecimal(0), (Object)((ContractsGrantsInvoiceDetail)contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails().get(1)).getInvoiceAmount());
    }

    public void testUpdateInvoiceDetailTotalDirectCost() {
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL1.createInvoiceDetail();
        ContractsGrantsInvoiceDetail invoiceDetail_2 = ContractsGrantsInvoiceDetailFixture.INV_DTL3.createInvoiceDetail();
        KualiDecimal value1 = new KualiDecimal(2.23);
        KualiDecimal value2 = new KualiDecimal(5.43);
        invoiceDetail_1.setInvoiceAmount(value1);
        invoiceDetail_2.setInvoiceAmount(value2);
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        invoiceDetails.add(invoiceDetail_2);
        KualiDecimal expectedResult = new KualiDecimal(7.66);
        ContractsGrantsInvoiceDocumentServiceTest.assertTrue((expectedResult.compareTo((AbstractKualiDecimal)this.contractsGrantsInvoiceDocumentServiceImpl.getInvoiceDetailExpenditureSum(invoiceDetails)) == 0 ? 1 : 0) != 0);
    }

    public void testRecalculateAccountDetails() {
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail_2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        invoiceAccountDetail_1.setInvoiceAmount(new KualiDecimal(4.5));
        invoiceAccountDetail_2.setInvoiceAmount(new KualiDecimal(5.5));
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(invoiceAccountDetail_1);
        invoiceAccountDetails.add(invoiceAccountDetail_2);
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode_1 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD1.createInvoiceDetailAccountObjectCode();
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode_2 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD2.createInvoiceDetailAccountObjectCode();
        KualiDecimal value1 = new KualiDecimal(3.01);
        KualiDecimal value2 = new KualiDecimal(2.02);
        invoiceDetailAccountObjectCode_1.setCurrentExpenditures(value1);
        invoiceDetailAccountObjectCode_2.setCurrentExpenditures(value2);
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode_1);
        invoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode_2);
        this.contractsGrantsInvoiceDocumentServiceImpl.recalculateAccountDetails(invoiceAccountDetails, invoiceDetailAccountObjectCodes);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((Object)value1, (Object)((InvoiceAccountDetail)invoiceAccountDetails.get(0)).getInvoiceAmount());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((Object)value2, (Object)((InvoiceAccountDetail)invoiceAccountDetails.get(1)).getInvoiceAmount());
    }

    public void testRecalculateNewTotalBilled() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        KualiDecimal value1 = new KualiDecimal(5.1);
        KualiDecimal value2 = new KualiDecimal(6.5);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL1.createInvoiceDetail();
        ContractsGrantsInvoiceDetail invoiceDetail_2 = ContractsGrantsInvoiceDetailFixture.INV_DTL3.createInvoiceDetail();
        invoiceDetail_1.setInvoiceAmount(value1);
        invoiceDetail_2.setInvoiceAmount(value2);
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        invoiceDetails.add(invoiceDetail_2);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail_2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        accountDetails.add(invoiceAccountDetail_2);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        this.contractsGrantsInvoiceCreateDocumentServiceImpl.generateValuesForCategories(contractsGrantsInvoiceDocument.getDocumentNumber(), contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes(), new HashMap(), new ArrayList());
        this.contractsGrantsInvoiceDocumentServiceImpl.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocument);
        value1 = new KualiDecimal(10.22);
        value2 = new KualiDecimal(8.44);
        ((ContractsGrantsInvoiceDetail)invoiceDetails.get(0)).setInvoiceAmount(value1);
        ((ContractsGrantsInvoiceDetail)invoiceDetails.get(1)).setInvoiceAmount(value2);
        this.contractsGrantsInvoiceDocumentServiceImpl.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((Object)value1.add((AbstractKualiDecimal)value2), (Object)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    public void testUpdateSuspensionCategoriesOnDocument() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD2.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceSuspensionCategory invoiceSuspensionCategory_1 = InvoiceSuspensionCategoryFixture.INV_SUSPEN_CTGR1.createInvoiceSuspensionCategory();
        InvoiceSuspensionCategory invoiceSuspensionCategory_2 = InvoiceSuspensionCategoryFixture.INV_SUSPEN_CTGR2.createInvoiceSuspensionCategory();
        ArrayList<InvoiceSuspensionCategory> invoiceSuspensionCategories = new ArrayList<InvoiceSuspensionCategory>();
        invoiceSuspensionCategories.add(invoiceSuspensionCategory_1);
        invoiceSuspensionCategories.add(invoiceSuspensionCategory_2);
        contractsGrantsInvoiceDocument.setInvoiceSuspensionCategories(invoiceSuspensionCategories);
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail_2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        accountDetails.add(invoiceAccountDetail_2);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)4, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)4, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
    }

    public void testUpdateSuspensionCategoriesOnCorrectionDocument() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        contractsGrantsInvoiceDocument.getFinancialSystemDocumentHeader().setFinancialDocumentInErrorNumber("12345");
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD2.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail_2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        accountDetails.add(invoiceAccountDetail_2);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)0, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)0, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
    }

    public void testUpdateSuspensionCategoriesOnDocumentValid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        InvoiceSuspensionCategory invoiceSuspensionCategory_1 = InvoiceSuspensionCategoryFixture.INV_SUSPEN_CTGR3.createInvoiceSuspensionCategory();
        InvoiceSuspensionCategory invoiceSuspensionCategory_2 = InvoiceSuspensionCategoryFixture.INV_SUSPEN_CTGR4.createInvoiceSuspensionCategory();
        ArrayList<InvoiceSuspensionCategory> invoiceSuspensionCategories = new ArrayList<InvoiceSuspensionCategory>();
        invoiceSuspensionCategory_1.setDocumentNumber(contractsGrantsInvoiceDocument.getDocumentNumber());
        invoiceSuspensionCategory_2.setDocumentNumber(contractsGrantsInvoiceDocument.getDocumentNumber());
        invoiceSuspensionCategories.add(invoiceSuspensionCategory_1);
        invoiceSuspensionCategories.add(invoiceSuspensionCategory_2);
        contractsGrantsInvoiceDocument.setInvoiceSuspensionCategories(invoiceSuspensionCategories);
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)0, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory1Invalid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL7.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"1", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory2Invalid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD6.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"2", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory3Invalid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        ((Award)award).setAdditionalFormsRequiredIndicator(true);
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"3", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory4InvalidNoAddress() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"4", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory4InvalidUSAddress() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = CustomerAddressFixture.CUSTOMER_ADDRESS_INVALID_US_PRIMARY1.createCustomerAddress();
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"4", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory4ValidUSAddress() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = CustomerAddressFixture.CUSTOMER_ADDRESS_VALID_US_PRIMARY1.createCustomerAddress();
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)0, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory4InvalidInternationalAddress() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = CustomerAddressFixture.CUSTOMER_ADDRESS_INVALID_FOREIGN_PRIMARY1.createCustomerAddress();
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"4", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory4ValidInternationalAddress() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = CustomerAddressFixture.CUSTOMER_ADDRESS_VALID_FOREIGN_PRIMARY1.createCustomerAddress();
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)0, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory5InvalidNoAltAddress() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail_1 = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        InvoiceAddressDetail invoiceAddressDetail_2 = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL2.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail_1.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail_1);
        invoiceAddressDetails.add(invoiceAddressDetail_2);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"5", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory5InvalidUSAltAddress() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail_1 = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        InvoiceAddressDetail invoiceAddressDetail_2 = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL2.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail_1.setCustomerAddress(customerAddress);
        CustomerAddress customerAddress2 = CustomerAddressFixture.CUSTOMER_ADDRESS_INVALID_US_ALTERNATE1.createCustomerAddress();
        invoiceAddressDetail_2.setCustomerAddress(customerAddress2);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail_1);
        invoiceAddressDetails.add(invoiceAddressDetail_2);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"5", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory5ValidUSAltAddress() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail_1 = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        InvoiceAddressDetail invoiceAddressDetail_2 = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL2.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail_1.setCustomerAddress(customerAddress);
        CustomerAddress customerAddress2 = CustomerAddressFixture.CUSTOMER_ADDRESS_VALID_US_ALTERNATE1.createCustomerAddress();
        invoiceAddressDetail_2.setCustomerAddress(customerAddress2);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail_1);
        invoiceAddressDetails.add(invoiceAddressDetail_2);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)0, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory5InvalidForeignAltAddress() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail_1 = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        InvoiceAddressDetail invoiceAddressDetail_2 = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL2.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail_1.setCustomerAddress(customerAddress);
        CustomerAddress customerAddress2 = CustomerAddressFixture.CUSTOMER_ADDRESS_INVALID_FOREIGN_ALTERNATE1.createCustomerAddress();
        invoiceAddressDetail_2.setCustomerAddress(customerAddress2);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail_1);
        invoiceAddressDetails.add(invoiceAddressDetail_2);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"5", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory5ValidForeignAltAddress() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail_1 = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        InvoiceAddressDetail invoiceAddressDetail_2 = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL2.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail_1.setCustomerAddress(customerAddress);
        CustomerAddress customerAddress2 = CustomerAddressFixture.CUSTOMER_ADDRESS_VALID_FOREIGN_ALTERNATE1.createCustomerAddress();
        invoiceAddressDetail_2.setCustomerAddress(customerAddress2);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail_1);
        invoiceAddressDetails.add(invoiceAddressDetail_2);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)0, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory6Invalid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD8.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"6", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory7Invalid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail_2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        accountDetails.add(invoiceAccountDetail_2);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"7", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory8Invalid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD10.createAward();
        ((Award)award).setLetterOfCreditFund((ContractsAndGrantsLetterOfCreditFund)LetterOfCreditFundFixture.CG_LOCF.createLetterOfCreditFund());
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL7.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"8", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory9Invalid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_3.createAwardAccount();
        awardAccount_1.refreshReferenceObject("account");
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        ((Award)award).setAwardAccounts(awardAccounts);
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"9", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory10Invalid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        ((Award)award).setExcludedFromInvoicing(true);
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"10", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory11Invalid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_4.createAwardAccount();
        awardAccount_1.refreshReferenceObject("account");
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        ((Award)award).setAwardAccounts(awardAccounts);
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode_1 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD3.createInvoiceDetailAccountObjectCode();
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode_1);
        contractsGrantsInvoiceDocument.setInvoiceDetailAccountObjectCodes(invoiceDetailAccountObjectCodes);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"11", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testUpdateSuspensionCategoriesOnDocumentCategory12Invalid() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        ContractsGrantsInvoiceDocumentServiceTest.assertNotNull((Object)contractsGrantsInvoiceDocument);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD4.createAward();
        ((Award)award).setStopWorkIndicator(true);
        Agency agency = ARAgencyFixture.CG_AGENCY1.createAgency();
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL5.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(award);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAddressDetail invoiceAddressDetail = InvoiceAddressDetailFixture.INV_ADDRESS_DETAIL1.createInvoiceAddressDetail();
        CustomerAddressService customerAddressService = (CustomerAddressService)SpringContext.getBean(CustomerAddressService.class);
        CustomerAddress customerAddress = customerAddressService.getPrimaryAddress(agency.getCustomerNumber());
        invoiceAddressDetail.setCustomerAddress(customerAddress);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(invoiceAddressDetail);
        contractsGrantsInvoiceDocument.setInvoiceAddressDetails(invoiceAddressDetails);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL7.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(contractsGrantsInvoiceDocument);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((int)1, (int)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().size());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)"12", (String)((InvoiceSuspensionCategory)contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().iterator().next()).getSuspensionCategoryCode());
    }

    public void testCreateSourceAccountingLines() {
        String coaCode = "BL";
        String orgCode = "SRS";
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument(documentService);
        contractsGrantsInvoiceDocument.setBillByChartOfAccountCode(coaCode);
        contractsGrantsInvoiceDocument.setBilledByOrganizationCode(orgCode);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setDocumentNumber(contractsGrantsInvoiceDocument.getDocumentNumber());
        accountsReceivableDocumentHeader.setProcessingChartOfAccountCode(coaCode);
        accountsReceivableDocumentHeader.setProcessingOrganizationCode(orgCode);
        contractsGrantsInvoiceDocument.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
        InvoiceGeneralDetail inv_Gnrl_Dtl_1 = InvoiceGeneralDetailFixture.INV_GNRL_DTL3.createInvoiceGeneralDetail();
        InvoiceGeneralDetail inv_Gnrl_Dtl_Mlstn = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        InvoiceGeneralDetail inv_Gnrl_Dtl_Bill = InvoiceGeneralDetailFixture.INV_GNRL_DTL4.createInvoiceGeneralDetail();
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_1);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL8.createInvoiceDetail();
        ContractsGrantsInvoiceDetail invoiceDetail_2 = ContractsGrantsInvoiceDetailFixture.INV_DTL9.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        invoiceDetails.add(invoiceDetail_2);
        contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD4.createInvoiceDetailAccountObjectCode());
        invoiceDetailAccountObjectCodes.add(InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD5.createInvoiceDetailAccountObjectCode());
        contractsGrantsInvoiceDocument.setInvoiceDetailAccountObjectCodes(invoiceDetailAccountObjectCodes);
        KualiDecimal value1 = new KualiDecimal(5);
        KualiDecimal value2 = new KualiDecimal(0);
        ((ContractsGrantsInvoiceDetail)contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails().get(0)).setInvoiceAmount(value1);
        ((ContractsGrantsInvoiceDetail)contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails().get(1)).setInvoiceAmount(value2);
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL3.createInvoiceAccountDetail();
        InvoiceAccountDetail invoiceAccountDetail_2 = InvoiceAccountDetailFixture.INV_ACCT_DTL4.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        accountDetails.add(invoiceAccountDetail_2);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        ArrayList<InvoiceMilestone> invoiceMilestones = new ArrayList<InvoiceMilestone>();
        InvoiceMilestone invMilestone_1 = InvoiceMilestoneFixture.INV_MLSTN_3.createInvoiceMilestone();
        invoiceMilestones.add(invMilestone_1);
        contractsGrantsInvoiceDocument.setInvoiceMilestones(invoiceMilestones);
        ArrayList<InvoiceBill> invoiceBills = new ArrayList<InvoiceBill>();
        InvoiceBill invBill_1 = InvoiceBillFixture.INV_BILL_3.createInvoiceBill();
        invoiceBills.add(invBill_1);
        contractsGrantsInvoiceDocument.setInvoiceBills(invoiceBills);
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        Integer currentYear = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
        criteria.put("universityFiscalYear", currentYear);
        criteria.put("chartOfAccountsCode", coaCode);
        criteria.put("organizationCode", orgCode);
        OrganizationAccountingDefault organizationAccountingDefault = (OrganizationAccountingDefault)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(OrganizationAccountingDefault.class, criteria);
        if (ObjectUtils.isNull((Object)organizationAccountingDefault)) {
            organizationAccountingDefault = new OrganizationAccountingDefault();
            organizationAccountingDefault.setChartOfAccountsCode("BL");
            organizationAccountingDefault.setOrganizationCode("SRS");
            organizationAccountingDefault.setUniversityFiscalYear(currentYear);
        }
        organizationAccountingDefault.setDefaultInvoiceFinancialObjectCode("5000");
        organizationAccountingDefault.setDefaultPaymentFinancialObjectCode("8118");
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)organizationAccountingDefault);
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE_2.createCustomerInvoiceDetail();
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_1);
        inv_Gnrl_Dtl_1.setAward(ARAwardFixture.CG_AWARD_INV_AWARD.createAward());
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_Mlstn);
        inv_Gnrl_Dtl_Mlstn.setAward(ARAwardFixture.CG_AWARD_INV_AWARD.createAward());
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_Bill);
        inv_Gnrl_Dtl_Bill.setAward(ARAwardFixture.CG_AWARD_INV_AWARD.createAward());
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_1);
        inv_Gnrl_Dtl_1.setAward(ARAwardFixture.CG_AWARD_INV_ACCOUNT.createAward());
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_1);
        inv_Gnrl_Dtl_1.setAward(ARAwardFixture.CG_AWARD_INV_CCA.createAward());
        accountDetails.clear();
        accountDetails.add(invoiceAccountDetail_2);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_SUBFUND_RECEIVABLE_2.createCustomerInvoiceDetail();
        accountDetails.clear();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_1);
        inv_Gnrl_Dtl_1.setAward(ARAwardFixture.CG_AWARD_INV_AWARD.createAward());
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_Mlstn);
        inv_Gnrl_Dtl_Mlstn.setAward(ARAwardFixture.CG_AWARD_INV_AWARD.createAward());
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_Bill);
        inv_Gnrl_Dtl_Bill.setAward(ARAwardFixture.CG_AWARD_INV_AWARD.createAward());
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_1);
        inv_Gnrl_Dtl_1.setAward(ARAwardFixture.CG_AWARD_INV_ACCOUNT.createAward());
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_1);
        inv_Gnrl_Dtl_1.setAward(ARAwardFixture.CG_AWARD_INV_CCA.createAward());
        accountDetails.clear();
        accountDetails.add(invoiceAccountDetail_2);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_SUBFUND_RECEIVABLE_2.createCustomerInvoiceDetail();
        accountDetails.clear();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_1);
        inv_Gnrl_Dtl_1.setAward(ARAwardFixture.CG_AWARD_INV_AWARD.createAward());
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_Mlstn);
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_Bill);
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_1);
        inv_Gnrl_Dtl_1.setAward(ARAwardFixture.CG_AWARD_INV_ACCOUNT.createAward());
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
        contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(inv_Gnrl_Dtl_1);
        inv_Gnrl_Dtl_1.setAward(ARAwardFixture.CG_AWARD_INV_CCA.createAward());
        accountDetails.clear();
        accountDetails.add(invoiceAccountDetail_2);
        contractsGrantsInvoiceDocument.setAccountDetails(accountDetails);
        this.compareSourceAccountingLines(contractsGrantsInvoiceDocument, customerInvoiceDetail);
    }

    public void compareSourceAccountingLines(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument, CustomerInvoiceDetail customerInvoiceDetail) {
        contractsGrantsInvoiceDocument.getSourceAccountingLines().clear();
        this.contractsGrantsInvoiceDocumentService.createSourceAccountingLines(contractsGrantsInvoiceDocument, contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAward().getActiveAwardAccounts());
        CustomerInvoiceDetail invoiceDetail = (CustomerInvoiceDetail)contractsGrantsInvoiceDocument.getSourceAccountingLine(0);
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)invoiceDetail.getAccountNumber(), (String)customerInvoiceDetail.getAccountNumber());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)invoiceDetail.getChartOfAccountsCode(), (String)customerInvoiceDetail.getChartOfAccountsCode());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((String)invoiceDetail.getFinancialObjectCode(), (String)customerInvoiceDetail.getFinancialObjectCode());
        ContractsGrantsInvoiceDocumentServiceTest.assertEquals((Object)invoiceDetail.getAmount(), (Object)customerInvoiceDetail.getAmount());
    }
}

