/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.math.BigDecimal;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.service.CustomerCreditMemoDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentTestUtil;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerCreditMemoDetailServiceTest
extends KualiTestBase {
    private CustomerCreditMemoDetailService service;
    private CustomerCreditMemoDocument document;
    private CustomerCreditMemoDetail detail;
    private KualiDecimal testAmount;

    protected void setUp() throws Exception {
        super.setUp();
        this.service = (CustomerCreditMemoDetailService)SpringContext.getBean(CustomerCreditMemoDetailService.class);
        String documentNumber = CustomerInvoiceDocumentTestUtil.submitNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER, new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE}, null);
        this.document = new CustomerCreditMemoDocument();
        this.document.setFinancialDocumentReferenceInvoiceNumber(documentNumber);
        this.document.getInvoice();
        this.detail = new CustomerCreditMemoDetail();
        this.detail.setReferenceInvoiceItemNumber(new Integer(1));
        this.detail.setFinancialDocumentReferenceInvoiceNumber(documentNumber);
        this.testAmount = new KualiDecimal(0.5);
    }

    protected void tearDown() throws Exception {
        this.service = null;
        this.document = null;
        this.detail = null;
        this.testAmount = null;
        super.tearDown();
    }

    public void testRecalculateCustomerCreditMemoDetail_Quantity() {
        this.detail.setCreditMemoItemQuantity(new BigDecimal(0.5));
        CustomerCreditMemoDetailServiceTest.assertTrue((boolean)this.detail.getCreditMemoItemQuantity().equals(new BigDecimal(0.5)));
        this.service.recalculateCustomerCreditMemoDetail(this.detail, this.document);
        CustomerCreditMemoDetailServiceTest.assertEquals((int)0, (int)this.detail.getCreditMemoItemTotalAmount().compareTo((AbstractKualiDecimal)this.testAmount));
        CustomerCreditMemoDetailServiceTest.assertTrue((boolean)this.detail.getCreditMemoItemTaxAmount().equals((Object)KualiDecimal.ZERO));
        CustomerCreditMemoDetailServiceTest.assertTrue((boolean)this.detail.getCreditMemoLineTotalAmount().equals((Object)this.testAmount));
        CustomerCreditMemoDetailServiceTest.assertFalse((boolean)this.detail.getCreditMemoItemTaxAmount().isPositive());
        CustomerCreditMemoDetailServiceTest.assertTrue((boolean)this.detail.getCreditMemoItemTotalAmount().equals((Object)this.testAmount));
        CustomerCreditMemoDetailServiceTest.assertTrue((boolean)this.detail.getCreditMemoLineTotalAmount().equals((Object)this.testAmount));
    }

    public void testRecalculateCustomerCreditMemoDetail_ItemAmount() {
        this.detail.setCreditMemoItemTotalAmount(this.testAmount);
        CustomerCreditMemoDetailServiceTest.assertTrue((boolean)this.detail.getCreditMemoItemTotalAmount().equals((Object)this.testAmount));
        this.service.recalculateCustomerCreditMemoDetail(this.detail, this.document);
        CustomerCreditMemoDetailServiceTest.assertEquals((int)0, (int)this.detail.getCreditMemoItemQuantity().compareTo(new BigDecimal(0.5)));
        CustomerCreditMemoDetailServiceTest.assertTrue((boolean)this.detail.getCreditMemoItemTaxAmount().equals((Object)KualiDecimal.ZERO));
        CustomerCreditMemoDetailServiceTest.assertTrue((boolean)this.detail.getCreditMemoLineTotalAmount().equals((Object)this.testAmount));
        CustomerCreditMemoDetailServiceTest.assertFalse((boolean)this.detail.getCreditMemoItemTaxAmount().isPositive());
        CustomerCreditMemoDetailServiceTest.assertTrue((boolean)this.detail.getCreditMemoItemTotalAmount().equals((Object)this.testAmount));
        CustomerCreditMemoDetailServiceTest.assertTrue((boolean)this.detail.getCreditMemoLineTotalAmount().equals((Object)this.testAmount));
    }
}

