/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentTestUtil;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerCreditMemoDocumentRule;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
public class CustomerCreditMemoDocumentRuleTest
extends KualiTestBase {
    public static Logger LOG = Logger.getLogger(CustomerCreditMemoDocumentRuleTest.class);
    private CustomerCreditMemoDocumentRule rule;
    private CustomerCreditMemoDocument document;

    protected void setUp() throws Exception {
        super.setUp();
        this.rule = new CustomerCreditMemoDocumentRule();
        this.document = new CustomerCreditMemoDocument();
    }

    protected void tearDown() throws Exception {
        this.rule = null;
        this.document = null;
        super.tearDown();
    }

    public void testIsQtyOrItemAmountEntered_EmptyString_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.isQtyOrItemAmountEntered(detail).equals(""));
    }

    public void testIsQtyOrItemAmountEntered_Qty_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.isQtyOrItemAmountEntered(detail).equals("qty"));
    }

    public void testIsQtyOrItemAmountEntered_Amount_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.isQtyOrItemAmountEntered(detail).equals("itemAmount"));
    }

    public void testIsQtyOrItemAmountEntered_Both_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.isQtyOrItemAmountEntered(detail).equals("both"));
    }

    public void testIsValueGreaterThanZero_True() {
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.isValueGreaterThanZero(BigDecimal.ONE));
    }

    public void testIsValueGreaterThanZero_False() {
        CustomerCreditMemoDocumentRuleTest.assertFalse((boolean)this.rule.isValueGreaterThanZero(BigDecimal.ZERO));
    }

    public void testIsValueGreaterThanZero_KualiDecimal_True() {
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.isValueGreaterThanZero(new KualiDecimal(1)));
    }

    public void testIsValueGreaterThanZero_KualiDecimal_False() {
        CustomerCreditMemoDocumentRuleTest.assertFalse((boolean)this.rule.isValueGreaterThanZero(KualiDecimal.ZERO));
    }

    public void testIsCustomerCreditMemoItemAmountGreaterThanInvoiceOpenItemAmount_Equal_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(2));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(2));
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(this.document, detail));
    }

    public void testIsCustomerCreditMemoItemAmountGreaterThanInvoiceOpenItemAmount_Less_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(2));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(this.document, detail));
    }

    public void testIsCustomerCreditMemoItemAmountGreaterThanInvoiceOpenItemAmount_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(1));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(2));
        CustomerCreditMemoDocumentRuleTest.assertFalse((boolean)this.rule.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(this.document, detail));
    }

    public void testIsCustomerCreditMemoQtyGreaterThanInvoiceQty_Equal_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(2));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
    }

    public void testIsCustomerCreditMemoQtyGreaterThanInvoiceQty_Less_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(2));
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
    }

    public void testIsCustomerCreditMemoQtyGreaterThanInvoiceQty_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(1));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        CustomerCreditMemoDocumentRuleTest.assertFalse((boolean)this.rule.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
    }

    public void testCheckIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_ExactMatch() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(4));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(2)));
    }

    public void testCheckIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_FarOff() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(10));
        CustomerCreditMemoDocumentRuleTest.assertFalse((boolean)this.rule.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    public void testCheckIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_JustAboveAllowedDeviation() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(5.6));
        CustomerCreditMemoDocumentRuleTest.assertFalse((boolean)this.rule.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    public void testCheckIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_ExactlyAllowedDeviation() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(5.5));
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    public void testCheckIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_JustBelowAllowedDeviation() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(5.4));
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    public void testCheckIfInvoiceNumberIsValid_False() {
        CustomerCreditMemoDocumentRuleTest.assertFalse((boolean)this.rule.checkIfInvoiceNumberIsFinal("KLM0456"));
    }

    public void testCheckIfInvoiceNumberIsValid_True() throws WorkflowException {
        String documentNumber = CustomerInvoiceDocumentTestUtil.submitNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER, new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE}, null);
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.checkIfInvoiceNumberIsFinal(documentNumber));
    }

    public void testCheckIfThereIsNoAnotherCRMInRouteForTheInvoice_True() throws WorkflowException {
        String documentNumber = CustomerInvoiceDocumentTestUtil.submitNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER, new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE}, null);
        CustomerCreditMemoDocumentRuleTest.assertTrue((boolean)this.rule.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(documentNumber));
    }

    public void testCheckIfThereIsNoAnotherCRMInRouteForTheInvoice_False() throws WorkflowException {
        String invoiceNumber = "";
        CustomerInvoiceDocument invoice = CustomerInvoiceDocumentTestUtil.submitNewCustomerInvoiceDocumentAndReturnIt(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER, new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE}, null);
        invoiceNumber = invoice.getDocumentNumber();
        this.document = this.createCustomerCreditMemoDocument(invoice);
        this.document.getDocumentHeader().setDocumentDescription("CREATING TEST CRM DOCUMENT");
        try {
            Document document = ((DocumentService)SpringContext.getBean(DocumentService.class)).routeDocument((Document)this.document, "Routing from Unit Test", null);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
        CustomerCreditMemoDocumentRuleTest.assertFalse((boolean)this.rule.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(invoiceNumber));
    }

    public CustomerCreditMemoDocument createCustomerCreditMemoDocument(CustomerInvoiceDocument invoice) {
        CustomerCreditMemoDocument customerCreditMemoDocument = null;
        try {
            customerCreditMemoDocument = (CustomerCreditMemoDocument)DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), CustomerCreditMemoDocument.class);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Document creation failed.");
        }
        customerCreditMemoDocument.setInvoice(invoice);
        customerCreditMemoDocument.setFinancialDocumentReferenceInvoiceNumber(invoice.getDocumentNumber());
        List customerInvoiceDetails = invoice.getCustomerInvoiceDetailsWithoutDiscounts();
        if (customerInvoiceDetails == null) {
            return customerCreditMemoDocument;
        }
        for (CustomerInvoiceDetail customerInvoiceDetail : customerInvoiceDetails) {
            CustomerCreditMemoDetail customerCreditMemoDetail = new CustomerCreditMemoDetail();
            customerCreditMemoDetail.setDocumentNumber(customerCreditMemoDocument.getDocumentNumber());
            KualiDecimal invItemTaxAmount = customerInvoiceDetail.getInvoiceItemTaxAmount();
            if (invItemTaxAmount == null) {
                invItemTaxAmount = KualiDecimal.ZERO;
            }
            customerCreditMemoDetail.setCreditMemoItemTaxAmount((KualiDecimal)invItemTaxAmount.divide((AbstractKualiDecimal)new KualiDecimal(2)));
            customerCreditMemoDetail.setReferenceInvoiceItemNumber(customerInvoiceDetail.getSequenceNumber());
            BigDecimal itemQuantity = customerInvoiceDetail.getInvoiceItemQuantity().divide(new BigDecimal(2));
            customerCreditMemoDetail.setCreditMemoItemQuantity(itemQuantity);
            KualiDecimal itemAmount = (KualiDecimal)customerInvoiceDetail.getAmount().divide((AbstractKualiDecimal)new KualiDecimal(2));
            customerCreditMemoDetail.setCreditMemoItemTotalAmount(itemAmount);
            customerCreditMemoDetail.setFinancialDocumentReferenceInvoiceNumber(invoice.getDocumentNumber());
            customerCreditMemoDetail.setCustomerInvoiceDetail(customerInvoiceDetail);
            customerCreditMemoDocument.getCreditMemoDetails().add(customerCreditMemoDetail);
        }
        return customerCreditMemoDocument;
    }
}

