/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFundManagerFixture;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ValidateAwardsTest {
    private ContractsGrantsInvoiceCreateDocumentServiceImpl contractsGrantsInvoiceCreateDocumentService;
    private ContractsGrantsBillingAwardVerificationService contractsGrantsBillingAwardVerificationService;
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    private VerifyBillingFrequencyService verifyBillingFrequencyService;
    private FinancialSystemDocumentService financialSystemDocumentService;
    private BusinessObjectService businessObjectService;
    private ConfigurationService configurationService;
    private OptionsService optionsService;
    private DateTimeService dateTimeService;
    private Set<String> pendingDocumentStatuses = new HashSet<String>(Arrays.asList("I", "S", "R", "E"));

    @Before
    public void setup() {
        this.contractsGrantsInvoiceCreateDocumentService = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.contractsGrantsBillingAwardVerificationService = (ContractsGrantsBillingAwardVerificationService)EasyMock.createMock(ContractsGrantsBillingAwardVerificationService.class);
        this.contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)EasyMock.createMock(ContractsGrantsInvoiceDocumentService.class);
        this.verifyBillingFrequencyService = (VerifyBillingFrequencyService)EasyMock.createMock(VerifyBillingFrequencyService.class);
        this.financialSystemDocumentService = (FinancialSystemDocumentService)EasyMock.createMock(FinancialSystemDocumentService.class);
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.configurationService = (ConfigurationService)EasyMock.createMock(ConfigurationService.class);
        this.optionsService = (OptionsService)EasyMock.createMock(OptionsService.class);
        this.dateTimeService = (DateTimeService)EasyMock.createMock(DateTimeService.class);
        this.contractsGrantsInvoiceCreateDocumentService.setContractsGrantsBillingAwardVerificationService(this.contractsGrantsBillingAwardVerificationService);
        this.contractsGrantsInvoiceCreateDocumentService.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentService);
        this.contractsGrantsInvoiceCreateDocumentService.setVerifyBillingFrequencyService(this.verifyBillingFrequencyService);
        this.contractsGrantsInvoiceCreateDocumentService.setFinancialSystemDocumentService(this.financialSystemDocumentService);
        this.contractsGrantsInvoiceCreateDocumentService.setBusinessObjectService(this.businessObjectService);
        this.contractsGrantsInvoiceCreateDocumentService.setConfigurationService(this.configurationService);
        this.contractsGrantsInvoiceCreateDocumentService.setOptionsService(this.optionsService);
        this.contractsGrantsInvoiceCreateDocumentService.setDateTimeService(this.dateTimeService);
    }

    @Test
    public void testValidateManualAwardsOneValidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.prepareOtherMocks();
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should be empty.", (contractsGrantsInvoiceDocumentErrorLogs.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should contain one award.", (validAwards.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should contain our initial award.", (boolean)validAwards.contains(awards.get(0)));
    }

    @Test
    public void testValidateManualAwardsOneInvalidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        this.replayMocks();
        ((Award)awards.get(0)).setExcludedFromInvoicing(true);
        ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain one award.", (contractsGrantsInvoiceDocumentErrorLogs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should be empty.", (validAwards.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain our initial award.", (boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, awards.get(0)));
    }

    @Test
    public void testValidateManualAwardsTwoValidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2);
        awards.addAll(awards2);
        this.prepareOtherMocks();
        this.replayMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should be empty.", (contractsGrantsInvoiceDocumentErrorLogs.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should contain one award.", (validAwards.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should contain our first award.", (boolean)validAwards.contains(awards.get(0)));
        Assert.assertTrue((String)"validAwards should contain our second award.", (boolean)validAwards.contains(awards.get(1)));
    }

    @Test
    public void testValidateManualAwardsTwoInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setExcludedFromInvoicing(true);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2);
        ((Award)awards2.get(0)).setExcludedFromInvoicing(true);
        awards.addAll(awards2);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        this.replayMocks();
        ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain two awards.", (contractsGrantsInvoiceDocumentErrorLogs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should be empty.", (validAwards.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain our first award.", (boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, awards.get(0)));
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain our second award.", (boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, awards.get(1)));
    }

    @Test
    public void testValidateManualAwardsOneValidOneInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2);
        ((Award)awards2.get(0)).setExcludedFromInvoicing(true);
        awards.addAll(awards2);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        this.replayMocks();
        ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain one award.", (contractsGrantsInvoiceDocumentErrorLogs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should contain one award.", (validAwards.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should contain our first award.", (boolean)validAwards.contains(awards.get(0)));
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain our second award.", (boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, awards.get(1)));
    }

    @Test
    public void testValidateBatchAwardsOneValidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.prepareOtherMocks();
        this.replayMocks();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"validAwards should contain one award.", (validAwards.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should contain our initial award.", (boolean)validAwards.contains(awards.get(0)));
    }

    @Test
    public void testValidateBatchAwardsOneInvalidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setExcludedFromInvoicing(true);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        this.replayMocks();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"validAwards should be empty.", (validAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testValidateBatchAwardsTwoValidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2);
        awards.addAll(awards2);
        this.prepareOtherMocks();
        this.replayMocks();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"validAwards should contain one award.", (validAwards.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should contain our first award.", (boolean)validAwards.contains(awards.get(0)));
        Assert.assertTrue((String)"validAwards should contain our second award.", (boolean)validAwards.contains(awards.get(1)));
    }

    @Test
    public void testValidateBatchAwardsTwoInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setExcludedFromInvoicing(true);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2);
        ((Award)awards2.get(0)).setExcludedFromInvoicing(true);
        awards.addAll(awards2);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        this.replayMocks();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"validAwards should be empty.", (validAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testValidateBatchAwardsOneValidOneInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2);
        ((Award)awards2.get(0)).setExcludedFromInvoicing(true);
        awards.addAll(awards2);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        this.replayMocks();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"validAwards should contain one award.", (validAwards.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"validAwards should contain our first award.", (boolean)validAwards.contains(awards.get(0)));
    }

    @Test
    public void testValidateDuplicateAccount() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        awards.addAll(awards2);
        this.expectError("error.cginvoice.account.on.multiple.awards");
        this.expectError("error.cginvoice.account.on.multiple.awards");
        this.prepareOtherMocks();
        this.replayMocks();
        Collection validAwards = this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        this.verifyMocks();
        Assert.assertTrue((String)"validAwards should be empty.", (validAwards.size() == 0 ? 1 : 0) != 0);
    }

    private List<ContractsAndGrantsBillingAward> setupAward(ARAwardAccountFixture awardAccountFixture) {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.createAward();
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAgencyFromFixture((Award)award);
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = awardAccountFixture.createAwardAccount();
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        ((Award)award).setAwardAccounts(awardAccounts);
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAwardOrganizationFromFixture((Award)award);
        AwardFundManager awardFundManager = ARAwardFundManagerFixture.AWD_FND_MGR1.createAwardFundManager();
        ((Award)award).getAwardFundManagers().add(awardFundManager);
        ((Award)award).setAwardPrimaryFundManager(ARAwardFundManagerFixture.AWD_FND_MGR1.createAwardFundManager());
        this.prepareMocks(award);
        awards.add(award);
        return awards;
    }

    private void prepareMocks(ContractsAndGrantsBillingAward award) {
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(award)).andReturn((Object)true);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.isBillingFrequencySetCorrectly(award)).andReturn((Object)true);
        EasyMock.expect((Object)this.verifyBillingFrequencyService.validateBillingFrequency(award)).andReturn((Object)true);
        EasyMock.expect((Object)this.contractsGrantsInvoiceDocumentService.getExpiredAccountsOfAward(award)).andReturn(null);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.isAwardFinalInvoiceAlreadyBuilt(award)).andReturn((Object)false);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.hasMilestonesToInvoice(award)).andReturn((Object)true);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.hasBillsToInvoice(award)).andReturn((Object)true);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(award)).andReturn((Object)true);
        EasyMock.expect((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(award)).andReturn(null);
        EasyMock.expect((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(award)).andReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", this.pendingDocumentStatuses);
        EasyMock.expect((Object)this.businessObjectService.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).andReturn(new ArrayList());
        for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
            EasyMock.expect((Object)this.verifyBillingFrequencyService.validateBillingFrequency(award, awardAccount)).andReturn((Object)true);
        }
    }

    private void expectError(String errorKey) {
        EasyMock.expect((Object)this.configurationService.getPropertyValueAsString(errorKey)).andReturn((Object)"Error");
        EasyMock.expect((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount((ContractsAndGrantsBillingAwardAccount)EasyMock.anyObject(), EasyMock.anyString(), (Date)EasyMock.anyObject())).andReturn((Object)KualiDecimal.ZERO);
        EasyMock.expect((Object)this.dateTimeService.getCurrentTimestamp()).andReturn(null);
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)EasyMock.isA(ContractsGrantsInvoiceDocumentErrorLog.class))).andReturn(null);
    }

    private void prepareOtherMocks() {
        EasyMock.expect((Object)this.optionsService.getCurrentYearOptions()).andReturn((Object)new SystemOptions()).anyTimes();
        EasyMock.expect((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).andReturn(this.pendingDocumentStatuses).anyTimes();
    }

    private void replayMocks() {
        EasyMock.replay((Object[])new Object[]{this.contractsGrantsBillingAwardVerificationService, this.contractsGrantsInvoiceDocumentService, this.verifyBillingFrequencyService, this.financialSystemDocumentService, this.businessObjectService, this.configurationService, this.optionsService, this.dateTimeService});
    }

    private void verifyMocks() {
        EasyMock.verify((Object[])new Object[]{this.contractsGrantsBillingAwardVerificationService, this.contractsGrantsInvoiceDocumentService, this.verifyBillingFrequencyService, this.financialSystemDocumentService, this.businessObjectService, this.configurationService, this.optionsService, this.dateTimeService});
    }

    private boolean errorLogContainsAward(Collection<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs, ContractsAndGrantsBillingAward award) {
        for (ContractsGrantsInvoiceDocumentErrorLog contractsGrantsInvoiceDocumentErrorLog : contractsGrantsInvoiceDocumentErrorLogs) {
            if (!contractsGrantsInvoiceDocumentErrorLog.getProposalNumber().equals(award.getProposalNumber())) continue;
            return true;
        }
        return false;
    }
}

