/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerInvoiceDetailAmountValidation
extends GenericValidation {
    private CustomerInvoiceDocument customerInvoiceDocument;
    private CustomerInvoiceDetail customerInvoiceDetail;

    public boolean validate(AttributedDocumentEvent event) {
        KualiDecimal amount = this.customerInvoiceDetail.getAmount();
        if (KualiDecimal.ZERO.equals((Object)amount)) {
            GlobalVariables.getMessageMap().putError("amount", "error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailTotalAmount", new String[0]);
            return false;
        }
        if (this.customerInvoiceDocument.isInvoiceReversal()) {
            if (this.customerInvoiceDetail.isDiscountLine() && amount.isNegative()) {
                GlobalVariables.getMessageMap().putError("amount", "error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailTotalAmount", new String[0]);
                return false;
            }
            if (!this.customerInvoiceDetail.isDiscountLine() && amount.isPositive()) {
                GlobalVariables.getMessageMap().putError("amount", "error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailTotalAmount", new String[0]);
                return false;
            }
        } else {
            if (this.customerInvoiceDetail.isDiscountLine() && amount.isPositive()) {
                GlobalVariables.getMessageMap().putError("amount", "error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailTotalAmount", new String[0]);
                return false;
            }
            if (!this.customerInvoiceDetail.isDiscountLine() && amount.isNegative()) {
                GlobalVariables.getMessageMap().putError("amount", "error.document.customerInvoiceDocument.invalidCustomerInvoiceDetailTotalAmount", new String[0]);
                return false;
            }
        }
        return true;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }

    public CustomerInvoiceDetail getCustomerInvoiceDetail() {
        return this.customerInvoiceDetail;
    }

    public void setCustomerInvoiceDetail(CustomerInvoiceDetail customerInvoiceDetail) {
        this.customerInvoiceDetail = customerInvoiceDetail;
    }
}

