/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CollectionActivityReport;
import org.kuali.kfs.module.ar.businessobject.CollectionActivityType;
import org.kuali.kfs.module.ar.businessobject.CollectionEvent;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.CollectionActivityReportService;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.transaction.annotation.Transactional;

public class CollectionActivityReportServiceImpl
implements CollectionActivityReportService {
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;
    protected BusinessObjectService businessObjectService;
    protected DateTimeService dateTimeService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected PersonService personService;
    private static final Logger LOG = Logger.getLogger(CollectionActivityReportServiceImpl.class);

    @Override
    @Transactional
    public List<CollectionActivityReport> filterEventsForCollectionActivity(Map lookupFormFields) {
        Collection<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocs;
        ArrayList<CollectionActivityReport> displayList = new ArrayList<CollectionActivityReport>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        String collectorPrincName = (String)lookupFormFields.get("collector.principalName");
        String collector = (String)lookupFormFields.get("principalId");
        String proposalNumber = (String)lookupFormFields.get("proposalNumber");
        String agencyNumber = (String)lookupFormFields.get("agencyNumber");
        String invoiceNumber = (String)lookupFormFields.get("invoiceNumber");
        String accountNumber = (String)lookupFormFields.get("accountNumber");
        String activityType = (String)lookupFormFields.get("activityType");
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Collection)this.getFinancialSystemDocumentService().getSuccessfulDocumentStatuses(), (String)"|"));
        fieldValues.put("documentHeader.workflowDocumentTypeName", "CINV");
        if (!StringUtils.isBlank((String)proposalNumber)) {
            fieldValues.put("proposalNumber", proposalNumber);
        }
        if (!StringUtils.isBlank((String)invoiceNumber)) {
            fieldValues.put("documentNumber", invoiceNumber);
        }
        if (!StringUtils.isBlank((String)accountNumber)) {
            fieldValues.put("sourceAccountingLines.accountNumber", accountNumber);
        }
        if (!CollectionUtils.isEmpty(contractsGrantsInvoiceDocs = this.contractsGrantsInvoiceDocumentService.retrieveAllCGInvoicesByCriteria(fieldValues))) {
            Person collUser;
            String collectorPrincipalId = null;
            if (StringUtils.isNotEmpty((String)collectorPrincName.trim()) && ObjectUtils.isNotNull((Object)(collUser = this.personService.getPersonByPrincipalName(collectorPrincName)))) {
                collectorPrincipalId = collUser.getPrincipalId();
            }
            Set<String> agencyNumbers = null;
            if (!StringUtils.isBlank((String)agencyNumber)) {
                agencyNumbers = this.getMatchingAgencyNumbers(agencyNumber);
            }
            Iterator<ContractsGrantsInvoiceDocument> iter = contractsGrantsInvoiceDocs.iterator();
            while (iter.hasNext()) {
                ContractsGrantsInvoiceDocument document = iter.next();
                if (!this.canDocumentBeViewed(document, collectorPrincipalId)) {
                    iter.remove();
                    continue;
                }
                if (CollectionUtils.isEmpty(agencyNumbers) || this.matchesAgencyNumber(document, agencyNumbers)) continue;
                iter.remove();
            }
        }
        if (!CollectionUtils.isEmpty(contractsGrantsInvoiceDocs)) {
            for (ContractsGrantsInvoiceDocument cgInvoiceDocument : contractsGrantsInvoiceDocs) {
                String accountNum;
                List<CollectionEvent> events = cgInvoiceDocument.getCollectionEvents();
                List details = cgInvoiceDocument.getSourceAccountingLines();
                String string = accountNum = !CollectionUtils.isEmpty((Collection)details) && !ObjectUtils.isNull(details.get(0)) ? ((CustomerInvoiceDetail)details.get(0)).getAccountNumber() : "";
                if (!CollectionUtils.isNotEmpty(events)) continue;
                for (CollectionEvent event : events) {
                    if (!StringUtils.isBlank((String)activityType) && !StringUtils.equals((String)event.getActivityCode(), (String)activityType)) continue;
                    CollectionActivityReport collectionActivityReport = new CollectionActivityReport();
                    collectionActivityReport.setAccountNumber(accountNum);
                    this.convertEventToCollectionActivityReport(collectionActivityReport, event);
                    displayList.add(collectionActivityReport);
                }
            }
        }
        return displayList;
    }

    protected boolean canDocumentBeViewed(ContractsGrantsInvoiceDocument document, String collectorPrincipalId) {
        Person user = GlobalVariables.getUserSession().getPerson();
        return (StringUtils.isBlank((String)collectorPrincipalId) || this.contractsGrantsInvoiceDocumentService.canViewInvoice(document, collectorPrincipalId)) && this.contractsGrantsInvoiceDocumentService.canViewInvoice(document, user.getPrincipalId());
    }

    protected Set<String> getMatchingAgencyNumbers(String agencyNumberLookup) {
        HashSet<String> matchingAgencyNumbers = new HashSet<String>();
        HashMap<String, String> agencyLookupFields = new HashMap<String, String>();
        agencyLookupFields.put("agencyNumber", agencyNumberLookup);
        List awards = this.getContractsAndGrantsModuleBillingService().lookupAwards(agencyLookupFields, true);
        if (!CollectionUtils.isEmpty((Collection)awards)) {
            for (ContractsAndGrantsAward award : awards) {
                if (!(award instanceof ContractsAndGrantsBillingAward)) continue;
                matchingAgencyNumbers.add(((ContractsAndGrantsBillingAward)award).getAgencyNumber());
            }
        }
        if (matchingAgencyNumbers.isEmpty()) {
            return null;
        }
        return matchingAgencyNumbers;
    }

    protected boolean matchesAgencyNumber(ContractsGrantsInvoiceDocument document, Set<String> agencyNumbers) {
        if (!(ObjectUtils.isNull((Object)document) || ObjectUtils.isNull((Object)document.getInvoiceGeneralDetail().getAward()) || StringUtils.isBlank((String)document.getInvoiceGeneralDetail().getAward().getAgencyNumber()))) {
            String documentAgencyNumber = document.getInvoiceGeneralDetail().getAward().getAgencyNumber();
            return agencyNumbers.contains(documentAgencyNumber);
        }
        return false;
    }

    protected CollectionActivityReport convertEventToCollectionActivityReport(CollectionActivityReport collectionActivityReport, CollectionEvent collectionEvent) {
        if (ObjectUtils.isNull((Object)((Object)collectionEvent))) {
            LOG.error((Object)"an invalid(null) argument was given");
            throw new IllegalArgumentException("an invalid(null) argument was given");
        }
        collectionActivityReport.setEventId(collectionEvent.getId());
        collectionActivityReport.setInvoiceNumber(collectionEvent.getInvoiceNumber());
        collectionActivityReport.setActivityDate(collectionEvent.getActivityDate());
        CollectionActivityType collectionActivityType = collectionEvent.getCollectionActivityType();
        if (ObjectUtils.isNotNull((Object)((Object)collectionActivityType))) {
            collectionActivityReport.setActivityType(collectionActivityType.getActivityDescription());
        }
        collectionActivityReport.setActivityComment(collectionEvent.getActivityText());
        collectionActivityReport.setFollowupDate(collectionEvent.getFollowupDate());
        collectionActivityReport.setProposalNumber(collectionEvent.getInvoiceDocument().getInvoiceGeneralDetail().getProposalNumber());
        collectionActivityReport.setCompletedDate(collectionEvent.getCompletedDate());
        String userPrincId = collectionEvent.getUserPrincipalId();
        Person person = this.personService.getPerson(userPrincId);
        if (ObjectUtils.isNotNull((Object)person)) {
            collectionActivityReport.setUserPrincipalId(person.getName());
        }
        if (ObjectUtils.isNotNull((Object)collectionEvent.getInvoiceDocument())) {
            collectionActivityReport.setChartOfAccountsCode(collectionEvent.getInvoiceDocument().getBillByChartOfAccountCode());
        }
        if (ObjectUtils.isNotNull((Object)((Object)collectionEvent.getInvoiceDocument().getInvoiceGeneralDetail())) && ObjectUtils.isNotNull((Object)collectionEvent.getInvoiceDocument().getInvoiceGeneralDetail().getAward()) && ObjectUtils.isNotNull((Object)collectionEvent.getInvoiceDocument().getInvoiceGeneralDetail().getAward().getAgency())) {
            collectionActivityReport.setAgencyNumber(collectionEvent.getInvoiceDocument().getInvoiceGeneralDetail().getAward().getAgency().getAgencyNumber());
            collectionActivityReport.setAgencyName(collectionEvent.getInvoiceDocument().getInvoiceGeneralDetail().getAward().getAgency().getFullName());
        }
        return collectionActivityReport;
    }

    @NonTransactional
    public PersonService getPersonService() {
        return this.personService;
    }

    @NonTransactional
    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public FinancialSystemDocumentService getFinancialSystemDocumentService() {
        return this.financialSystemDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        return this.contractsAndGrantsModuleBillingService;
    }

    public void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    @NonTransactional
    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    @NonTransactional
    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }
}

