/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.report.service.FederalFinancialReportService;

public class FederalFinancialReportServiceImpl
implements FederalFinancialReportService {
    @Override
    public String validate(String federalForm, String proposalNumber, String fiscalYear, String reportingPeriod, String agencyNumber) {
        if (StringUtils.isNotEmpty((String)federalForm)) {
            if (StringUtils.equals((String)"425", (String)federalForm)) {
                if (ObjectUtils.isNull((Object)proposalNumber)) {
                    return "Please enter a proposal Number for SF425.";
                }
                if (StringUtils.isEmpty((String)fiscalYear) || StringUtils.isEmpty((String)reportingPeriod)) {
                    return "Enter both period and fiscal year.";
                }
            } else if (StringUtils.equals((String)"425A", (String)federalForm)) {
                if (ObjectUtils.isNull((Object)agencyNumber)) {
                    return "Please enter an Agency for SF425A.";
                }
                if (StringUtils.isEmpty((String)fiscalYear) || StringUtils.isEmpty((String)reportingPeriod)) {
                    return "Enter both period and fiscal year.";
                }
            }
            return "";
        }
        return "Please select a Financial Form to generate.";
    }

    @Override
    public String getUrlForPrintInvoice(String basePath, String docId, String period, String year, String agencyNumber, String formType, String methodToCall) {
        String baseUrl = basePath + "/" + "arFederalFinancialReport.do";
        Properties parameters = new Properties();
        parameters.put("methodToCall", methodToCall);
        if (StringUtils.isNotEmpty((String)formType)) {
            parameters.put("federalForm", formType);
        }
        if (StringUtils.isNotEmpty((String)agencyNumber)) {
            parameters.put("agencyNumber", agencyNumber);
        }
        if (StringUtils.isNotEmpty((String)period)) {
            parameters.put("reportingPeriod", period);
        }
        if (StringUtils.isNotEmpty((String)year)) {
            parameters.put("fiscalYear", year);
        }
        if (StringUtils.isNotEmpty((String)docId)) {
            parameters.put("docId", docId);
            parameters.put("command", "displayDocSearchView");
        }
        return UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
    }
}

