/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.module.ar.batch.vo.CustomerInvoiceWriteoffBatchVO;
import org.kuali.kfs.sys.exception.XmlErrorHandler;
import org.xml.sax.ErrorHandler;

public class CustomerInvoiceWriteoffBatchDigesterTest
extends TestCase {
    private static final String XML_SAMPLE_DIRECTORY = "org/kuali/kfs/module/ar/batch/sample/";
    private static final String XML_SAMPLE_FILE = "CustomerInvoiceWriteoffBatch-Sample-Good.xml";
    private static final String SCHEMA_DIRECTORY = "work/web-root/static/xsd/ar/";
    private static final String SCHEMA_FILE = "customerInvoiceWriteoffBatch.xsd";
    private static final String DIGESTER_RULE_DIRECTORY = "org/kuali/kfs/module/ar/batch/digester/";
    private static final String DIGESTER_RULE_FILE = "customerInvoiceWriteoffBatchDigesterRules.xml";
    private CustomerInvoiceWriteoffBatchVO parsedBatchVO;

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testNothing() {
    }

    public void NORUN_testCustomerInvoiceWriteoffBatchDigesterRules() throws Exception {
        Digester digester = this.buildDigester("work/web-root/static/xsd/ar/customerInvoiceWriteoffBatch.xsd", "org/kuali/kfs/module/ar/batch/digester/customerInvoiceWriteoffBatchDigesterRules.xml");
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("org/kuali/kfs/module/ar/batch/sample/CustomerInvoiceWriteoffBatch-Sample-Good.xml");
        byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
        ByteArrayInputStream sampleCustomerBatchFile = new ByteArrayInputStream(byteArray);
        Object parsedObject = null;
        try {
            parsedObject = digester.parse((InputStream)sampleCustomerBatchFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing xml contents: " + e.getMessage(), e);
        }
        CustomerInvoiceWriteoffBatchDigesterTest.assertNotNull((String)"Parsed object should not be null.", (Object)parsedObject);
        CustomerInvoiceWriteoffBatchDigesterTest.assertTrue((String)("Parsed object class [" + parsedObject.getClass().toString() + "] should be assignable to a List."), (boolean)(parsedObject instanceof CustomerInvoiceWriteoffBatchVO));
        this.parsedBatchVO = (CustomerInvoiceWriteoffBatchVO)parsedObject;
        CustomerInvoiceWriteoffBatchDigesterTest.assertTrue((String)"SubmittedBy PersonUserID should not be blank.", (boolean)StringUtils.isNotBlank((CharSequence)this.parsedBatchVO.getSubmittedByPrincipalName()));
        CustomerInvoiceWriteoffBatchDigesterTest.assertTrue((String)"SubmittedOn should not be blank.", (boolean)StringUtils.isNotBlank((CharSequence)this.parsedBatchVO.getSubmittedOn()));
        CustomerInvoiceWriteoffBatchDigesterTest.assertNotNull((String)"InvoiceNumbers should not be null.", (Object)this.parsedBatchVO.getInvoiceNumbers());
        CustomerInvoiceWriteoffBatchDigesterTest.assertFalse((String)"InvoiceNumbers should not be empty.", (boolean)this.parsedBatchVO.getInvoiceNumbers().isEmpty());
        CustomerInvoiceWriteoffBatchDigesterTest.assertTrue((String)"InvoiceNumbers should have 3 elements in the set.", (this.parsedBatchVO.getInvoiceNumbers().size() == 3 ? 1 : 0) != 0);
    }

    private Digester buildDigester(String schemaLocation, String digestorRulesFileName) {
        Digester digester = new Digester();
        digester.setNamespaceAware(false);
        digester.setValidating(true);
        digester.setErrorHandler((ErrorHandler)new XmlErrorHandler());
        digester.setSchema(schemaLocation);
        Rules rules = this.loadRules(digestorRulesFileName);
        digester.setRules(rules);
        return digester;
    }

    private Rules loadRules(String digestorRulesFileName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL rulesUrl = classLoader.getResource(digestorRulesFileName);
        if (rulesUrl == null) {
            throw new RuntimeException("unable to locate digester rules file " + digestorRulesFileName);
        }
        Digester digester = DigesterLoader.createDigester((URL)rulesUrl);
        return digester.getRules();
    }
}

