/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.core;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kfs.kns.lookup.LookupableHelperService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.core.ArCoreTestUtils;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.report.service.AccountsReceivableReportService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.lookup.LookupableSpringContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;

@ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
public class ReportingLoadTest
extends KualiTestBase {
    private static final int INVOICES_TO_CREATE = 2;
    private static final String PRINT_SETTING = "Q";
    private static final String INITIATOR = "khuntley";
    private static final int[] INVOICE_AGES = new int[]{-5, -18, -35, -65, -95, -125};
    private static final String AGING_RPT_LOOKUPABLE_SERVICE = "arCustomerAgingReportLookupable";
    private static final String AGING_RPT_OPTION = "PROCESSING ORGANIZATION";
    private static final String AGING_RPT_PROCESSING_OR_BILLING_CHART = "UA";
    private static final String AGING_RPT_ORG = "VPIT";
    private static final String AGING_RPT_ACCOUNT_CHART = "BL";
    private static final String AGING_RPT_ACCOUNT = "1031400";
    private DocumentService documentService;
    private AccountsReceivableReportService reportService;
    private ConfigurationService kualiConfigService;
    private DateTimeService dateTimeService;
    private List<String> invoicesCreated;

    protected void setUp() throws Exception {
        super.setUp();
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.reportService = (AccountsReceivableReportService)SpringContext.getBean(AccountsReceivableReportService.class);
        this.kualiConfigService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.invoicesCreated = new ArrayList<String>();
    }

    public void testNothingToStopTestFailureReport() {
        ReportingLoadTest.assertTrue((boolean)true);
    }

    public void createManyInvoicesForPrintTesting() throws Exception {
        this.createManyInvoiceReadyForAgingReport();
    }

    public void runCustomerOpenReport() throws Exception {
        this.createManyInvoiceReadyForAgingReport();
        List reports = this.reportService.generateStatementByBillingOrg(AGING_RPT_PROCESSING_OR_BILLING_CHART, AGING_RPT_ORG, "S", "N");
        ReportingLoadTest.assertNotNull((String)"Reports list should not be null.", (Object)reports);
        ReportingLoadTest.assertFalse((String)"Reports should not be empty.", (boolean)reports.isEmpty());
    }

    public void customerAgingReport() throws Exception {
        this.createManyInvoiceReadyForAgingReport();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("backLocation", "");
        fieldValues.put("docFormKey", "");
        fieldValues.put("reportOption", AGING_RPT_OPTION);
        fieldValues.put("accountChartCode", AGING_RPT_ACCOUNT_CHART);
        fieldValues.put("accountNumber", AGING_RPT_ACCOUNT);
        fieldValues.put("processingOrBillingChartCode", AGING_RPT_PROCESSING_OR_BILLING_CHART);
        fieldValues.put("organizationCode", AGING_RPT_ORG);
        java.util.Date today = this.dateTimeService.getCurrentDate();
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        fieldValues.put("reportRunDate", format.format(today));
        LookupableHelperService lookupableHelperService = LookupableSpringContext.getLookupable((String)AGING_RPT_LOOKUPABLE_SERVICE).getLookupableHelperService();
        List searchResults = lookupableHelperService.getSearchResults(fieldValues);
        ReportingLoadTest.assertTrue((String)"Search results should not be null.", (searchResults != null ? 1 : 0) != 0);
        ReportingLoadTest.assertTrue((String)"Search results should not be empty.", (!searchResults.isEmpty() ? 1 : 0) != 0);
    }

    public void customerInvoiceReportPrinting() throws Exception {
        this.createManyInvoicesReadyForPrinting();
        List reports = this.reportService.generateInvoicesByInitiator(INITIATOR, null);
        ReportingLoadTest.assertTrue((String)"List of reports should not be empty.", (!reports.isEmpty() ? 1 : 0) != 0);
        this.concatenateReportsIntoOnePdf(reports);
    }

    private String getOutputPathAndFileName() {
        String reportsDirectory = this.kualiConfigService.getPropertyValueAsString("reports.directory");
        StringBuilder fileName = new StringBuilder();
        fileName.append(reportsDirectory + File.separator);
        fileName.append("ar" + File.separator);
        fileName.append("PERFTESTING-ARINVOICES-khuntley.pdf");
        return fileName.toString();
    }

    private void concatenateReportsIntoOnePdf(List<File> reports) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(this.getOutputPathAndFileName());
        int pageOffset = 0;
        ArrayList master = new ArrayList();
        int f = 0;
        Document document = null;
        PdfCopy writer = null;
        Iterator<File> itr = reports.iterator();
        while (itr.hasNext()) {
            String reportName = itr.next().getAbsolutePath();
            PdfReader reader = new PdfReader(reportName);
            reader.consolidateNamedDestinations();
            int n = reader.getNumberOfPages();
            List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
            if (bookmarks != null) {
                if (pageOffset != 0) {
                    SimpleBookmark.shiftPageNumbers((List)bookmarks, (int)pageOffset, null);
                }
                master.addAll(bookmarks);
            }
            pageOffset += n;
            if (f == 0) {
                document = new Document(reader.getPageSizeWithRotation(1));
                writer = new PdfCopy(document, (OutputStream)fileOutputStream);
                document.open();
            }
            int i = 0;
            while (i < n) {
                PdfImportedPage page = writer.getImportedPage(reader, ++i);
                writer.addPage(page);
            }
            writer.freeReader(reader);
            ++f;
        }
        if (!master.isEmpty()) {
            writer.setOutlines(master);
        }
        document.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private void createManyInvoiceReadyForAgingReport() throws Exception {
        int typeOfInvoice = 1;
        int ageOfInvoice = 0;
        for (int i = 0; i < 2; ++i) {
            CustomerInvoiceDocument document = this.createScenarioInvoice(typeOfInvoice);
            this.invoicesCreated.add(document.getDocumentNumber());
            document.setBillingDate(this.dateXDaysAgo(ageOfInvoice));
            this.documentService.blanketApproveDocument((org.kuali.kfs.krad.document.Document)document, "BlanketApproved by performance testing script.", null);
            WorkflowTestUtils.waitForDocumentApproval((String)document.getDocumentNumber());
            typeOfInvoice = typeOfInvoice == 5 ? 1 : ++typeOfInvoice;
            if (ageOfInvoice == INVOICE_AGES.length - 1) {
                ageOfInvoice = 0;
                continue;
            }
            ++ageOfInvoice;
        }
    }

    private Date dateXDaysAgo(int daysAgo) {
        return new Date(DateUtils.addDays((java.util.Date)this.dateTimeService.getCurrentSqlDate(), (int)INVOICE_AGES[daysAgo]).getTime());
    }

    private void createManyInvoicesReadyForPrinting() throws Exception {
        int typeOfInvoice = 1;
        for (int i = 0; i < 2; ++i) {
            CustomerInvoiceDocument document = this.createScenarioInvoice(typeOfInvoice);
            this.invoicesCreated.add(document.getDocumentNumber());
            this.documentService.blanketApproveDocument((org.kuali.kfs.krad.document.Document)document, "BlanketApproved by performance testing script.", null);
            WorkflowTestUtils.waitForDocumentApproval((String)document.getDocumentNumber());
            if (typeOfInvoice == 5) {
                typeOfInvoice = 1;
                continue;
            }
            ++typeOfInvoice;
        }
    }

    private CustomerInvoiceDocument createScenarioInvoice(int scenarioNumber) throws Exception {
        CustomerInvoiceDocument document;
        switch (scenarioNumber) {
            case 1: {
                document = ArCoreTestUtils.newInvoiceDocumentOneLine();
                document.setPrintInvoiceIndicator(PRINT_SETTING);
                break;
            }
            case 2: {
                document = ArCoreTestUtils.newInvoiceDocumentTwoLines();
                document.setPrintInvoiceIndicator(PRINT_SETTING);
                break;
            }
            case 3: {
                document = ArCoreTestUtils.newInvoiceDocumentOneLineDiscounted();
                document.setPrintInvoiceIndicator(PRINT_SETTING);
                break;
            }
            case 4: {
                document = ArCoreTestUtils.newInvoiceDocumentTwoLinesOneIsDiscounted();
                document.setPrintInvoiceIndicator(PRINT_SETTING);
                break;
            }
            case 5: {
                document = ArCoreTestUtils.newInvoiceDocumentTwoLinesDiscounted();
                break;
            }
            default: {
                throw new RuntimeException("An invalid scenarioNumber was passed in.");
            }
        }
        document.setPrintInvoiceIndicator(PRINT_SETTING);
        return document;
    }
}

