/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.OffsetDefinition;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceBillFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceMilestoneFixture;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public abstract class CGInvoiceDocumentTestBase
extends KualiTestBase {
    BusinessObjectService boService;
    DocumentService documentService;
    ContractsGrantsInvoiceCreateDocumentService cginService;
    ContractsAndGrantsBillingAward award;
    ContractsGrantsInvoiceDocument document;

    @ConfigureContext(session=UserNameFixture.khuntley)
    protected void setUp() throws Exception {
        Date start;
        super.setUp();
        this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.cginService = (ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class);
        this.award = ARAwardFixture.CG_AWARD_INV_ACCOUNT.createAward();
        this.award = ARAwardFixture.CG_AWARD_INV_ACCOUNT.setAgencyFromFixture((Award)this.award);
        this.document = (ContractsGrantsInvoiceDocument)this.documentService.getNewDocument("CINV");
        Date stop = start = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
        stop.setYear(start.getYear() + 1);
        if (ObjectUtils.isNotNull((Object)this.award)) {
            for (ContractsAndGrantsBillingAwardAccount awardAccount : this.award.getActiveAwardAccounts()) {
                if (awardAccount.isFinalBilledIndicator()) continue;
                this.boService.save((PersistableBusinessObject)((AwardAccount)awardAccount));
                ArrayList<ContractsAndGrantsBillingAwardAccount> list = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
                list.clear();
                list.add(awardAccount);
                HashMap<String, Object> criteria = new HashMap<String, Object>();
                criteria.put("accountNumber", awardAccount.getAccountNumber());
                criteria.put("chartOfAccountsCode", awardAccount.getChartOfAccountsCode());
                Account acct = (Account)this.boService.findByPrimaryKey(Account.class, criteria);
                String coaCode = acct.getChartOfAccountsCode();
                String orgCode = acct.getOrganizationCode();
                criteria.clear();
                Integer currentYear = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
                criteria.put("universityFiscalYear", currentYear);
                criteria.put("chartOfAccountsCode", coaCode);
                criteria.put("organizationCode", orgCode);
                OrganizationAccountingDefault organizationAccountingDefault = (OrganizationAccountingDefault)this.boService.findByPrimaryKey(OrganizationAccountingDefault.class, criteria);
                if (ObjectUtils.isNull((Object)organizationAccountingDefault)) {
                    organizationAccountingDefault = new OrganizationAccountingDefault();
                    organizationAccountingDefault.setChartOfAccountsCode(coaCode);
                    organizationAccountingDefault.setOrganizationCode(orgCode);
                    organizationAccountingDefault.setUniversityFiscalYear(currentYear);
                    this.boService.save((PersistableBusinessObject)organizationAccountingDefault);
                }
                criteria.clear();
                criteria.put("universityFiscalYear", currentYear);
                criteria.put("chartOfAccountsCode", coaCode);
                criteria.put("financialBalanceTypeCode", "AC");
                criteria.put("financialDocumentTypeCode", "CINV");
                OffsetDefinition offset = (OffsetDefinition)this.boService.findByPrimaryKey(OffsetDefinition.class, criteria);
                if (ObjectUtils.isNull((Object)offset)) {
                    offset = new OffsetDefinition();
                    offset.setChartOfAccountsCode(coaCode);
                    offset.setUniversityFiscalYear(currentYear);
                    offset.setFinancialObjectCode("8000");
                    offset.setFinancialDocumentTypeCode("CINV");
                    offset.setFinancialBalanceTypeCode("AC");
                    this.boService.save((PersistableBusinessObject)offset);
                }
                ArrayList errorMessages = new ArrayList();
                this.document = this.cginService.createCGInvoiceDocumentByAwardInfo(this.award, list, coaCode, orgCode, errorMessages, null, null);
                for (InvoiceAddressDetail invoiceAddressDetail : this.document.getInvoiceAddressDetails()) {
                    invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
                    invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
                }
            }
        }
    }

    public ContractsGrantsInvoiceDocument getDocument() throws Exception {
        if (ObjectUtils.isNull((Object)this.document)) {
            this.setUp();
        }
        return this.document;
    }

    public void setDocument(ContractsGrantsInvoiceDocument document) {
        this.document = document;
    }

    protected void setupBills(String documentNumber, String proposalNumber, boolean billed) {
        ArrayList<InvoiceBill> invoiceBills = new ArrayList<InvoiceBill>();
        InvoiceBill invBill_1 = InvoiceBillFixture.INV_BILL_1.createInvoiceBill();
        invBill_1.setDocumentNumber(documentNumber);
        this.boService.save((PersistableBusinessObject)invBill_1);
        invoiceBills.add(invBill_1);
        this.document.setInvoiceBills(invoiceBills);
        Bill bill = new Bill();
        bill.setProposalNumber(proposalNumber);
        bill.setBillNumber(invBill_1.getBillNumber());
        bill.setBillDescription(invBill_1.getBillDescription());
        bill.setBillIdentifier(invBill_1.getBillIdentifier());
        bill.setBillDate(invBill_1.getBillDate());
        bill.setEstimatedAmount(invBill_1.getEstimatedAmount());
        bill.setBilled(billed);
        bill.setAward(this.document.getInvoiceGeneralDetail().getAward());
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule.setProposalNumber(proposalNumber);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill);
        predeterminedBillingSchedule.setBills(bills);
        this.boService.save((PersistableBusinessObject)predeterminedBillingSchedule);
        this.boService.save((PersistableBusinessObject)bill);
    }

    protected void setupMilestones(String documentNumber, String proposalNumber, boolean billed) {
        ArrayList<InvoiceMilestone> invoiceMilestones = new ArrayList<InvoiceMilestone>();
        InvoiceMilestone invMilestone_1 = InvoiceMilestoneFixture.INV_MLSTN_1.createInvoiceMilestone();
        invMilestone_1.setDocumentNumber(documentNumber);
        this.boService.save((PersistableBusinessObject)invMilestone_1);
        invoiceMilestones.add(invMilestone_1);
        this.document.setInvoiceMilestones(invoiceMilestones);
        Milestone milestone = new Milestone();
        milestone.setProposalNumber(proposalNumber);
        milestone.setMilestoneNumber(invMilestone_1.getMilestoneNumber());
        milestone.setMilestoneIdentifier(invMilestone_1.getMilestoneIdentifier());
        milestone.setMilestoneDescription(invMilestone_1.getMilestoneDescription());
        milestone.setMilestoneAmount(invMilestone_1.getMilestoneAmount());
        milestone.setMilestoneActualCompletionDate(invMilestone_1.getMilestoneActualCompletionDate());
        milestone.setMilestoneExpectedCompletionDate(invMilestone_1.getMilestoneActualCompletionDate());
        milestone.setBilled(billed);
        milestone.setAward(this.document.getInvoiceGeneralDetail().getAward());
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        milestoneSchedule.setProposalNumber(proposalNumber);
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(milestone);
        milestoneSchedule.setMilestones(milestones);
        this.boService.save((PersistableBusinessObject)milestoneSchedule);
        this.boService.save((PersistableBusinessObject)milestone);
    }
}

