/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.document.CGInvoiceDocumentTestBase;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.impl.FinalBilledIndicatorValidation;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.wklykins)
public class FinalBilledIndicatorTest
extends CGInvoiceDocumentTestBase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.document.getInvoiceGeneralDetail().setFinalBillIndicator(true);
        this.documentService.saveDocument((Document)this.document);
        this.document.setInvoiceSuspensionCategories(Collections.EMPTY_LIST);
        ((ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class)).updateLastBilledDate(this.document);
    }

    public void testFinalInvoiceDocumentValidation() throws WorkflowException {
        ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        this.document.getDocumentHeader().getWorkflowDocument().switchPrincipal(UserNameFixture.wcorbitt.getPerson().getPrincipalId());
        this.documentService.routeDocument((Document)this.document, "route test doc", new ArrayList());
        FinalBilledIndicatorDocument firDocument = (FinalBilledIndicatorDocument)this.documentService.getNewDocument(FinalBilledIndicatorDocument.class);
        firDocument.getDocumentHeader().setDocumentDescription("Unit Test Document");
        FinalBilledIndicatorEntry entry = new FinalBilledIndicatorEntry();
        entry.setInvoiceDocumentNumber(this.document.getDocumentNumber());
        firDocument.addInvoiceEntry(entry);
        this.documentService.saveDocument((Document)firDocument);
        FinalBilledIndicatorTest.assertTrue((boolean)FinalBilledIndicatorValidation.validateDocument((Document)firDocument));
    }

    public void testInvoiceReversal() throws WorkflowException {
        ContractsAndGrantsBillingAwardAccount awardAccount;
        HashMap<String, String> mapKey;
        FinalBilledIndicatorEntry entry = new FinalBilledIndicatorEntry();
        entry.setInvoiceDocumentNumber(this.document.getDocumentNumber());
        FinalBilledIndicatorDocument firDocument = (FinalBilledIndicatorDocument)this.documentService.getNewDocument(FinalBilledIndicatorDocument.class);
        firDocument.getDocumentHeader().setDocumentDescription("Unit Test Document");
        firDocument.addInvoiceEntry(entry);
        this.documentService.saveDocument((Document)firDocument);
        for (InvoiceAccountDetail id : this.document.getAccountDetails()) {
            mapKey = new HashMap<String, String>();
            mapKey.put("accountNumber", id.getAccountNumber());
            mapKey.put("chartOfAccountsCode", id.getChartOfAccountsCode());
            mapKey.put("proposalNumber", this.document.getInvoiceGeneralDetail().getProposalNumber());
            awardAccount = (ContractsAndGrantsBillingAwardAccount)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAwardAccount.class, mapKey);
            FinalBilledIndicatorTest.assertTrue((boolean)awardAccount.isFinalBilledIndicator());
        }
        firDocument.updateContractsGrantsInvoiceDocument();
        this.document = (ContractsGrantsInvoiceDocument)this.documentService.getByDocumentHeaderId(this.document.getDocumentNumber());
        FinalBilledIndicatorTest.assertFalse((boolean)this.document.getInvoiceGeneralDetail().isFinalBillIndicator());
        for (InvoiceAccountDetail id : this.document.getAccountDetails()) {
            mapKey = new HashMap();
            mapKey.put("accountNumber", id.getAccountNumber());
            mapKey.put("chartOfAccountsCode", id.getChartOfAccountsCode());
            mapKey.put("proposalNumber", this.document.getInvoiceGeneralDetail().getProposalNumber());
            awardAccount = (ContractsAndGrantsBillingAwardAccount)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAwardAccount.class, mapKey);
            FinalBilledIndicatorTest.assertFalse((boolean)awardAccount.isFinalBilledIndicator());
        }
    }
}

