/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@ConfigureContext(session=UserNameFixture.wklykins)
public class ContractsGrantsAgingReportServiceTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(ContractsGrantsAgingReportServiceTest.class);
    private static final String CUSTOMER_NUMBER = "ABB2";
    private static final String CUSTOMER_NAME = "WOODS CORPORATION";
    ContractsGrantsAgingReportService contractsGrantsAgingReportService;

    public void setUp() throws Exception {
        super.setUp();
        String chartCode = "BL";
        String orgCode = "SRS";
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAward();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_1.createAwardAccount();
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        award.getActiveAwardAccounts().clear();
        award.getActiveAwardAccounts().add(awardAccount_1);
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.setAgencyFromFixture((Award)award);
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = ((ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class)).createCGInvoiceDocumentByAwardInfo(award, awardAccounts, chartCode, orgCode, errorMessages, null, null);
        FinancialSystemDocumentHeader documentHeader = cgInvoice.getFinancialSystemDocumentHeader();
        cgInvoice.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("A");
        cgInvoice.getAccountsReceivableDocumentHeader().setCustomerNumber(CUSTOMER_NUMBER);
        cgInvoice.getAccountsReceivableDocumentHeader().setDocumentHeader(documentHeader);
        cgInvoice.setBillingDate(new Date(new java.util.Date().getTime()));
        cgInvoice.getInvoiceGeneralDetail().setAward(award);
        cgInvoice.setOpenInvoiceIndicator(true);
        cgInvoice.setCustomerName(CUSTOMER_NAME);
        for (InvoiceAddressDetail invoiceAddressDetail : cgInvoice.getInvoiceAddressDetails()) {
            invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
            invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        }
        documentService.saveDocument((Document)cgInvoice);
        cgInvoice.getAccountsReceivableDocumentHeader().refresh();
        this.contractsGrantsAgingReportService = (ContractsGrantsAgingReportService)SpringContext.getBean(ContractsGrantsAgingReportService.class);
        OrganizationOptions organizationOptions = new OrganizationOptions();
        organizationOptions.setChartOfAccountsCode(chartCode);
        organizationOptions.setOrganizationCode(orgCode);
        organizationOptions.setProcessingChartOfAccountCode(chartCode);
        organizationOptions.setProcessingOrganizationCode(orgCode);
        organizationOptions.setCgBillerIndicator(true);
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)organizationOptions);
        HashMap<String, String> qualification = new HashMap<String, String>(3);
        qualification.put("billingChartOfAccountsCode", cgInvoice.getBillByChartOfAccountCode());
        qualification.put("billingOrganizationCode", cgInvoice.getBilledByOrganizationCode());
        RoleService roleService = KimApiServiceLocator.getRoleService();
        Person user = GlobalVariables.getUserSession().getPerson();
        roleService.assignPrincipalToRole(user.getPrincipalId(), "KFS-AR", "CGB Collector", qualification);
    }

    public void testFilterContractsGrantsAgingReport() throws ParseException {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("customerNumber", CUSTOMER_NUMBER);
        Map customerMap = this.contractsGrantsAgingReportService.filterContractsGrantsAgingReport(fieldValues, null, null);
        ContractsGrantsAgingReportServiceTest.assertNotNull((Object)customerMap);
    }
}

