/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsBillingAwardVerificationServiceImpl;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardOrganization;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ContractsGrantsBillingAwardVerificationServiceTest {
    private ContractsGrantsBillingAwardVerificationServiceImpl cut;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocSvcMock;
    @Mock
    private UniversityDateService universityDateSvcMock;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new ContractsGrantsBillingAwardVerificationServiceImpl();
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocSvcMock);
        this.cut.setUniversityDateService(this.universityDateSvcMock);
    }

    private void executeIsChartAndOrgSetupForInvoicingTest(boolean hasPrimaryAwardOrganization, boolean hasProcessing, boolean hasOrganizationAccountingDefault, boolean hasSystemInformation, boolean expectedResult) {
        Award award = new Award();
        if (hasPrimaryAwardOrganization) {
            AwardOrganization primaryAwardOrganization = new AwardOrganization();
            primaryAwardOrganization.setChartOfAccountsCode("C1");
            primaryAwardOrganization.setOrganizationCode("11111");
            award.setPrimaryAwardOrganization(primaryAwardOrganization);
        }
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2015);
        if (hasProcessing) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.getProcessingFromBillingCodes("C1", "11111")).thenReturn(Arrays.asList("C2", "22222"));
        } else {
            Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.getProcessingFromBillingCodes("C1", "11111")).thenReturn(new ArrayList());
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", 2015);
        criteria.put("chartOfAccountsCode", "C1");
        criteria.put("organizationCode", "11111");
        if (hasOrganizationAccountingDefault) {
            Mockito.when((Object)this.boServiceMock.findByPrimaryKey(OrganizationAccountingDefault.class, criteria)).thenReturn((Object)new OrganizationAccountingDefault());
        } else {
            Mockito.when((Object)this.boServiceMock.findByPrimaryKey(OrganizationAccountingDefault.class, criteria)).thenReturn(null);
        }
        HashMap<String, Object> sysCriteria = new HashMap<String, Object>();
        sysCriteria.put("universityFiscalYear", 2015);
        sysCriteria.put("processingChartOfAccountCode", "C2");
        sysCriteria.put("processingOrganizationCode", "22222");
        if (hasSystemInformation) {
            Mockito.when((Object)this.boServiceMock.findByPrimaryKey(SystemInformation.class, sysCriteria)).thenReturn((Object)new SystemInformation());
        } else {
            Mockito.when((Object)this.boServiceMock.findByPrimaryKey(SystemInformation.class, sysCriteria)).thenReturn(null);
        }
        boolean result = this.cut.isChartAndOrgSetupForInvoicing((ContractsAndGrantsBillingAward)award);
        Assert.assertTrue((String)("Method should return " + expectedResult), (result == expectedResult ? 1 : 0) != 0);
    }

    @Test
    public void testChartAndOrgValid() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, true, true, true);
    }

    @Test
    public void testNoPrimaryAwardOrganization() {
        this.executeIsChartAndOrgSetupForInvoicingTest(false, true, true, true, false);
    }

    @Test
    public void testNoProcessingFromBillingCodes() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, false, true, true, false);
    }

    @Test
    public void testNoOrganizationAccountingDefault() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, false, true, false);
    }

    @Test
    public void testNoSystemInformation() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, true, false, false);
    }
}

