/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import java.util.ArrayList;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsCollectionActivityInvoiceDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsCollectionActivityDocument;
import org.kuali.kfs.module.ar.document.validation.impl.ContractsGrantsCollectionActivityDocumentRule;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ContractsGrantsCollectionActivityDocumentRuleTest
extends KualiTestBase {
    private DocumentService documentService;
    private ContractsGrantsCollectionActivityDocumentRule contractsGrantsCollectionActivityDocumentRule;
    private ContractsGrantsCollectionActivityDocument contractsGrantsCollectionActivityDocument;
    private static final String ACTIVITY_CODE = "LSTS";

    protected void setUp() throws Exception {
        super.setUp();
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.contractsGrantsCollectionActivityDocumentRule = new ContractsGrantsCollectionActivityDocumentRule();
        this.contractsGrantsCollectionActivityDocument = this.createCollectionActivityDocument();
    }

    protected void tearDown() throws Exception {
        this.documentService = null;
        this.contractsGrantsCollectionActivityDocumentRule = null;
        this.contractsGrantsCollectionActivityDocument = null;
    }

    private ContractsGrantsCollectionActivityDocument createCollectionActivityDocument() throws WorkflowException {
        ContractsGrantsCollectionActivityDocument contractsGrantsCollectionActivityDocument = (ContractsGrantsCollectionActivityDocument)this.documentService.getNewDocument(ContractsGrantsCollectionActivityDocument.class);
        contractsGrantsCollectionActivityDocument.getDocumentHeader().setDocumentDescription("Testing document");
        return contractsGrantsCollectionActivityDocument;
    }

    public void testValidateCollectionActivityDocument_True() {
        this.contractsGrantsCollectionActivityDocument.setProposalNumber("11");
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        ArrayList<ContractsGrantsCollectionActivityInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsCollectionActivityInvoiceDetail>();
        ContractsGrantsCollectionActivityInvoiceDetail invoiceDetail = new ContractsGrantsCollectionActivityInvoiceDetail();
        invoiceDetails.add(invoiceDetail);
        this.contractsGrantsCollectionActivityDocument.setInvoiceDetails(invoiceDetails);
        boolean result = this.contractsGrantsCollectionActivityDocumentRule.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        ContractsGrantsCollectionActivityDocumentRuleTest.assertTrue((boolean)result);
    }

    public void testValidateCollectionActivityDocument_False() {
        boolean result = this.contractsGrantsCollectionActivityDocumentRule.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        ContractsGrantsCollectionActivityDocumentRuleTest.assertFalse((boolean)result);
    }

    public void testValidateCollectionActivityDocument_False_missing_ProposalNumber() {
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        ArrayList<ContractsGrantsCollectionActivityInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsCollectionActivityInvoiceDetail>();
        ContractsGrantsCollectionActivityInvoiceDetail invoiceDetail = new ContractsGrantsCollectionActivityInvoiceDetail();
        invoiceDetails.add(invoiceDetail);
        this.contractsGrantsCollectionActivityDocument.setInvoiceDetails(invoiceDetails);
        boolean result = this.contractsGrantsCollectionActivityDocumentRule.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        ContractsGrantsCollectionActivityDocumentRuleTest.assertFalse((boolean)result);
    }

    public void testValidateCollectionActivityDocument_False_missing_InvoiceDetails() {
        this.contractsGrantsCollectionActivityDocument.setProposalNumber("11");
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        boolean result = this.contractsGrantsCollectionActivityDocumentRule.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        ContractsGrantsCollectionActivityDocumentRuleTest.assertFalse((boolean)result);
    }
}

