/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailAmountValidation;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerInvoiceDetailAmountValidationTest
extends KualiTestBase {
    private CustomerInvoiceDetailAmountValidation validation;

    protected void setUp() throws Exception {
        super.setUp();
        this.validation = new CustomerInvoiceDetailAmountValidation();
    }

    protected void tearDown() throws Exception {
        this.validation = null;
        super.tearDown();
    }

    public void testAmountNotEqualToZero_True() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailAmountValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testAmountNotEqualToZero_False() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_AMOUNT_EQUALS_ZERO.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailAmountValidationTest.assertFalse((boolean)this.validation.validate(null));
    }

    public void testAmountNotNegativeWhenReversalAndDiscount_True() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_POSITIVE_AMOUNT.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.REVERSAL_CIDOC.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailAmountValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testAmountNotNegativeWhenReversalAndDiscount_False() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.REVERSAL_CIDOC.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailAmountValidationTest.assertFalse((boolean)this.validation.validate(null));
    }

    public void testAmountNotPositiveWhenReversalAndNotDiscount_True() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.REVERSAL_CIDOC.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailAmountValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testAmountNotPositiveWhenReversalAndNotDiscount_False() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.REVERSAL_CIDOC.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailAmountValidationTest.assertFalse((boolean)this.validation.validate(null));
    }

    public void testAmountNotPositiveWhenNotReversalAndDiscount_True() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailAmountValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testAmountNotPositiveWhenNotReversalAndDiscount_False() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_POSITIVE_AMOUNT.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailAmountValidationTest.assertFalse((boolean)this.validation.validate(null));
    }

    public void testAmountNotNegativeWhenNotReversalAndNotDiscount_True() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailAmountValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testAmountNotNegativeWhenNotReversalAndNotDiscount_False() throws WorkflowException {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
        CustomerInvoiceDocument customerInvoiceDocument = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(null);
        this.validation.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.validation.setCustomerInvoiceDocument(customerInvoiceDocument);
        CustomerInvoiceDetailAmountValidationTest.assertFalse((boolean)this.validation.validate(null));
    }
}

