/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerRule;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerRuleTest
extends MaintenanceRuleTestBase {
    private Customer customer;
    private CustomerAddress customerAddress;
    private static final String CUSTOMER_ADDRESS_NAME = "Address Name";
    private static final String CUSTOMER_ADDRESS_COUNTRY_CODE_US = "US";
    private static final String CUSTOMER_ADDRESS_COUNTRY_CODE_RO = "RO";
    private static final String CUSTOMER_ADDRESS_STATE_CODE = "NY";
    private static final String CUSTOMER_ADDRESS_ZIP_CODE = "14850";
    private static final String CUSTOMER_ADDRESS_PROVINCE = "Iasi";

    protected void setUp() throws Exception {
        super.setUp();
        this.customer = new Customer();
        this.customerAddress = new CustomerAddress();
    }

    protected void tearDown() throws Exception {
        this.customer = null;
        this.customerAddress = null;
        super.tearDown();
    }

    public void testCheckCustomerHasAddress_True() {
        this.customer.getCustomerAddresses().add(this.customerAddress);
        CustomerRule rule = (CustomerRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customer), CustomerRule.class);
        boolean result = rule.checkCustomerHasAddress(this.customer);
        CustomerRuleTest.assertEquals((String)"When customer has an address checkCustomerHasAddress should return true. ", (boolean)true, (boolean)result);
    }

    public void testCheckCustomerHasAddress_False() {
        this.customer.getCustomerAddresses().clear();
        CustomerRule rule = (CustomerRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customer), CustomerRule.class);
        boolean result = rule.checkCustomerHasAddress(this.customer);
        CustomerRuleTest.assertEquals((String)"When customer does not have an address checkCustomerHasAddress should return false. ", (boolean)false, (boolean)result);
    }

    public void testCheckAddressIsValid_CountryUS_True() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_US);
        this.customerAddress.setCustomerStateCode(CUSTOMER_ADDRESS_STATE_CODE);
        this.customerAddress.setCustomerZipCode(CUSTOMER_ADDRESS_ZIP_CODE);
        CustomerRule rule = (CustomerRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customer), CustomerRule.class);
        boolean result = rule.checkAddressIsValid(this.customerAddress);
        CustomerRuleTest.assertEquals((String)"When customer address has country code US and state code and zip code are not empty checkAddressIsValid should return true. ", (boolean)true, (boolean)result);
    }

    public void testCheckAddressIsValid_CountryUS_False() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_US);
        this.customerAddress.setCustomerStateCode("");
        this.customerAddress.setCustomerZipCode("");
        CustomerRule rule = (CustomerRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customer), CustomerRule.class);
        boolean result = rule.checkAddressIsValid(this.customerAddress);
        CustomerRuleTest.assertEquals((String)"When customer address has country code US and state code and zip code are empty checkAddressIsValid should return false. ", (boolean)false, (boolean)result);
    }

    public void testCheckAddressIsValid_CountryNonUS_False() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_RO);
        this.customerAddress.setCustomerAddressInternationalProvinceName("");
        this.customerAddress.setCustomerZipCode("");
        CustomerRule rule = (CustomerRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customer), CustomerRule.class);
        boolean result = rule.checkAddressIsValid(this.customerAddress);
        CustomerRuleTest.assertEquals((String)"When customer address has country code RO and province and International Mail Code are empty checkAddressIsValid should return true; province and international mail code are never required. ", (boolean)true, (boolean)result);
    }

    public void testCheckAddresses_True() {
        this.customerAddress.setCustomerAddressTypeCode("P");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        CustomerRule rule = (CustomerRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customer), CustomerRule.class);
        boolean result = rule.checkAddresses(this.customer);
        CustomerRuleTest.assertEquals((String)"When customer has one primary address checkAddresses should return true. ", (boolean)true, (boolean)result);
    }

    public void testCheckAddresses_HasMore_False() {
        this.customerAddress.setCustomerAddressTypeCode("P");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        this.customer.getCustomerAddresses().add(this.customerAddress);
        CustomerRule rule = (CustomerRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customer), CustomerRule.class);
        boolean result = rule.checkAddresses(this.customer);
        CustomerRuleTest.assertEquals((String)"When customer has more than one primary address checkAddresses should return false. ", (boolean)false, (boolean)result);
    }

    public void testCheckAddresses_HasNone_False() {
        this.customerAddress.setCustomerAddressTypeCode("A");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        CustomerRule rule = (CustomerRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customer), CustomerRule.class);
        boolean result = rule.checkAddresses(this.customer);
        CustomerRuleTest.assertEquals((String)"When customer has no primary address checkAddresses should return false. ", (boolean)false, (boolean)result);
    }
}

