/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service;

import java.io.File;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.bo.ModuleConfiguration;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.dataaccess.AwardAccountObjectCodeTotalBilledDao;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFundManagerFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceBillFixture;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;
import org.kuali.kfs.module.ar.service.CostCategoryService;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class ContractsGrantsInvoiceCreateTestBase
extends KualiTestBase {
    protected BusinessObjectService businessObjectService;
    protected ConfigurationService configurationService;
    protected DocumentService documentService;
    protected KualiModuleService kualiModuleService;
    protected AccountingPeriodService accountingPeriodService;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected UniversityDateService originalUniversityDateService;
    protected VerifyBillingFrequencyService verifyBillingFrequencyService;
    protected String errorOutputFile;
    protected ContractsGrantsInvoiceCreateDocumentServiceImpl contractsGrantsInvoiceCreateDocumentService;
    public static final Integer LAST_FISCAL_YEAR = 2015;

    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.configurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        this.kualiModuleService = (KualiModuleService)SpringContext.getBean(KualiModuleService.class);
        this.verifyBillingFrequencyService = (VerifyBillingFrequencyService)SpringContext.getBean(VerifyBillingFrequencyService.class);
        this.originalUniversityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        this.contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        this.accountingPeriodService = this.buildMockAccountingPeriodService();
        ModuleConfiguration systemConfiguration = this.kualiModuleService.getModuleServiceByNamespaceCode("KFS-AR").getModuleConfiguration();
        String destinationFolderPath = (String)((FinancialSystemModuleConfiguration)systemConfiguration).getBatchFileDirectories().get(0);
        this.errorOutputFile = destinationFolderPath + File.separator + "JUNIT TEST.log";
        this.contractsGrantsInvoiceCreateDocumentService = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.contractsGrantsInvoiceCreateDocumentService.setAccountService((AccountService)SpringContext.getBean(AccountService.class));
        this.contractsGrantsInvoiceCreateDocumentService.setAccountingPeriodService(this.accountingPeriodService);
        this.contractsGrantsInvoiceCreateDocumentService.setAccountsReceivableDocumentHeaderService((AccountsReceivableDocumentHeaderService)SpringContext.getBean(AccountsReceivableDocumentHeaderService.class));
        this.contractsGrantsInvoiceCreateDocumentService.setAwardAccountObjectCodeTotalBilledDao((AwardAccountObjectCodeTotalBilledDao)SpringContext.getBean(AwardAccountObjectCodeTotalBilledDao.class));
        this.contractsGrantsInvoiceCreateDocumentService.setBusinessObjectService(this.businessObjectService);
        this.contractsGrantsInvoiceCreateDocumentService.setConfigurationService(this.configurationService);
        this.contractsGrantsInvoiceCreateDocumentService.setContractsGrantsBillingAwardVerificationService((ContractsGrantsBillingAwardVerificationService)SpringContext.getBean(ContractsGrantsBillingAwardVerificationService.class));
        this.contractsGrantsInvoiceCreateDocumentService.setContractsGrantsBillingUtilityService((ContractsGrantsBillingUtilityService)SpringContext.getBean(ContractsGrantsBillingUtilityService.class));
        this.contractsGrantsInvoiceCreateDocumentService.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentService);
        this.contractsGrantsInvoiceCreateDocumentService.setCostCategoryService((CostCategoryService)SpringContext.getBean(CostCategoryService.class));
        this.contractsGrantsInvoiceCreateDocumentService.setCustomerService((CustomerService)SpringContext.getBean(CustomerService.class));
        this.contractsGrantsInvoiceCreateDocumentService.setDateTimeService((DateTimeService)SpringContext.getBean(DateTimeService.class));
        this.contractsGrantsInvoiceCreateDocumentService.setDocumentService(this.documentService);
        this.contractsGrantsInvoiceCreateDocumentService.setFinancialSystemDocumentService((FinancialSystemDocumentService)SpringContext.getBean(FinancialSystemDocumentService.class));
        this.contractsGrantsInvoiceCreateDocumentService.setKualiModuleService(this.kualiModuleService);
        this.contractsGrantsInvoiceCreateDocumentService.setVerifyBillingFrequencyService(this.verifyBillingFrequencyService);
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
        this.contractsGrantsInvoiceCreateDocumentService.setOptionsService((OptionsService)SpringContext.getBean(OptionsService.class));
    }

    private AccountingPeriodService buildMockAccountingPeriodService() {
        AccountingPeriod accountingPeriod = new AccountingPeriod();
        accountingPeriod.setUniversityFiscalYear(LAST_FISCAL_YEAR);
        accountingPeriod.setUniversityFiscalPeriodCode("02");
        AccountingPeriodService accountingPeriodService = (AccountingPeriodService)Mockito.mock(AccountingPeriodService.class);
        Mockito.when((Object)accountingPeriodService.getByDate((Date)ArgumentMatchers.any())).thenReturn((Object)accountingPeriod);
        return accountingPeriodService;
    }

    public void tearDown() throws Exception {
        File errors = new File(this.errorOutputFile);
        if (errors.exists()) {
            errors.delete();
        }
        super.tearDown();
    }

    protected List<ContractsAndGrantsBillingAward> setupAwards() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.createAward();
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAgencyFromFixture((Award)award);
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1.createAwardAccount();
        awardAccount_1.refreshReferenceObject("account");
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        ((Award)award).setAwardAccounts(awardAccounts);
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAwardOrganizationFromFixture((Award)award);
        AwardFundManager awardFundManager = ARAwardFundManagerFixture.AWD_FND_MGR1.createAwardFundManager();
        ((Award)award).getAwardFundManagers().add(awardFundManager);
        ((Award)award).setAwardPrimaryFundManager(ARAwardFundManagerFixture.AWD_FND_MGR1.createAwardFundManager());
        awards.add(award);
        return awards;
    }

    protected List<ContractsAndGrantsBillingAward> setupBillableAwards() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.createAward();
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAgencyFromFixture((Award)award);
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_4.createAwardAccount();
        awardAccount_1.refreshReferenceObject("account");
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        ((Award)award).setAwardAccounts(awardAccounts);
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAwardOrganizationFromFixture((Award)award);
        AwardFundManager awardFundManager = ARAwardFundManagerFixture.AWD_FND_MGR1.createAwardFundManager();
        ((Award)award).getAwardFundManagers().add(awardFundManager);
        ((Award)award).setAwardPrimaryFundManager(ARAwardFundManagerFixture.AWD_FND_MGR1.createAwardFundManager());
        awards.add(award);
        return awards;
    }

    protected void setupBills(ContractsGrantsInvoiceDocument document) {
        ArrayList<InvoiceBill> invoiceBills = new ArrayList<InvoiceBill>();
        InvoiceBill invBill_1 = InvoiceBillFixture.INV_BILL_2.createInvoiceBill();
        invBill_1.setDocumentNumber(document.getDocumentNumber());
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        Date today = new Date(ts.getTime());
        AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
        BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(document.getInvoiceGeneralDetail().getAward(), currPeriod);
        Date invoiceDate = billingPeriod.getEndDate();
        Date billDate = new Date(new DateTime(invoiceDate.getTime()).minusDays(1).toDate().getTime());
        invBill_1.setBillDate(billDate);
        this.businessObjectService.save((PersistableBusinessObject)invBill_1);
        invoiceBills.add(invBill_1);
        document.setInvoiceBills(invoiceBills);
        Bill bill = new Bill();
        bill.setProposalNumber(document.getInvoiceGeneralDetail().getProposalNumber());
        bill.setBillNumber(invBill_1.getBillNumber());
        bill.setBillDescription(invBill_1.getBillDescription());
        bill.setBillIdentifier(invBill_1.getBillIdentifier());
        bill.setBillDate(invBill_1.getBillDate());
        bill.setEstimatedAmount(invBill_1.getEstimatedAmount());
        bill.setBilled(false);
        bill.setAward(document.getInvoiceGeneralDetail().getAward());
        bill.setActive(true);
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule.setProposalNumber(document.getInvoiceGeneralDetail().getProposalNumber());
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill);
        predeterminedBillingSchedule.setBills(bills);
        this.businessObjectService.save((PersistableBusinessObject)predeterminedBillingSchedule);
        this.businessObjectService.save((PersistableBusinessObject)bill);
    }

    protected UniversityDateService buildMockUniversityDateService() throws Exception {
        UniversityDateService universityDateService = (UniversityDateService)Mockito.mock(UniversityDateService.class);
        Mockito.when((Object)universityDateService.getCurrentFiscalYear()).thenReturn((Object)LAST_FISCAL_YEAR);
        return universityDateService;
    }
}

