/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentService;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTimeUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFundManagerFixture;
import org.kuali.kfs.module.ar.fixture.BillingFrequencyFixture;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PerformValidationTest {
    private ContractsGrantsInvoiceCreateDocumentServiceImpl cut;
    @Mock
    private ContractsGrantsBillingAwardVerificationService contractsGrantsBillingAwardVerificationService;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    @Mock
    private VerifyBillingFrequencyService verifyBillingFrequencyService;
    @Mock
    private FinancialSystemDocumentService financialSystemDocumentService;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private ConfigurationService configSvcMock;
    @Mock
    private OptionsService optionsSvcMock;
    @Mock
    private DateTimeService dateTimeSvcMock;
    @Mock
    private AccountService accountSvcMock;
    private Set<String> pendingDocumentStatuses = new HashSet<String>(Arrays.asList("I", "S", "R", "E"));
    private Set<ContractsAndGrantsBillingAward> awardsInError;
    private boolean validBillingFrequency;
    private boolean correctBillingFrequency;
    private boolean alreadyBuilt;
    private boolean hasMilestones;
    private boolean validBills;
    private boolean customerRecord;
    private boolean chartOrgSetUp;
    private boolean invoiceInProgress;
    private List<String> ccaErrors;
    private List<ContractsGrantsInvoiceDocument> pendingDocuments;
    private Collection<Account> expiredAccounts;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.cut.setContractsGrantsBillingAwardVerificationService(this.contractsGrantsBillingAwardVerificationService);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentService);
        this.cut.setVerifyBillingFrequencyService(this.verifyBillingFrequencyService);
        this.cut.setFinancialSystemDocumentService(this.financialSystemDocumentService);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setConfigurationService(this.configSvcMock);
        this.cut.setOptionsService(this.optionsSvcMock);
        this.cut.setDateTimeService(this.dateTimeSvcMock);
        this.cut.setAccountService(this.accountSvcMock);
        this.validBillingFrequency = true;
        this.correctBillingFrequency = true;
        this.alreadyBuilt = false;
        this.hasMilestones = true;
        this.expiredAccounts = null;
        this.validBills = true;
        this.customerRecord = true;
        this.chartOrgSetUp = true;
        this.invoiceInProgress = false;
        this.ccaErrors = new ArrayList<String>();
        this.pendingDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        this.awardsInError = new HashSet<ContractsAndGrantsBillingAward>();
    }

    @Test
    public void testPerformAwardValidationStartDateMissing() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        ((Award)award).setAwardBeginningDate(null);
        awards.add(award);
        this.prepareOtherMocks();
        this.expectError(award, "error.cginvoice.award.startDate.missing");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvalidBillingFrequency() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD1.createAward();
        awards.add(award);
        this.prepareOtherMocks();
        this.expectError(award, "error.cginvoice.billing.missing.frequency");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvalidBillingPeriod() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_INVALID_DATES.createAward();
        ((Award)award).setAwardBeginningDate(new Date(DateTimeUtils.currentTimeMillis()));
        awards.add(award);
        this.validBillingFrequency = false;
        this.prepareMocks(award);
        this.prepareOtherMocks();
        this.expectError(award, "error.cginvoice.award.not.eligible.invoice");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationValidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should  contain one award.", (qualifiedAwards.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"qualifiedAwards should contain our initial award.", (boolean)((List)qualifiedAwards).get(0).equals(awards.get(0)));
    }

    @Test
    public void testPerformAwardValidationAwardInvoicingSuspended() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setExcludedFromInvoicing(true);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.excluded.from.invoicing");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInactiveAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setActive(false);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.inactive");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationSuspendedAndInactiveAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setActive(false);
        ((Award)awards.get(0)).setExcludedFromInvoicing(true);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.excluded.from.invoicing");
        this.expectError(awards.get(0), "error.cginvoice.award.inactive");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationTwoInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2);
        ((Award)awards.get(0)).setActive(false);
        ((Award)awards2.get(0)).setExcludedFromInvoicing(true);
        awards.addAll(awards2);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.excluded.from.invoicing");
        this.expectError(awards.get(1), "error.cginvoice.award.inactive");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationOneValidOneInvalidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2);
        ((Award)awards2.get(0)).setExcludedFromInvoicing(true);
        awards.addAll(awards2);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(1), "error.cginvoice.award.excluded.from.invoicing");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertEquals((String)"qualifiedAwards should contain one award.", (long)1L, (long)qualifiedAwards.size());
        Assert.assertTrue((String)"qualifiedAwards should contain our initial award.", (boolean)((List)qualifiedAwards).get(0).equals(awards.get(0)));
    }

    @Test
    public void testPerformAwardValidationMissingAwardInvoicingOption() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setInvoicingOptionCode(null);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.missing");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvalidPredeterminedBillingFrequency() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        award.setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        award.getAwardAccounts().add(awardAccount_2);
        this.correctBillingFrequency = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError((ContractsAndGrantsBillingAward)award, "error.cginvoice.award.single.account");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvalidMilestoneBillingFrequency() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        award.setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        award.getAwardAccounts().add(awardAccount_2);
        this.correctBillingFrequency = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError((ContractsAndGrantsBillingAward)award, "error.cginvoice.award.single.account");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoActiveAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).getAwardAccounts().clear();
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.no.active.accounts.assigned");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationExpiredAccount() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.expiredAccounts = new ArrayList<Account>();
        this.expiredAccounts.add(new Account());
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.contain.expired.account");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationAwardFinalInvoiceAlreadyBilled() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.alreadyBuilt = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.already.billed");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoValidMilestonesToInvoice() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.hasMilestones = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.not.valid.milestones");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoValidBillsToInvoice() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ((Award)awards.get(0)).setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ((Award)awards.get(0)).setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        this.validBills = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.not.valid.bills");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationOneValidOneInvalidAwardAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        AwardAccount awardAccount_2 = ARAwardAccountFixture.AWD_ACCT_WITH_CCA_2.createAwardAccount();
        awardAccount_2.setCurrentLastBilledDate(new Date(System.currentTimeMillis()));
        ((Award)awards.get(0)).getAwardAccounts().add(awardAccount_2);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should contain one award.", (qualifiedAwards.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationAgencyHasNoMatchingCustomer() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.customerRecord = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.not.valid.customer");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoValidAwardAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        ContractsGrantsInvoiceDocument document = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        InvoiceAccountDetail detail = new InvoiceAccountDetail();
        ContractsAndGrantsBillingAwardAccount awardAccount = (ContractsAndGrantsBillingAwardAccount)awards.get(0).getActiveAwardAccounts().get(0);
        detail.setAccountNumber(awardAccount.getAccountNumber());
        detail.setChartOfAccountsCode(awardAccount.getChartOfAccountsCode());
        Mockito.when((Object)document.getAccountDetails()).thenReturn(Arrays.asList(detail));
        Mockito.when((Object)this.accountSvcMock.getByPrimaryId(awardAccount.getChartOfAccountsCode(), awardAccount.getAccountNumber())).thenReturn((Object)awardAccount.getAccount());
        this.pendingDocuments.add(document);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cgivoice.award.not.valid.accounts");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoContractControlAccountsByCCA() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.ccaErrors.add("error.cg.no.control.account");
        this.ccaErrors.add("");
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cg.no.control.account");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationNoSysInfo() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        this.chartOrgSetUp = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.sys.info.not.setup");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvoicesInProgressMilestone() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.invoiceInProgress = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cgivoice.award.not.valid.accounts");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerformAwardValidationInvoicesInProgressPredeterminedBilling() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAward(ARAwardAccountFixture.AWD_ACCT_WITH_CCA_1);
        Award award = (Award)awards.get(0);
        award.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        award.setBillingFrequency((AccountsReceivableBillingFrequency)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        this.invoiceInProgress = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cgivoice.award.not.valid.accounts");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertTrue((String)"qualifiedAwards should be empty.", (qualifiedAwards.size() == 0 ? 1 : 0) != 0);
    }

    private void expectError(ContractsAndGrantsBillingAward award, String errorKey) {
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString(errorKey)).thenReturn((Object)"Error");
        if (!this.awardsInError.contains(award)) {
            this.awardsInError.add(award);
            for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null, (java.util.Date)award.getAwardBeginningDate())).thenReturn((Object)KualiDecimal.ZERO);
            }
            Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
            Mockito.when((Object)this.boServiceMock.save((PersistableBusinessObject)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))).thenReturn(null);
        }
    }

    private List<ContractsAndGrantsBillingAward> setupAward(ARAwardAccountFixture awardAccountFixture) {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.createAward();
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAgencyFromFixture((Award)award);
        award.getActiveAwardAccounts().clear();
        AwardAccount awardAccount_1 = awardAccountFixture.createAwardAccount();
        Account account = new Account();
        awardAccount_1.setAccount(account);
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(awardAccount_1);
        ((Award)award).setAwardAccounts(awardAccounts);
        award = ARAwardFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.setAwardOrganizationFromFixture((Award)award);
        AwardFundManager awardFundManager = ARAwardFundManagerFixture.AWD_FND_MGR1.createAwardFundManager();
        ((Award)award).getAwardFundManagers().add(awardFundManager);
        ((Award)award).setAwardPrimaryFundManager(ARAwardFundManagerFixture.AWD_FND_MGR1.createAwardFundManager());
        awards.add(award);
        return awards;
    }

    private void prepareMocks(List<ContractsAndGrantsBillingAward> awards) {
        for (ContractsAndGrantsBillingAward award : awards) {
            this.prepareMocks(award);
        }
    }

    private void prepareMocks(ContractsAndGrantsBillingAward award) {
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(award)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency(award)).thenReturn((Object)this.validBillingFrequency);
        if (!this.validBillingFrequency) {
            return;
        }
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isBillingFrequencySetCorrectly(award)).thenReturn((Object)this.correctBillingFrequency);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getExpiredAccountsOfAward(award)).thenReturn(this.expiredAccounts);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isAwardFinalInvoiceAlreadyBuilt(award)).thenReturn((Object)this.alreadyBuilt);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasMilestonesToInvoice(award)).thenReturn((Object)this.hasMilestones);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasBillsToInvoice(award)).thenReturn((Object)this.validBills);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(award)).thenReturn((Object)this.customerRecord);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(award)).thenReturn(this.ccaErrors);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(award)).thenReturn((Object)this.chartOrgSetUp);
        if (ArConstants.BillingFrequencyValues.isMilestone((ContractsAndGrantsBillingAward)award) || ArConstants.BillingFrequencyValues.isPredeterminedBilling((ContractsAndGrantsBillingAward)award)) {
            Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isInvoiceInProgress(award)).thenReturn((Object)this.invoiceInProgress);
        } else if (award.getActiveAwardAccounts().size() > 0) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
            fieldValues.put("documentHeader.workflowDocumentStatusCode", this.pendingDocumentStatuses);
            Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(this.pendingDocuments);
            if (this.pendingDocuments.isEmpty()) {
                for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                    Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency(award, awardAccount)).thenReturn((Object)true);
                }
            }
        }
    }

    private void prepareOtherMocks() {
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(this.pendingDocumentStatuses);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsBoolean("module.external.kuali.coeus.enabled")).thenReturn((Object)false);
    }
}

