/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddress;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import java.sql.Date;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class Customer extends PersistableBusinessObjectBase implements MutableInactivatable, AccountsReceivableCustomer {

    private String customerNumber;
    private String customerName;
    private String customerParentCompanyNumber;
    private String customerTypeCode;
    private String customerTypeDescription;
    private Date customerAddressChangeDate;
    private Date customerRecordAddDate;
    private Date customerLastActivityDate;
    private String customerTaxTypeCode;
    private String customerTaxNbr;
    private boolean active;
    private String customerPhoneNumber;
    private String customer800PhoneNumber;
    private String customerContactName;
    private String customerContactPhoneNumber;
    private String customerFaxNumber;
    private Date customerBirthDate;
    private boolean customerTaxExemptIndicator;
    private KualiDecimal customerCreditLimitAmount;
    private String customerCreditApprovedByName;
    private String customerEmailAddress;

    private Customer customerParentCompany;
    private CustomerType customerType;
    private List boNotes;

    private List<CustomerAddress> customerAddresses;

    private String bankruptcyType;
    private Date bankruptcyDate;
    private Date bankruptcyReviewDate;
    private boolean stopWorkIndicator;
    private String stopWorkReason;

    // Invoice Types link

    private String customerInvoiceTemplateCode;
    private InvoiceTemplate customerInvoiceTemplate;

    /**
     * Default constructor.
     */
    public Customer() {
        customerAddresses = new ArrayList<>();
    }

    /**
     * Gets the customerNumber attribute.
     *
     * @return Returns the customerNumber
     */
    @Override
    public String getCustomerNumber() {
        return customerNumber;
    }

    /**
     * Sets the customerNumber attribute.
     *
     * @param customerNumber The customerNumber to set.
     */
    @Override
    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }


    /**
     * Gets the customerName attribute.
     *
     * @return Returns the customerName
     */
    @Override
    public String getCustomerName() {
        return customerName;
    }

    /**
     * Sets the customerName attribute.
     *
     * @param customerName The customerName to set.
     */
    @Override
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    /**
     * Gets the customerParentCompanyNumber attribute.
     *
     * @return Returns the customerParentCompanyNumber
     */
    @Override
    public String getCustomerParentCompanyNumber() {
        return customerParentCompanyNumber;
    }

    /**
     * Sets the customerParentCompanyNumber attribute.
     *
     * @param customerParentCompanyNumber The customerParentCompanyNumber to set.
     */
    @Override
    public void setCustomerParentCompanyNumber(String customerParentCompanyNumber) {
        this.customerParentCompanyNumber = customerParentCompanyNumber;
    }

    /**
     * Gets the customerTypeCode attribute.
     *
     * @return Returns the customerTypeCode
     */
    @Override
    public String getCustomerTypeCode() {
        return customerTypeCode;
    }

    /**
     * Sets the customerTypeCode attribute.
     *
     * @param customerTypeCode The customerTypeCode to set.
     */
    @Override
    public void setCustomerTypeCode(String customerTypeCode) {
        this.customerTypeCode = customerTypeCode;
    }

    /**
     * Gets the customerTypeDescription attribute.
     *
     * @return Returns the customerTypeDescription.
     */
    @Override
    public String getCustomerTypeDescription() {
        return customerTypeDescription;
    }

    /**
     * Sets the customerTypeDescription attribute value.
     *
     * @param customerTypeDescription The customerTypeDescription to set.
     */
    public void setCustomerTypeDescription(String customerTypeDescription) {
        this.customerTypeDescription = customerTypeDescription;
    }

    /**
     * Gets the customerAddressChangeDate attribute.
     *
     * @return Returns the customerAddressChangeDate
     */
    @Override
    public Date getCustomerAddressChangeDate() {
        return customerAddressChangeDate;
    }

    /**
     * Sets the customerAddressChangeDate attribute.
     *
     * @param customerAddressChangeDate The customerAddressChangeDate to set.
     */
    @Override
    public void setCustomerAddressChangeDate(Date customerAddressChangeDate) {
        this.customerAddressChangeDate = customerAddressChangeDate;
    }


    /**
     * Gets the customerRecordAddDate attribute.
     *
     * @return Returns the customerRecordAddDate
     */
    @Override
    public Date getCustomerRecordAddDate() {
        return customerRecordAddDate;
    }

    /**
     * Sets the customerRecordAddDate attribute.
     *
     * @param customerRecordAddDate The customerRecordAddDate to set.
     */
    @Override
    public void setCustomerRecordAddDate(Date customerRecordAddDate) {
        this.customerRecordAddDate = customerRecordAddDate;
    }


    /**
     * Gets the customerLastActivityDate attribute.
     *
     * @return Returns the customerLastActivityDate
     */
    @Override
    public Date getCustomerLastActivityDate() {
        return customerLastActivityDate;
    }

    /**
     * Sets the customerLastActivityDate attribute.
     *
     * @param customerLastActivityDate The customerLastActivityDate to set.
     */
    @Override
    public void setCustomerLastActivityDate(Date customerLastActivityDate) {
        this.customerLastActivityDate = customerLastActivityDate;
    }


    /**
     * Gets the active attribute.
     *
     * @return Returns the active
     */
    @Override
    public boolean isActive() {
        return active;
    }

    /**
     * Sets the active attribute.
     *
     * @param active The active to set.
     */
    @Override
    public void setActive(boolean active) {
        this.active = active;
    }


    /**
     * Gets the customerPhoneNumber attribute.
     *
     * @return Returns the customerPhoneNumber
     */
    @Override
    public String getCustomerPhoneNumber() {
        return customerPhoneNumber;
    }

    /**
     * Sets the customerPhoneNumber attribute.
     *
     * @param customerPhoneNumber The customerPhoneNumber to set.
     */
    @Override
    public void setCustomerPhoneNumber(String customerPhoneNumber) {
        this.customerPhoneNumber = customerPhoneNumber;
    }


    /**
     * Gets the customer800PhoneNumber attribute.
     *
     * @return Returns the customer800PhoneNumber
     */
    @Override
    public String getCustomer800PhoneNumber() {
        return customer800PhoneNumber;
    }

    /**
     * Sets the customer800PhoneNumber attribute.
     *
     * @param customer800PhoneNumber The customer800PhoneNumber to set.
     */
    public void setCustomer800PhoneNumber(String customer800PhoneNumber) {
        this.customer800PhoneNumber = customer800PhoneNumber;
    }


    /**
     * Gets the customerContactName attribute.
     *
     * @return Returns the customerContactName
     */
    @Override
    public String getCustomerContactName() {
        return customerContactName;
    }

    /**
     * Sets the customerContactName attribute.
     *
     * @param customerContactName The customerContactName to set.
     */
    public void setCustomerContactName(String customerContactName) {
        this.customerContactName = customerContactName;
    }


    /**
     * Gets the customerContactPhoneNumber attribute.
     *
     * @return Returns the customerContactPhoneNumber
     */
    @Override
    public String getCustomerContactPhoneNumber() {
        return customerContactPhoneNumber;
    }

    /**
     * Sets the customerContactPhoneNumber attribute.
     *
     * @param customerContactPhoneNumber The customerContactPhoneNumber to set.
     */
    public void setCustomerContactPhoneNumber(String customerContactPhoneNumber) {
        this.customerContactPhoneNumber = customerContactPhoneNumber;
    }


    /**
     * Gets the customerFaxNumber attribute.
     *
     * @return Returns the customerFaxNumber
     */
    @Override
    public String getCustomerFaxNumber() {
        return customerFaxNumber;
    }

    /**
     * Sets the customerFaxNumber attribute.
     *
     * @param customerFaxNumber The customerFaxNumber to set.
     */
    public void setCustomerFaxNumber(String customerFaxNumber) {
        this.customerFaxNumber = customerFaxNumber;
    }


    /**
     * Gets the customerBirthDate attribute.
     *
     * @return Returns the customerBirthDate
     */
    @Override
    public Date getCustomerBirthDate() {
        return customerBirthDate;
    }

    /**
     * Sets the customerBirthDate attribute.
     *
     * @param customerBirthDate The customerBirthDate to set.
     */
    @Override
    public void setCustomerBirthDate(Date customerBirthDate) {
        this.customerBirthDate = customerBirthDate;
    }

    /**
     * Gets the customerCreditLimitAmount attribute.
     *
     * @return Returns the customerCreditLimitAmount
     */
    @Override
    public KualiDecimal getCustomerCreditLimitAmount() {
        return customerCreditLimitAmount;
    }

    /**
     * Sets the customerCreditLimitAmount attribute.
     *
     * @param customerCreditLimitAmount The customerCreditLimitAmount to set.
     */
    public void setCustomerCreditLimitAmount(KualiDecimal customerCreditLimitAmount) {
        this.customerCreditLimitAmount = customerCreditLimitAmount;
    }


    /**
     * Gets the customerCreditApprovedByName attribute.
     *
     * @return Returns the customerCreditApprovedByName
     */
    @Override
    public String getCustomerCreditApprovedByName() {
        return customerCreditApprovedByName;
    }

    /**
     * Sets the customerCreditApprovedByName attribute.
     *
     * @param customerCreditApprovedByName The customerCreditApprovedByName to set.
     */
    public void setCustomerCreditApprovedByName(String customerCreditApprovedByName) {
        this.customerCreditApprovedByName = customerCreditApprovedByName;
    }


    /**
     * Gets the customerEmailAddress attribute.
     *
     * @return Returns the customerEmailAddress
     */
    @Override
    public String getCustomerEmailAddress() {
        return customerEmailAddress;
    }

    /**
     * Sets the customerEmailAddress attribute.
     *
     * @param customerEmailAddress The customerEmailAddress to set.
     */
    @Override
    public void setCustomerEmailAddress(String customerEmailAddress) {
        this.customerEmailAddress = customerEmailAddress;
    }

    /**
     * Gets the customerParentCompany attribute.
     *
     * @return Returns the customerParentCompany
     */
    public Customer getCustomerParentCompany() {
        return customerParentCompany;
    }

    /**
     * Sets the customerParentCompany attribute.
     *
     * @param customerParentCompany The customerParentCompany to set.
     * @deprecated
     */
    @Deprecated
    public void setCustomerParentCompany(Customer customerParentCompany) {
        this.customerParentCompany = customerParentCompany;
    }

    /**
     * Gets the customerType attribute.
     *
     * @return Returns the customerType.
     */
    public CustomerType getCustomerType() {
        return customerType;
    }

    /**
     * Sets the customerType attribute value.
     *
     * @param customerType The customerType to set.
     * @deprecated
     */
    @Deprecated
    public void setCustomerType(CustomerType customerType) {
        this.customerType = customerType;
    }

    /**
     * @see org.kuali.rice.krad.bo.BusinessObjectBase#toStringMapper()
     */
    @SuppressWarnings("unchecked")
    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap m = new LinkedHashMap();
        m.put("customerNumber", this.customerNumber);
        return m;
    }

    @Override
    public boolean isCustomerTaxExemptIndicator() {
        return customerTaxExemptIndicator;
    }

    public void setCustomerTaxExemptIndicator(boolean customerTaxExemptIndicator) {
        this.customerTaxExemptIndicator = customerTaxExemptIndicator;
    }

    /**
     * This method gets customerAddresses
     *
     * @return customerAddresses
     */
    public List<CustomerAddress> getCustomerAddresses() {
        return customerAddresses;
    }

    /**
     * This method sets customerAddresses
     *
     * @param customerAddresses
     */
    public void setCustomerAddresses(List<CustomerAddress> customerAddresses) {
        this.customerAddresses = customerAddresses;
    }

    @Override
    public String getCustomerTaxNbr() {
        return customerTaxNbr;
    }

    public void setCustomerTaxNbr(String customerTaxNbr) {
        this.customerTaxNbr = customerTaxNbr;
    }

    @Override
    public String getCustomerTaxTypeCode() {
        return customerTaxTypeCode;
    }

    public void setCustomerTaxTypeCode(String customerTaxTypeCode) {
        this.customerTaxTypeCode = customerTaxTypeCode;
    }

    /**
     * Gets the boNotes attribute.
     *
     * @return Returns the boNotes
     */

    public List<Note> getBoNotes() {
        if (StringUtils.isEmpty(customerNumber)) {
            return new ArrayList<Note>();
        }
        CustomerService customerService = SpringContext.getBean(CustomerService.class);
        return customerService.getCustomerNotes(customerNumber);
    }

    /**
     * Sets the boNotes attribute.
     *
     * @param boNotes The boNotes to set.
     */
    public void setBoNotes(List boNotes) {
        this.boNotes = boNotes;
    }

    /**
     * Gets the bankruptcyType attribute.
     *
     * @return Returns the bankruptcyType.
     */
    public String getBankruptcyType() {
        return bankruptcyType;
    }

    /**
     * Sets the bankruptcyType attribute value.
     *
     * @param bankruptcyType The bankruptcyType to set.
     */
    public void setBankruptcyType(String bankruptcyType) {
        this.bankruptcyType = bankruptcyType;
    }

    /**
     * Gets the bankruptcyDate attribute.
     *
     * @return Returns the bankruptcyDate.
     */
    public Date getBankruptcyDate() {
        return bankruptcyDate;
    }

    /**
     * Sets the bankruptcyDate attribute value.
     *
     * @param bankruptcyDate The bankruptcyDate to set.
     */
    public void setBankruptcyDate(Date bankruptcyDate) {
        this.bankruptcyDate = bankruptcyDate;
    }

    /**
     * Gets the bankruptcyReviewDate attribute.
     *
     * @return Returns the bankruptcyReviewDate.
     */
    public Date getBankruptcyReviewDate() {
        return bankruptcyReviewDate;
    }

    /**
     * Sets the bankruptcyReviewDate attribute value.
     *
     * @param reviewDate The bankruptcyReviewDate to set.
     */
    public void setBankruptcyReviewDate(Date bankruptcyReviewDate) {
        this.bankruptcyReviewDate = bankruptcyReviewDate;
    }

    /**
     * Gets the stopWork attribute.
     *
     * @return Returns the stopWork.
     */
    @Override
    public boolean isStopWorkIndicator() {
        return stopWorkIndicator;
    }

    /**
     * Sets the stopWorkIndicator attribute value.
     *
     * @param stopWorkIndicator The stopWorkIndicator to set.
     */
    public void setStopWorkIndicator(boolean stopWorkIndicator) {
        this.stopWorkIndicator = stopWorkIndicator;
    }

    /**
     * Gets the stopWorkReason attribute.
     *
     * @return Returns the stopWorkReason.
     */
    public String getStopWorkReason() {
        return stopWorkReason;
    }

    /**
     * Sets the stopWorkReason attribute value.
     *
     * @param stopWorkReason The stopWorkReason to set.
     */
    public void setStopWorkReason(String stopWorkReason) {
        this.stopWorkReason = stopWorkReason;
    }

    @Override
    public AccountsReceivableCustomerAddress getPrimaryAddress() {
        return SpringContext.getBean(CustomerAddressService.class).getPrimaryAddress(getCustomerNumber());
    }

    @Override
    public List<AccountsReceivableCustomerAddress> getAccountsReceivableCustomerAddresses() {
        List<AccountsReceivableCustomerAddress> accountsReceivableCustomerAddresses = new ArrayList<AccountsReceivableCustomerAddress>();
        if (this.customerAddresses != null && !this.customerAddresses.isEmpty()) {
            accountsReceivableCustomerAddresses.addAll(customerAddresses);
        }

        return accountsReceivableCustomerAddresses;
    }

    @Override
    public void setAccountsReceivableCustomerAddresses(List<AccountsReceivableCustomerAddress> customerAddresses) {
        if (this.customerAddresses != null && customerAddresses != null) {
            this.customerAddresses.clear();

            for (AccountsReceivableCustomerAddress arca : customerAddresses) {
                this.customerAddresses.add((CustomerAddress) arca);
            }
        }
    }

    @Override
    public String getCustomerInvoiceTemplateCode() {
        return customerInvoiceTemplateCode;
    }

    public void setCustomerInvoiceTemplateCode(String customerInvoiceTemplateCode) {
        this.customerInvoiceTemplateCode = customerInvoiceTemplateCode;
    }

    public InvoiceTemplate getCustomerInvoiceTemplate() {
        return customerInvoiceTemplate;
    }

    public void setCustomerInvoiceTemplate(InvoiceTemplate customerInvoiceTemplate) {
        this.customerInvoiceTemplate = customerInvoiceTemplate;
    }
}

