/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.ar.batch.service.CustomerLoadService;
import org.kuali.kfs.sys.batch.XmlBatchInputFileTypeBase;

public class CustomerLoadInputFileType
extends XmlBatchInputFileTypeBase {
    private static final Logger LOG = LogManager.getLogger(CustomerLoadInputFileType.class);
    private static final String FILE_NAME_PREFIX = "customer_load";
    private static final String FILE_NAME_DELIM = "_";
    private CustomerLoadService customerLoadService;

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifer) {
        return this.customerLoadService.getFileName(principalName, fileUserIdentifer, FILE_NAME_PREFIX, FILE_NAME_DELIM);
    }

    public String getFileTypeIdentifer() {
        return "customerLoadInputFileType";
    }

    public boolean validate(Object parsedFileContents) {
        List customerVOs = null;
        try {
            customerVOs = (List)parsedFileContents;
        }
        catch (Exception e) {
            LOG.error("Could not convert the passed-in parsedFileContents of type [" + parsedFileContents.getClass().toString() + "] to List<CustomerDigesterVO>.");
            throw new RuntimeException("Could not convert the passed-in parsedFileContents of type [" + parsedFileContents.getClass().toString() + "] to List<CustomerDigesterVO>.", e);
        }
        return this.customerLoadService.validate(customerVOs);
    }

    public void process(String fileName, Object parsedFileContents) {
        super.process(fileName, parsedFileContents);
    }

    public String getTitleKey() {
        return "message.ar.customerLoad.batchUpload.xml.title";
    }

    public void setCustomerLoadService(CustomerLoadService customerLoadService) {
        this.customerLoadService = customerLoadService;
    }

    public String getAuthorPrincipalName(File file) {
        String[] fileNameParts = StringUtils.split((String)file.getName(), (String)FILE_NAME_DELIM);
        if (fileNameParts.length > 3) {
            return fileNameParts[2];
        }
        return null;
    }
}

