/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.AppliedPayment;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerCreditMemoDetail
extends PersistableBusinessObjectBase
implements GeneralLedgerPendingEntrySourceDetail,
AppliedPayment {
    private String documentNumber;
    private Integer referenceInvoiceItemNumber;
    private BigDecimal creditMemoItemQuantity;
    private KualiDecimal creditMemoItemTaxAmount;
    private KualiDecimal creditMemoItemTotalAmount;
    private KualiDecimal duplicateCreditMemoItemTotalAmount;
    private KualiDecimal invoiceLineTotalAmount;
    private KualiDecimal creditMemoLineTotalAmount;
    private KualiDecimal invoiceOpenItemAmount;
    private BigDecimal invoiceOpenItemQuantity;
    private CustomerInvoiceDetail customerInvoiceDetail;
    private String financialDocumentReferenceInvoiceNumber;
    private boolean invoiceOpenItemQuantityZero;

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getReferenceInvoiceItemNumber() {
        return this.referenceInvoiceItemNumber;
    }

    public void setReferenceInvoiceItemNumber(Integer referenceInvoiceItemNumber) {
        this.referenceInvoiceItemNumber = referenceInvoiceItemNumber;
    }

    public BigDecimal getCreditMemoItemQuantity() {
        return this.creditMemoItemQuantity;
    }

    public void setCreditMemoItemQuantity(BigDecimal creditMemoItemQuantity) {
        this.creditMemoItemQuantity = creditMemoItemQuantity;
    }

    public KualiDecimal getCreditMemoItemTaxAmount() {
        if (this.creditMemoItemTaxAmount == null) {
            this.setCreditMemoItemTaxAmount(KualiDecimal.ZERO);
        }
        return this.creditMemoItemTaxAmount;
    }

    public void setCreditMemoItemTaxAmount(KualiDecimal creditMemoItemTaxAmount) {
        if (creditMemoItemTaxAmount == null) {
            creditMemoItemTaxAmount = KualiDecimal.ZERO;
        }
        this.creditMemoItemTaxAmount = creditMemoItemTaxAmount;
    }

    public KualiDecimal getCreditMemoItemTotalAmount() {
        return this.creditMemoItemTotalAmount;
    }

    public void setCreditMemoItemTotalAmount(KualiDecimal creditMemoItemTotalAmount) {
        this.creditMemoItemTotalAmount = creditMemoItemTotalAmount;
    }

    public KualiDecimal getInvoiceOpenItemAmount() {
        return this.invoiceOpenItemAmount;
    }

    public void setInvoiceOpenItemAmount(KualiDecimal invoiceOpenItemAmount) {
        this.invoiceOpenItemAmount = invoiceOpenItemAmount;
    }

    public KualiDecimal getInvoiceLineTotalAmount() {
        return this.invoiceLineTotalAmount;
    }

    public void setInvoiceLineTotalAmount(KualiDecimal tax, KualiDecimal invItemAmount) {
        if (invItemAmount == null) {
            invItemAmount = KualiDecimal.ZERO;
        }
        if (tax == null) {
            tax = KualiDecimal.ZERO;
        }
        this.invoiceLineTotalAmount = (KualiDecimal)invItemAmount.add((AbstractKualiDecimal)tax);
    }

    public KualiDecimal getCreditMemoLineTotalAmount() {
        if (this.creditMemoLineTotalAmount == null) {
            this.setCreditMemoLineTotalAmount(KualiDecimal.ZERO);
        }
        return this.creditMemoLineTotalAmount;
    }

    public void setCreditMemoLineTotalAmount(KualiDecimal creditMemoLineTotalAmount) {
        this.creditMemoLineTotalAmount = creditMemoLineTotalAmount;
    }

    public void setInvoiceLineTotalAmount(KualiDecimal invoiceLineTotalAmount) {
        this.invoiceLineTotalAmount = invoiceLineTotalAmount;
    }

    public void recalculateBasedOnEnteredItemQty(CustomerCreditMemoDocument customerCreditMemoDocument) {
        BigDecimal invItemUnitPrice = this.getCustomerInvoiceDetail().getInvoiceItemUnitPrice();
        this.creditMemoItemTotalAmount = new KualiDecimal(this.creditMemoItemQuantity.multiply(invItemUnitPrice).setScale(2, 4));
        this.creditMemoItemTaxAmount = customerCreditMemoDocument.getArTaxService().isCustomerInvoiceDetailTaxable(customerCreditMemoDocument.getInvoice(), this.getCustomerInvoiceDetail()) ? customerCreditMemoDocument.getTaxService().getTotalSalesTaxAmount(customerCreditMemoDocument.getInvoice().getBillingDate(), customerCreditMemoDocument.getPostalCode(), this.creditMemoItemTotalAmount) : KualiDecimal.ZERO;
        this.creditMemoLineTotalAmount = (KualiDecimal)this.creditMemoItemTotalAmount.add((AbstractKualiDecimal)this.creditMemoItemTaxAmount);
    }

    public void recalculateBasedOnEnteredItemAmount(CustomerCreditMemoDocument customerCreditMemoDocument) {
        BigDecimal invItemUnitPrice = this.getCustomerInvoiceDetail().getInvoiceItemUnitPrice();
        this.creditMemoItemQuantity = this.creditMemoItemTotalAmount.bigDecimalValue().divide(invItemUnitPrice, ArConstants.ITEM_QUANTITY_SCALE, 4);
        this.creditMemoItemTaxAmount = customerCreditMemoDocument.getArTaxService().isCustomerInvoiceDetailTaxable(customerCreditMemoDocument.getInvoice(), this.getCustomerInvoiceDetail()) ? customerCreditMemoDocument.getTaxService().getTotalSalesTaxAmount(customerCreditMemoDocument.getInvoice().getBillingDate(), customerCreditMemoDocument.getPostalCode(), this.creditMemoItemTotalAmount) : KualiDecimal.ZERO;
        this.creditMemoLineTotalAmount = (KualiDecimal)this.creditMemoItemTotalAmount.add((AbstractKualiDecimal)this.creditMemoItemTaxAmount);
    }

    public KualiDecimal getDuplicateCreditMemoItemTotalAmount() {
        return this.duplicateCreditMemoItemTotalAmount;
    }

    public void setDuplicateCreditMemoItemTotalAmount(KualiDecimal duplicateCreditMemoItemTotalAmount) {
        this.duplicateCreditMemoItemTotalAmount = duplicateCreditMemoItemTotalAmount;
    }

    public BigDecimal getInvoiceOpenItemQuantity() {
        return this.invoiceOpenItemQuantity;
    }

    public void setInvoiceOpenItemQuantity(BigDecimal invoiceOpenItemQuantity) {
        this.invoiceOpenItemQuantity = invoiceOpenItemQuantity;
    }

    public String getChartOfAccountsCode() {
        return this.getCustomerInvoiceDetail().getChartOfAccountsCode();
    }

    public String getAccountNumber() {
        return this.getCustomerInvoiceDetail().getAccountNumber();
    }

    public Account getAccount() {
        this.getCustomerInvoiceDetail().refreshReferenceObject("account");
        return this.getCustomerInvoiceDetail().getAccount();
    }

    public String getFinancialObjectCode() {
        return this.getCustomerInvoiceDetail().getFinancialObjectCode();
    }

    public ObjectCode getObjectCode() {
        this.getCustomerInvoiceDetail().refreshReferenceObject("objectCode");
        return this.getCustomerInvoiceDetail().getObjectCode();
    }

    public String getOrganizationReferenceId() {
        return this.getCustomerInvoiceDetail().getOrganizationReferenceId();
    }

    public String getProjectCode() {
        return this.getCustomerInvoiceDetail().getProjectCode();
    }

    public String getReferenceNumber() {
        return this.getCustomerInvoiceDetail().getReferenceNumber();
    }

    public String getReferenceTypeCode() {
        return this.getCustomerInvoiceDetail().getReferenceTypeCode();
    }

    public String getReferenceOriginCode() {
        return this.getCustomerInvoiceDetail().getReferenceOriginCode();
    }

    public String getSubAccountNumber() {
        return this.getCustomerInvoiceDetail().getSubAccountNumber();
    }

    public String getFinancialSubObjectCode() {
        return this.getCustomerInvoiceDetail().getFinancialSubObjectCode();
    }

    public String getFinancialDocumentLineDescription() {
        return this.getCustomerInvoiceDetail().getFinancialDocumentLineDescription();
    }

    public KualiDecimal getAmount() {
        return this.getCustomerInvoiceDetail().getAmount();
    }

    public Integer getPostingYear() {
        return this.getCustomerInvoiceDetail().getPostingYear();
    }

    public String getBalanceTypeCode() {
        return this.getCustomerInvoiceDetail().getBalanceTypeCode();
    }

    public ObjectCode getAccountsReceivableObject() {
        return this.getCustomerInvoiceDetail().getAccountsReceivableObject();
    }

    public String getAccountsReceivableObjectCode() {
        return this.getCustomerInvoiceDetail().getAccountsReceivableObjectCode();
    }

    public CustomerInvoiceDetail getCustomerInvoiceDetail() {
        if (ObjectUtils.isNull((Object)this.customerInvoiceDetail) && StringUtils.isNotEmpty((CharSequence)this.financialDocumentReferenceInvoiceNumber) && ObjectUtils.isNotNull((Object)this.referenceInvoiceItemNumber)) {
            this.customerInvoiceDetail = ((CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class)).getCustomerInvoiceDetail(this.financialDocumentReferenceInvoiceNumber, this.referenceInvoiceItemNumber);
        }
        return this.customerInvoiceDetail;
    }

    public void setCustomerInvoiceDetail(CustomerInvoiceDetail customerInvoiceDetail) {
        this.customerInvoiceDetail = customerInvoiceDetail;
    }

    public String getFinancialDocumentReferenceInvoiceNumber() {
        return this.financialDocumentReferenceInvoiceNumber;
    }

    public void setFinancialDocumentReferenceInvoiceNumber(String financialDocumentReferenceInvoiceNumber) {
        this.financialDocumentReferenceInvoiceNumber = financialDocumentReferenceInvoiceNumber;
    }

    @Override
    public Integer getInvoiceItemNumber() {
        return this.referenceInvoiceItemNumber;
    }

    @Override
    public String getInvoiceReferenceNumber() {
        return this.financialDocumentReferenceInvoiceNumber;
    }

    public boolean isInvoiceOpenItemQuantityZero() {
        return this.invoiceOpenItemQuantity.compareTo(BigDecimal.ZERO) == 0;
    }

    public void setInvoiceOpenItemQuantityZero(boolean invoiceOpenItemQuantityZero) {
        this.invoiceOpenItemQuantityZero = invoiceOpenItemQuantityZero;
    }
}

